/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.propsrc;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertyColumnLabelProvider;
import org.fusesource.ide.foundation.core.functions.Function1;
import org.fusesource.ide.foundation.core.functions.Function1WithReturnType;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;
import org.fusesource.ide.foundation.ui.label.FunctionColumnLabelProvider;
import org.fusesource.ide.foundation.ui.properties.PropertyDescriptors;
import org.fusesource.ide.foundation.ui.properties.PropertySources;
import org.fusesource.ide.foundation.ui.propsrc.BeanPropertySource;
import org.fusesource.ide.foundation.ui.util.Viewers;
import org.fusesource.ide.foundation.ui.views.TableViewSupport;

public class PropertySourceTableView
extends TableViewSupport
implements IPropertySheetPage {
    public static final String ID = "org.fusesource.ide.fabric.views.PropertySourceTableView";
    private List<IPropertySource> propertySources = new ArrayList<IPropertySource>();
    private final String viewId;
    private Object input;
    private IPropertySource exemplar;

    public PropertySourceTableView(String viewId) {
        this.viewId = viewId;
    }

    public PropertySourceTableView(Class<?> beanType) {
        this(beanType.getName());
        try {
            this.exemplar = new BeanPropertySource(null, beanType);
        }
        catch (IntrospectionException e) {
            FoundationUIActivator.pluginLog().logWarning("Failed to create BeanPropertySource for " + beanType.getName() + ". " + e, (Throwable)e);
        }
    }

    public List<IPropertySource> getPropertySources() {
        return this.propertySources;
    }

    public void setPropertySources(List<IPropertySource> propertySources) {
        this.propertySources = propertySources;
        this.setInput(propertySources);
    }

    public Object getExemplar() {
        return this.exemplar;
    }

    public void setExemplar(IPropertySource exemplar) {
        this.exemplar = exemplar;
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
        Viewers.setInput((Viewer)this.getViewer(), input);
    }

    @Override
    public String getColumnConfigurationId() {
        return this.viewId;
    }

    @Override
    protected String getHelpID() {
        return ID;
    }

    @Override
    public void createControl(Composite parent) {
        this.createPartControl(parent);
    }

    @Override
    public Control getControl() {
        return this.getViewer().getControl();
    }

    @Override
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    @Override
    public void setActionBars(IActionBars actionBars) {
    }

    @Override
    protected void createColumns() {
        boolean usePropertySourceProviderIfItHasNicerRenderers;
        int bounds = 100;
        int column = 0;
        this.clearColumns();
        List<IPropertySource> list = this.propertySources;
        if (list.isEmpty() && this.exemplar != null) {
            list = new ArrayList<IPropertySource>();
            list.add(this.exemplar);
        }
        if (usePropertySourceProviderIfItHasNicerRenderers = false) {
            TreeMap<String, TableViewerColumn> headers = new TreeMap<String, TableViewerColumn>();
            for (IPropertySource object : list) {
                IPropertySource propertySource = PropertySources.asPropertySource(object);
                IPropertyDescriptor[] descriptors = propertySource.getPropertyDescriptors();
                if (descriptors == null) continue;
                IPropertyDescriptor[] iPropertyDescriptorArray = descriptors;
                int n = descriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                    Object id = descriptor.getId();
                    String header = PropertyDescriptors.getReadablePropertyName(descriptor);
                    TableViewerColumn col = (TableViewerColumn)headers.get(header);
                    if (col == null) {
                        col = this.createTableViewerColumn(header, bounds, column++);
                        headers.put(header, col);
                        IPropertySourceProvider propertySourceProvider = new IPropertySourceProvider(){

                            public IPropertySource getPropertySource(Object object) {
                                return PropertySources.asPropertySource(object);
                            }
                        };
                        col.setLabelProvider((CellLabelProvider)new PropertyColumnLabelProvider(propertySourceProvider, id));
                    }
                    ++n2;
                }
            }
        } else {
            TreeMap<String, 2> headers = new TreeMap<String, 2>();
            for (IPropertySource object : list) {
                IPropertySource propertySource = PropertySources.asPropertySource(object);
                IPropertyDescriptor[] descriptors = propertySource.getPropertyDescriptors();
                if (descriptors == null) continue;
                IPropertyDescriptor[] iPropertyDescriptorArray = descriptors;
                int n = descriptors.length;
                int n3 = 0;
                while (n3 < n) {
                    final IPropertyDescriptor descriptor = iPropertyDescriptorArray[n3];
                    final Object id = descriptor.getId();
                    String name = PropertyDescriptors.getReadablePropertyName(descriptor);
                    Function1WithReturnType function = new Function1WithReturnType(){

                        public Object apply(Object object) {
                            IPropertySource property = PropertySources.asPropertySource(object);
                            if (property != null) {
                                return property.getPropertyValue(id);
                            }
                            return null;
                        }

                        public Class<?> getReturnType() {
                            return PropertyDescriptors.getPropertyType(descriptor);
                        }
                    };
                    headers.put(name, function);
                    ++n3;
                }
            }
            int idx = 0;
            boolean pickedSortColumn = false;
            Set entrySet = headers.entrySet();
            for (Map.Entry entry : entrySet) {
                String header = (String)entry.getKey();
                if (!pickedSortColumn && this.isDefaultSortColumn(header)) {
                    this.setDefaultSortColumnIndex(idx);
                    pickedSortColumn = true;
                }
                Function1 function = (Function1)entry.getValue();
                this.addFunction(function);
                TableViewerColumn col = this.createTableViewerColumn(header, bounds, column++);
                col.setLabelProvider(this.createColumnLabelProvider(header, function));
                ++idx;
            }
        }
    }

    protected CellLabelProvider createColumnLabelProvider(String header, Function1<?, ?> function) {
        return new FunctionColumnLabelProvider(function);
    }

    protected boolean isDefaultSortColumn(String header) {
        if (header != null) {
            String lower = header.toLowerCase();
            return lower.equals("id") || lower.equals("identifier") || lower.equals("name");
        }
        return false;
    }

    @Override
    protected void configureViewer() {
        this.viewer.setInput(this.input);
    }

    @Override
    protected IStructuredContentProvider createContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                return PropertySourceTableView.this.propertySources.toArray();
            }
        };
    }

    @Override
    public void refresh() {
        for (IPropertySource propSource : this.propertySources) {
            if (!(propSource instanceof BeanPropertySource)) continue;
            ((BeanPropertySource)propSource).cleanCache();
        }
        super.refresh();
    }
}

