/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.tree;

import java.beans.IntrospectionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;
import org.fusesource.ide.foundation.ui.propsrc.BeanPropertySource;
import org.fusesource.ide.foundation.ui.tree.HasRefreshableUI;
import org.fusesource.ide.foundation.ui.tree.RefreshNodeRunnable;
import org.fusesource.ide.foundation.ui.tree.RefreshableUI;
import org.fusesource.ide.foundation.ui.util.Nodes;
import org.jboss.tools.jmx.core.tree.Node;

public abstract class NodeSupport
extends Node
implements IAdaptable,
RefreshableUI,
HasRefreshableUI,
IPropertySourceProvider,
ITabbedPropertySheetPageContributor {
    private IPropertySource propertySource;
    private Object propertyBean;

    public NodeSupport(Node parent) {
        super(parent);
    }

    public String getContributorId() {
        return "org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorer";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        if (this instanceof NodeSupport) {
            return Platform.getAdapterManager().getAdapter((Object)this, adapter);
        }
        return null;
    }

    public int compareTo(Object o) {
        String thatString = o.toString();
        return this.toString().compareTo(thatString);
    }

    public IPropertySource getPropertySource(Object object) {
        if (object != null && object != this) {
            return null;
        }
        if (object == null) {
            return null;
        }
        if (this.propertySource == null) {
            try {
                this.propertySource = this.createPropertySource();
            }
            catch (Exception e) {
                FoundationUIActivator.pluginLog().logWarning((Throwable)e);
            }
        }
        return this.propertySource;
    }

    protected IPropertySource createPropertySource() throws IntrospectionException {
        Object localPropertyBean = this.getPropertyBean();
        if (localPropertyBean == null) {
            return null;
        }
        BeanPropertySource answer = new BeanPropertySource(localPropertyBean);
        answer.setOwner(this);
        return answer;
    }

    protected Object getPropertyBean() {
        if (this.propertyBean == null) {
            this.propertyBean = this.createPropertyBean();
        }
        return this.propertyBean;
    }

    protected Object createPropertyBean() {
        return null;
    }

    public IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            try {
                this.propertySource = this.createPropertySource();
            }
            catch (IntrospectionException e) {
                FoundationUIActivator.pluginLog().logWarning("Failed to create PropertySource for " + this + ". " + e, (Throwable)e);
            }
        }
        return this.propertySource;
    }

    public void setPropertySource(IPropertySource propertySource) {
        this.propertySource = propertySource;
    }

    public void setPropertyBean(Object propertyBean) {
        this.propertyBean = propertyBean;
    }

    protected void refreshParent() {
        Nodes.refreshParent(this);
    }

    @Override
    public RefreshableUI getRefreshableUI() {
        return this;
    }

    @Override
    public void fireRefresh() {
        Display.getDefault().syncExec((Runnable)new RefreshNodeRunnable(this));
    }

    @Override
    public void fireRefresh(Object node, boolean full) {
        this.fireRefresh();
    }

    public boolean isConnectionAvailable() {
        return this.getConnection() != null && this.getConnection().getProvider() != null && this.getConnection().isConnected();
    }
}

