/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.tree;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;
import org.fusesource.ide.foundation.ui.tree.HasRefreshableUI;
import org.fusesource.ide.foundation.ui.tree.NodeSupport;
import org.fusesource.ide.foundation.ui.tree.Refreshable;
import org.fusesource.ide.foundation.ui.tree.RefreshableUI;
import org.fusesource.ide.foundation.ui.util.Nodes;
import org.jboss.tools.jmx.core.tree.Node;

public abstract class RefreshableNode
extends NodeSupport
implements Refreshable {
    private AtomicBoolean loaded = new AtomicBoolean(false);
    private boolean loading;

    public RefreshableNode(Node parent) {
        super(parent);
    }

    @Override
    public void refresh() {
        this.clearChildren();
        this.loadChildren();
        this.refreshUI();
    }

    public boolean removeChild(Node child) {
        boolean answer = super.removeChild(child);
        if (answer) {
            this.refreshParentUI();
        }
        return answer;
    }

    protected void refreshUI() {
        RefreshableUI ui = this.getRefreshableUI();
        if (ui != null) {
            ui.fireRefresh(this, false);
        } else {
            FoundationUIActivator.pluginLog().logWarning("Could not find RefreshableUI for " + this);
        }
        Nodes.refreshSelection(this);
    }

    protected void refreshParentUI() {
        Node p = this.getParent();
        if (p instanceof RefreshableNode) {
            RefreshableNode pr = (RefreshableNode)p;
            pr.refreshUI();
        } else {
            this.refreshUI();
        }
    }

    public Node[] getChildren() {
        this.checkLoaded();
        return super.getChildren();
    }

    public List<Node> getChildrenList() {
        this.checkLoaded();
        return super.getChildrenList();
    }

    protected synchronized void checkLoaded() {
        if (!this.loaded.get()) {
            this.loading = true;
            try {
                try {
                    if (!this.isConnectionAvailable()) {
                        throw new IllegalStateException("The connection is not available.");
                    }
                    this.loadChildren();
                    this.refreshUIAfterLazyLoad();
                }
                catch (Exception e) {
                    FoundationUIActivator.pluginLog().logWarning("Failed to load children of " + this + ". " + e, (Throwable)e);
                    this.loaded.compareAndSet(false, false);
                    this.loading = false;
                    return;
                }
            }
            finally {
                this.loading = false;
            }
            this.loaded.compareAndSet(false, true);
        }
    }

    protected void refreshUIAfterLazyLoad() {
    }

    public boolean isLoaded() {
        return this.loaded.get();
    }

    protected boolean isLoading() {
        return this.loading;
    }

    protected abstract void loadChildren();

    @Override
    public RefreshableUI getRefreshableUI() {
        if (this instanceof RefreshableUI) {
            return this;
        }
        if (this.parent != null && this.parent instanceof HasRefreshableUI) {
            return ((HasRefreshableUI)this.parent).getRefreshableUI();
        }
        return null;
    }
}

