/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.util;

import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;

public class DialogUtils {
    public static void showUserError(String pluginId, final String title, final String message, Exception e) {
        Throwable t = DialogUtils.unwrapException(e);
        String text = t.getMessage();
        Status errorStatus = new Status(4, pluginId, 4, text, (Throwable)e);
        Display.getDefault().asyncExec(new Runnable((IStatus)errorStatus){
            private final /* synthetic */ IStatus val$errorStatus;
            {
                this.val$errorStatus = iStatus;
            }

            @Override
            public void run() {
                ErrorDialog.openError((Shell)DialogUtils.getShell(), (String)title, (String)message, (IStatus)this.val$errorStatus);
            }
        });
        FoundationUIActivator.pluginLog().logError(String.valueOf(message) + ". Exception: " + text, (Throwable)e);
    }

    public static Throwable unwrapException(Exception e) {
        if (e instanceof JAXBException) {
            JAXBException jaxbe = (JAXBException)e;
            return jaxbe.getLinkedException();
        }
        return e;
    }

    public static Shell getShell() {
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench;
        Shell answer = null;
        Display current = Display.getCurrent();
        if (current != null) {
            answer = current.getActiveShell();
        }
        if (answer == null && (workbench = PlatformUI.getWorkbench()) != null && (activeWorkbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            answer = activeWorkbenchWindow.getShell();
        }
        return answer;
    }

    public static Display getDisplay() {
        Display display;
        Shell shell = DialogUtils.getShell();
        if (shell == null || shell.isDisposed()) {
            display = Display.getCurrent();
            Assert.isNotNull((Object)display, (String)"The dialog should be created in UI thread");
        } else {
            display = shell.getDisplay();
        }
        return display;
    }
}

