/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IPageSite;
import org.fusesource.ide.foundation.ui.tree.HasViewer;
import org.fusesource.ide.foundation.ui.tree.RefreshableUI;
import org.fusesource.ide.foundation.ui.util.Viewers;
import org.fusesource.ide.foundation.ui.util.Workbenches;

public class Selections {
    private Selections() {
    }

    public static Object getFirstSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return structuredSelection.getFirstElement();
        }
        return null;
    }

    public static List<Object> getSelectionList(Viewer viewer) {
        ISelection selection;
        ArrayList<Object> answer = new ArrayList<Object>();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object next : structuredSelection) {
                answer.add(next);
            }
        }
        return answer;
    }

    public static Object getFirstSelection(Viewer viewer) {
        if (viewer != null) {
            return Selections.getFirstSelection(viewer.getSelection());
        }
        return null;
    }

    public static Object getFirstSelection(IWorkbenchSite viewSite) {
        ISelectionProvider selectionProvider;
        if (viewSite != null && (selectionProvider = viewSite.getSelectionProvider()) != null) {
            return Selections.getFirstSelection(selectionProvider.getSelection());
        }
        return null;
    }

    public static ISelection getSelection(IWorkbenchSite site) {
        if (site != null) {
            return Selections.getSelection(site.getSelectionProvider());
        }
        return null;
    }

    protected static ISelection getSelection(ISelectionProvider selectionProvider) {
        if (selectionProvider != null) {
            return selectionProvider.getSelection();
        }
        return null;
    }

    public static IStructuredSelection getStructuredSelection(Viewer site) {
        ISelection selection = Selections.getSelection((ISelectionProvider)site);
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public static IStructuredSelection getStructuredSelection(IPageSite site) {
        ISelection selection = Selections.getSelection((IWorkbenchSite)site);
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public static IStructuredSelection getStructuredSelection(IWorkbenchPartSite site) {
        ISelection selection = Selections.getSelection((IWorkbenchSite)site);
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public static ISelectionProvider getSelectionProvider(IViewSite viewSite) {
        if (viewSite != null) {
            return viewSite.getSelectionProvider();
        }
        return null;
    }

    public static ISelectionProvider getSelectionProvider(IViewPart view) {
        if (view != null) {
            return Selections.getSelectionProvider(view.getViewSite());
        }
        return null;
    }

    public static ISelectionProvider getSelectionProvider(IWorkbenchPart workbenchPart) {
        if (workbenchPart != null) {
            return Selections.getSelectionProvider(workbenchPart.getSite());
        }
        return null;
    }

    public static ISelectionProvider getSelectionProvider(IWorkbenchPartSite site) {
        if (site != null) {
            return site.getSelectionProvider();
        }
        return null;
    }

    public static void setSingleSelection(RefreshableUI refreshableUI, Object singleValue) {
        HasViewer v;
        Viewer viewer;
        if (refreshableUI instanceof HasViewer && (viewer = (v = (HasViewer)((Object)refreshableUI)).getViewer()) != null) {
            viewer.setSelection((ISelection)new StructuredSelection(singleValue));
            Viewers.reveal(viewer, singleValue);
        }
    }

    public static void setSelection(RefreshableUI refreshableUI, ISelection selection) {
        HasViewer v;
        Viewer viewer;
        if (refreshableUI instanceof HasViewer && (viewer = (v = (HasViewer)((Object)refreshableUI)).getViewer()) != null) {
            viewer.setSelection(selection);
        }
    }

    public static Object getFirstWorkbenchSelection() {
        Object firstSelection = null;
        IWorkbenchPage page = Workbenches.getActiveWorkbenchPage();
        if (page != null) {
            firstSelection = Selections.getFirstSelection(page.getSelection());
        }
        return firstSelection;
    }

    public static ISelection getWorkbenchSelection() {
        IWorkbenchPage page = Workbenches.getActiveWorkbenchPage();
        if (page != null) {
            return page.getSelection();
        }
        return null;
    }

    public static boolean selectionIs(Viewer viewer, Object singleSelection) {
        List<Object> list = Selections.getSelectionList(viewer);
        if (list.size() == 1) {
            Object current = list.get(0);
            return current == singleSelection;
        }
        return false;
    }
}

