/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.views;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.PageSite;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.ui.internal.FoundationUIActivator;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.foundation.ui.views.TabFolderSupport2;

public class DynamicPropertySheetTracker {
    public static final String PROPERTIES_VIEW_ID = "org.eclipse.ui.views.PropertySheet";
    private static final boolean compareInstances = true;
    private Class<?> oldPageType = PropertySheetPage.class;
    private IPropertySheetPage oldPage;

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        boolean isNew;
        PropertySheet propertySheet = this.getPropertySheet();
        if (propertySheet == null) {
            return;
        }
        Object answer = null;
        Object first = Selections.getFirstSelection(selection);
        if (first instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)first;
            answer = (IPropertySheetPage)adaptable.getAdapter(IPropertySheetPage.class);
        }
        if (answer == null) {
            answer = new PropertySheetPage();
        }
        Class<?> newPageType = answer.getClass();
        boolean bl = isNew = !Objects.equal((Object)answer, (Object)this.oldPage);
        if (isNew) {
            this.changePropertySheet((IPropertySheetPage)answer, propertySheet, part, selection);
            this.oldPage = answer;
            return;
        }
    }

    private void changePropertySheet(IPropertySheetPage page, PropertySheet propertySheet, IWorkbenchPart part, ISelection selection) {
        if (part != null) {
            propertySheet.partClosed(part);
            propertySheet.partActivated(part);
            IPage currentPage = propertySheet.getCurrentPage();
            IPropertySheetPage selectionPage = page;
            if (currentPage instanceof IPropertySheetPage) {
                selectionPage = (IPropertySheetPage)currentPage;
                page.dispose();
            }
            if (selectionPage instanceof TabFolderSupport2) {
                TabFolderSupport2 tfs = (TabFolderSupport2)selectionPage;
                tfs.init(propertySheet);
            } else {
                boolean initSelectionPage = false;
                if (selectionPage instanceof Page) {
                    Page p = (Page)selectionPage;
                    if (initSelectionPage) {
                        IViewSite viewSite = propertySheet.getViewSite();
                        p.init((IPageSite)new PageSite(viewSite));
                    }
                }
            }
            if (selection != null) {
                selectionPage.selectionChanged(part, selection);
            }
        }
    }

    protected PropertySheet getPropertySheet() {
        IWorkbenchPage page;
        IWorkbenchWindow wbw;
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb != null && (wbw = wb.getActiveWorkbenchWindow()) != null && (page = wbw.getActivePage()) != null) {
            try {
                IViewPart view = page.findView(PROPERTIES_VIEW_ID);
                if (view instanceof PropertySheet) {
                    return (PropertySheet)view;
                }
            }
            catch (Exception ex) {
                FoundationUIActivator.pluginLog().logError((Throwable)ex);
            }
        }
        return null;
    }
}

