/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.fusesource.ide.foundation.core.functions.Function1;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.ui.chart.TableChartColumnInfo;
import org.fusesource.ide.foundation.ui.chart.TableChartDialog;
import org.fusesource.ide.foundation.ui.chart.TableChartOptions;
import org.fusesource.ide.foundation.ui.config.ColumnConfiguration;
import org.fusesource.ide.foundation.ui.config.TableConfiguration;
import org.fusesource.ide.foundation.ui.label.FunctionColumnLabelProvider;
import org.fusesource.ide.foundation.ui.label.WrappedCellLabelProvider;
import org.fusesource.ide.foundation.ui.util.Tables;
import org.fusesource.ide.foundation.ui.util.Viewers;
import org.fusesource.ide.foundation.ui.util.Widgets;
import org.fusesource.ide.foundation.ui.views.ColumnViewSupport;
import org.fusesource.ide.foundation.ui.views.TextViewFilter;

public abstract class TableViewSupport
extends ColumnViewSupport {
    protected TableViewer viewer;
    private Composite parent;
    private TextViewFilter filter = new TextViewFilter();
    private ColumnViewSupport.ColumnFunctionComparator comparator = new ColumnViewSupport.ColumnFunctionComparator(this);
    private List<String> columnNames;
    private boolean showSearchBox = true;
    private Composite inner;
    private Composite disposeInner;
    private Text searchText;

    protected abstract void createColumns();

    protected abstract void configureViewer();

    protected abstract IStructuredContentProvider createContentProvider();

    @Override
    public List<String> getColumns() {
        if (this.columnNames == null) {
            Table table;
            this.columnNames = new ArrayList<String>();
            if (this.viewer != null && (table = this.viewer.getTable()) != null) {
                TableColumn[] tableColumns;
                TableColumn[] tableColumnArray = tableColumns = table.getColumns();
                int n = tableColumns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    try {
                        String name = column.getText();
                        this.columnNames.add(name);
                    }
                    catch (Exception exception) {}
                    ++n2;
                }
            }
        }
        return this.columnNames;
    }

    @Override
    public void updateColumnConfiguration(TableConfiguration configuration) {
        this.setConfiguration(configuration);
        Tables.disposeColumns(this.viewer);
        this.recreateColumns();
        this.getViewer().refresh(true);
    }

    protected void recreateColumns() {
        this.setConfiguration(null);
        this.createColumns();
        this.columnNames = null;
        this.getColumns();
        this.reorderColumns();
        this.getConfiguration().addColumnListeners(this.getViewer());
    }

    @Override
    public void createPartControl(Composite parent) {
        String initialSearchText;
        boolean useNestedComposite;
        this.parent = parent;
        Widgets.dispose((Widget)this.disposeInner);
        this.disposeInner = null;
        GridLayout layout = new GridLayout(2, false);
        Layout parentLayout = parent.getLayout();
        boolean bl = useNestedComposite = parentLayout != null && !(parentLayout instanceof FillLayout) && !(parentLayout instanceof GridLayout);
        if (useNestedComposite) {
            this.disposeInner = this.inner = new Composite(parent, 0);
        } else {
            this.inner = parent;
        }
        this.inner.setLayout((Layout)layout);
        if (useNestedComposite && parentLayout instanceof GridLayout) {
            this.inner.setLayoutData((Object)new GridData(1808));
        }
        if (this.isShowSearchBox()) {
            Label searchLabel = new Label(this.inner, 0);
            searchLabel.setText("Search: ");
            this.searchText = new Text(this.inner, 2176);
            this.searchText.setLayoutData((Object)new GridData(768));
            this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent ke) {
                    TableViewSupport.this.setFilterText(TableViewSupport.this.searchText.getText());
                }
            });
        }
        this.createViewer();
        if (this.isShowSearchBox() && (initialSearchText = this.getInitialSearchText()) != null && initialSearchText.length() > 0) {
            this.setFilterText(initialSearchText);
            if (this.searchText != null) {
                this.searchText.setText(initialSearchText);
            }
        }
        this.makeActions();
    }

    protected String getInitialSearchText() {
        return "";
    }

    protected Text getSearchText() {
        return this.searchText;
    }

    protected void setFilterText(String text) {
        this.filter.setSearchText(text);
        this.onFilterChanged();
    }

    protected void onFilterChanged() {
        Viewers.refresh((Viewer)this.viewer);
    }

    protected void createViewer() {
        if (this.viewer != null) {
            this.viewer.getControl().dispose();
        }
        this.viewer = new TableViewer(this.inner, 67586);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.recreateColumns();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.setComparator((ViewerComparator)this.comparator);
        this.configureViewer();
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        gridData.heightHint = 300;
        gridData.widthHint = 500;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.chartOptions = this.createChartOptions();
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getHelpSystem().setHelp(this.viewer.getControl(), this.getHelpID());
        this.hookDoubleClickAction();
        this.setSelectionProvider();
        this.parent.layout(true);
    }

    private void reorderColumns() {
        if (this.getConfiguration() == null || !this.getConfiguration().hasColumns()) {
            return;
        }
        Table table = this.viewer.getTable();
        if (!Widgets.isValid((Widget)table)) {
            return;
        }
        HashMap<String, Object> columnMap = new HashMap<String, Object>();
        HashMap<String, Integer> columnIndexes = new HashMap<String, Integer>();
        ArrayList<String> columnNameOrderList = new ArrayList<String>();
        ArrayList<Integer> columnOrderList = new ArrayList<Integer>();
        TableColumn[] columnArray = Tables.getColumns(table);
        int i = 0;
        int size = columnArray.length;
        while (i < size) {
            TableColumn column = columnArray[i];
            String name = column.getText();
            columnMap.put(name, column);
            columnIndexes.put(name, i);
            ++i;
        }
        List<ColumnConfiguration> list = this.getConfiguration().getColumnConfigurations();
        for (ColumnConfiguration config : list) {
            Integer index;
            int width;
            String columnName = config.getName();
            boolean columnVisibility = config.isVisible();
            TableColumn column = (TableColumn)columnMap.get(columnName);
            if (!columnVisibility) {
                Widgets.dispose((Widget)column);
                continue;
            }
            if (column == null) continue;
            if (!columnNameOrderList.contains(columnName)) {
                columnNameOrderList.add(columnName);
            }
            if ((width = config.getWidth()) > 0) {
                column.setWidth(width);
            }
            if ((index = (Integer)columnIndexes.get(columnName)) == null) continue;
            int idx = index;
            CellLabelProvider oldLabelProvider = this.getCellLabelProvider(idx);
            TableViewerColumn viewerColumn = Tables.getTableViewerColumn(column);
            this.configureLabelProvider((ViewerColumn)viewerColumn, config, oldLabelProvider);
        }
        columnArray = table.getColumns();
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
        int i2 = 0;
        int size2 = columnArray.length;
        while (i2 < size2) {
            TableColumn column = columnArray[i2];
            String name = column.getText();
            indexMap.put(name, i2);
            ++i2;
        }
        for (String columnName : columnNameOrderList) {
            Integer i3 = (Integer)indexMap.get(columnName);
            if (i3 == null) continue;
            columnOrderList.add(i3);
        }
        int[] columnOrder = table.getColumnOrder();
        int i4 = 0;
        int size3 = columnOrder.length;
        while (i4 < size3) {
            TableColumn column;
            int idx = columnOrder[i4];
            Integer key = idx;
            if (idx >= 0 && idx < columnArray.length && !columnOrderList.contains(key) && (column = columnArray[i4]) != null && !column.isDisposed()) {
                columnOrderList.add(key);
            }
            ++i4;
        }
        int[] newColumnOrder = new int[columnOrderList.size()];
        int idx = 0;
        for (Integer key : columnOrderList) {
            newColumnOrder[idx++] = key;
        }
        table.setColumnOrder(newColumnOrder);
    }

    protected void setDefaultSortColumnIndex(int idx) {
        this.comparator.setDefaultSortColumn(idx);
    }

    @Override
    protected TableChartOptions createChartOptions() {
        TableChartOptions options = new TableChartOptions();
        Table table = this.viewer.getTable();
        int i = 0;
        int size = table.getColumnCount();
        while (i < size) {
            CellLabelProvider labelProvider = this.getCellLabelProvider(i);
            Class returnType = Objects.getReturnType((Object)labelProvider);
            if (Objects.isNumberType((Class)returnType)) {
                TableColumn column = table.getColumn(i);
                options.addNumericColumn(new TableChartColumnInfo((Item)column, labelProvider));
            }
            ++i;
        }
        return options;
    }

    protected CellLabelProvider getCellLabelProvider(int idx) {
        CellLabelProvider oldLabelProvider = this.viewer.getLabelProvider(idx);
        if (oldLabelProvider instanceof WrappedCellLabelProvider) {
            WrappedCellLabelProvider wrapped = (WrappedCellLabelProvider)oldLabelProvider;
            oldLabelProvider = wrapped.getWrappedLabelProvider();
        }
        return oldLabelProvider;
    }

    protected TableViewerColumn createTableViewerColumn(String title, int bound, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, colNumber));
        return viewerColumn;
    }

    protected int addColumnFunction(int bounds, int column, Function1<Object, ?> function, String columnName) {
        this.addFunction(function);
        TableViewerColumn col = this.createTableViewerColumn(columnName, bounds, column++);
        col.setLabelProvider((CellLabelProvider)new FunctionColumnLabelProvider(function));
        return column;
    }

    protected int addColumnFunction(int bounds, int column, Function1<Object, Object> function, String columnName, CellLabelProvider labelProvider) {
        this.addFunction(function);
        TableViewerColumn col = this.createTableViewerColumn(columnName, bounds, column++);
        col.setLabelProvider(labelProvider);
        return column;
    }

    protected SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableViewSupport.this.comparator.setColumn(index);
                if (Viewers.isValid((Viewer)TableViewSupport.this.viewer)) {
                    int dir = TableViewSupport.this.viewer.getTable().getSortDirection();
                    dir = TableViewSupport.this.viewer.getTable().getSortColumn() == column ? (dir == 128 ? 1024 : 128) : 1024;
                    TableViewSupport.this.viewer.getTable().setSortDirection(dir);
                    TableViewSupport.this.viewer.getTable().setSortColumn(column);
                    TableViewSupport.this.viewer.refresh();
                }
            }
        };
    }

    public ColumnViewSupport.ColumnFunctionComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(ColumnViewSupport.ColumnFunctionComparator comparator) {
        this.comparator = comparator;
    }

    @Override
    protected void showChartDialog() {
        TableChartDialog dialog = new TableChartDialog(this);
        dialog.open();
    }

    public Table getTable() {
        return this.viewer.getTable();
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public boolean isShowSearchBox() {
        return this.showSearchBox;
    }

    public void setShowSearchBox(boolean showSearchBox) {
        this.showSearchBox = showSearchBox;
    }
}

