/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.ui.debug.editors;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.launcher.debug.model.variables.BaseWriteableCamelBooleanVariable;
import org.fusesource.ide.launcher.ui.Activator;
import org.fusesource.ide.launcher.ui.debug.editors.BooleanVariableEditor;

public class VariableValueEditor
implements IVariableValueEditor {
    public boolean editVariable(IVariable variable, Shell shell) {
        try {
            if (variable instanceof BaseWriteableCamelBooleanVariable) {
                BaseWriteableCamelBooleanVariable var = (BaseWriteableCamelBooleanVariable)variable;
                IValue value = variable.getValue();
                BooleanVariableEditor editor = new BooleanVariableEditor(shell, "Edit value...", "Please select the new value...", Boolean.parseBoolean(value.getValueString()));
                if (editor.open() == 0 && Boolean.parseBoolean(value.getValueString()) != editor.getValue()) {
                    var.setValue(Boolean.toString(editor.getValue()));
                }
                return true;
            }
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return false;
    }

    public boolean saveVariable(IVariable variable, String expression, Shell shell) {
        try {
            if (variable instanceof BaseWriteableCamelBooleanVariable) {
                IValue value = variable.getValue();
                ((BaseWriteableCamelBooleanVariable)value).setValue(expression);
                return true;
            }
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
        return false;
    }
}

