/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.ui.tabs;

import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.launcher.ui.Activator;
import org.fusesource.ide.launcher.util.SecureStorageUtil;

public class DebugJmxTab
extends AbstractLaunchConfigurationTab {
    private Label jmxUriLabel;
    private Label jmxUserLabel;
    private Label jmxPasswdLabel;
    private Text jmxUriText;
    private Text jmxUserText;
    private Text jmxPasswdText;

    public Image getImage() {
        return Activator.getDefault().getImage("camel.png");
    }

    public void createControl(Composite parent) {
        Composite c = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)1808);
        this.setControl((Control)c);
        Group group = SWTFactory.createGroup((Composite)c, (String)"Specify the JMX connection details...", (int)2, (int)1, (int)768);
        this.jmxUriLabel = SWTFactory.createLabel((Composite)group, (String)"JMX Uri:", (int)1);
        this.jmxUriText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.jmxUriText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugJmxTab.this.setDirty(true);
                DebugJmxTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.jmxUserLabel = SWTFactory.createLabel((Composite)group, (String)"JMX User:", (int)1);
        this.jmxUserText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.jmxUserText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugJmxTab.this.setDirty(true);
                DebugJmxTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.jmxPasswdLabel = SWTFactory.createLabel((Composite)group, (String)"JMX Password:", (int)1);
        this.jmxPasswdText = SWTFactory.createText((Composite)group, (int)0x400000, (int)1);
        this.jmxPasswdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DebugJmxTab.this.setDirty(true);
                DebugJmxTab.this.updateLaunchConfigurationDialog();
            }
        });
        Dialog.applyDialogFont((Control)parent);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.fusesource.ide.launcher.debug.jmx.uri", "service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi/camel");
        configuration.setAttribute("org.fusesource.ide.launcher.debug.jmx.user", null);
        this.setPassword((ILaunchConfiguration)configuration, "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String jmxUri = configuration.getAttribute("org.fusesource.ide.launcher.debug.jmx.uri", "service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi/camel");
            String jmxUser = configuration.getAttribute("org.fusesource.ide.launcher.debug.jmx.user", "");
            String jmxPasswd = this.getPassword(configuration);
            this.jmxUriText.setText(jmxUri);
            this.jmxUserText.setText(jmxUser);
            this.jmxPasswdText.setText(jmxPasswd);
        }
        catch (CoreException coreException) {
            this.jmxUriText.setText("service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi/camel");
            this.jmxUserText.setText("");
            this.jmxPasswdText.setText("");
        }
        this.updateLaunchConfigurationDialog();
    }

    private String getPassword(ILaunchConfiguration configuration) {
        String s = SecureStorageUtil.getFromSecureStorage((String)org.fusesource.ide.launcher.Activator.getBundleID(), (ILaunchConfiguration)configuration, (String)"org.fusesource.ide.launcher.debug.jmx.passwd");
        if (s == null) {
            return "";
        }
        return s;
    }

    private void setPassword(ILaunchConfiguration configuration, String pass) {
        try {
            SecureStorageUtil.storeInSecureStorage((String)org.fusesource.ide.launcher.Activator.getBundleID(), (ILaunchConfiguration)configuration, (String)"org.fusesource.ide.launcher.debug.jmx.passwd", (String)pass);
        }
        catch (StorageException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, org.fusesource.ide.launcher.Activator.getBundleID(), "Could not save password for JMX in secure storage.", (Throwable)e));
        }
        catch (UnsupportedEncodingException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, org.fusesource.ide.launcher.Activator.getBundleID(), "Could not save password for JMX in secure storage.", (Throwable)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.fusesource.ide.launcher.debug.jmx.uri", this.jmxUriText.getText().trim());
        configuration.setAttribute("org.fusesource.ide.launcher.debug.jmx.user", this.jmxUserText.getText().trim());
        this.setPassword((ILaunchConfiguration)configuration, this.jmxPasswdText.getText().trim());
        this.setDirty(false);
    }

    public String getName() {
        return "JMX";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.jmxUriText.getText().trim().length() > 0;
    }

    public boolean canSave() {
        return this.isValid(null);
    }
}

