/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.generator;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.UserCancelledException;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.ModelGenerator;
import org.teiid.designer.compare.ModelerComparePlugin;

public abstract class AbstractModelGenerator
implements ModelGenerator {
    private final List matcherFactories;
    private String description;
    private final List differenceReports = new LinkedList();
    private Map producedToOutputMapping;
    private boolean isNewModelCase = false;
    private boolean saveAllBeforeFinish = false;

    public AbstractModelGenerator(List matcherFactories) {
        this.matcherFactories = matcherFactories != null ? matcherFactories : Collections.EMPTY_LIST;
        this.producedToOutputMapping = new HashMap();
    }

    public void setProducedToOutputMapping(Map mapping) {
        this.producedToOutputMapping = mapping != null ? mapping : new HashMap();
    }

    public Map getProducedToOutputMapping() {
        return this.producedToOutputMapping;
    }

    @Override
    public String getDescription() {
        if (this.description != null && this.description.trim().length() != 0) {
            return this.description;
        }
        String desc = this.getDefaultDescription();
        if (desc != null && desc.trim().length() != 0) {
            return desc;
        }
        return "the operation";
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public IStatus execute(IProgressMonitor progressMonitor) {
        LinkedList<IStatus> problems;
        block18: {
            problems = new LinkedList<IStatus>();
            IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
            IStatus diffStatus = null;
            try {
                this.doClearDifferenceReports();
                this.doGenerateOutput(monitor, problems);
                diffStatus = this.createStatus(problems);
            }
            catch (UserCancelledException userCancelledException) {
                diffStatus = this.newUserCancelledStatus();
            }
            if (diffStatus.getSeverity() == 4) {
                return diffStatus;
            }
            problems.add(diffStatus);
            try {
                this.doComputeDifferenceReport(monitor, problems);
                if (this.differenceReports.size() != 0) {
                    this.doPostProcessDifferenceReports();
                }
                diffStatus = this.createStatus(problems);
            }
            catch (UserCancelledException userCancelledException) {
                diffStatus = this.newUserCancelledStatus();
            }
            if (diffStatus.getSeverity() == 4) {
                return diffStatus;
            }
            problems.add(diffStatus);
            try {
                try {
                    this.doMergeOutputIntoOriginal(monitor, problems);
                    this.doPostMerge();
                }
                catch (UserCancelledException userCancelledException) {
                    IStatus mergeStatus = this.newUserCancelledStatus();
                    problems.addFirst(mergeStatus);
                    try {
                        monitor.done();
                    }
                    catch (RuntimeException e) {
                        ModelerComparePlugin.Util.log((Throwable)e);
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    monitor.done();
                }
                catch (RuntimeException e) {
                    ModelerComparePlugin.Util.log((Throwable)e);
                }
                throw throwable;
            }
            try {
                monitor.done();
            }
            catch (RuntimeException e) {
                ModelerComparePlugin.Util.log((Throwable)e);
            }
        }
        return this.createStatus(problems);
    }

    @Override
    public IStatus generateOutput(IProgressMonitor progressMonitor) {
        LinkedList<IStatus> problems;
        block11: {
            IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
            problems = new LinkedList<IStatus>();
            try {
                try {
                    this.doClearDifferenceReports();
                    this.doGenerateOutput(monitor, problems);
                }
                catch (UserCancelledException userCancelledException) {
                    IStatus status = this.newUserCancelledStatus();
                    problems.addFirst(status);
                    try {
                        monitor.done();
                    }
                    catch (RuntimeException e) {
                        ModelerComparePlugin.Util.log((Throwable)e);
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    monitor.done();
                }
                catch (RuntimeException e) {
                    ModelerComparePlugin.Util.log((Throwable)e);
                }
                throw throwable;
            }
            try {
                monitor.done();
            }
            catch (RuntimeException e) {
                ModelerComparePlugin.Util.log((Throwable)e);
            }
        }
        return this.createStatus(problems);
    }

    @Override
    public IStatus computeDifferenceReport(IProgressMonitor progressMonitor) {
        LinkedList<IStatus> problems;
        block12: {
            IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
            problems = new LinkedList<IStatus>();
            try {
                try {
                    this.doComputeDifferenceReport(monitor, problems);
                    if (this.differenceReports.size() != 0) {
                        this.doPostProcessDifferenceReports();
                    }
                }
                catch (UserCancelledException userCancelledException) {
                    IStatus status = this.newUserCancelledStatus();
                    problems.addFirst(status);
                    try {
                        monitor.done();
                    }
                    catch (RuntimeException e) {
                        ModelerComparePlugin.Util.log((Throwable)e);
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    monitor.done();
                }
                catch (RuntimeException e) {
                    ModelerComparePlugin.Util.log((Throwable)e);
                }
                throw throwable;
            }
            try {
                monitor.done();
            }
            catch (RuntimeException e) {
                ModelerComparePlugin.Util.log((Throwable)e);
            }
        }
        return this.createStatus(problems);
    }

    @Override
    public List getAllDifferenceReports() {
        return this.differenceReports;
    }

    @Override
    public List getDifferenceReports() {
        return this.getAllDifferenceReports();
    }

    protected void addDifferenceReport(DifferenceReport report) {
        this.differenceReports.add(report);
    }

    public List getEObjectMatcherFactories() {
        return this.matcherFactories;
    }

    @Override
    public IStatus mergeOutputIntoOriginal(IProgressMonitor progressMonitor) {
        LinkedList<IStatus> problems;
        block11: {
            IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
            problems = new LinkedList<IStatus>();
            try {
                try {
                    this.doMergeOutputIntoOriginal(monitor, problems);
                    this.doPostMerge();
                }
                catch (UserCancelledException userCancelledException) {
                    IStatus mergeStatus = this.newUserCancelledStatus();
                    problems.addFirst(mergeStatus);
                    try {
                        monitor.done();
                    }
                    catch (RuntimeException e) {
                        ModelerComparePlugin.Util.log((Throwable)e);
                    }
                    break block11;
                }
            }
            catch (Throwable throwable) {
                try {
                    monitor.done();
                }
                catch (RuntimeException e) {
                    ModelerComparePlugin.Util.log((Throwable)e);
                }
                throw throwable;
            }
            try {
                monitor.done();
            }
            catch (RuntimeException e) {
                ModelerComparePlugin.Util.log((Throwable)e);
            }
        }
        return this.createStatus(problems);
    }

    @Override
    public void close() {
    }

    protected void doClearDifferenceReports() {
        this.getAllDifferenceReports().clear();
        this.producedToOutputMapping.clear();
    }

    protected abstract void doGenerateOutput(IProgressMonitor var1, LinkedList var2) throws UserCancelledException;

    protected abstract void doComputeDifferenceReport(IProgressMonitor var1, LinkedList var2) throws UserCancelledException;

    protected abstract void doPostProcessDifferenceReports();

    protected void doPostMerge() {
    }

    protected abstract void doReresolveAndRebuildImports();

    protected abstract void doMergeOutputIntoOriginal(IProgressMonitor var1, LinkedList var2) throws UserCancelledException;

    protected String getDefaultDescription() {
        return ModelerComparePlugin.Util.getString("AbstractModelGenerator.Default_description", new Object[0]);
    }

    protected IStatus newUserCancelledStatus() {
        Object[] params = new Object[]{this.getDescription()};
        String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.User_cancelled_operation", params);
        Status status = new Status(2, "org.teiid.designer.compare", 58003, msg, null);
        return status;
    }

    protected IStatus newSuccessStatus() {
        Object[] params = new Object[]{this.getDescription()};
        String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Success_msg", params);
        Status status = new Status(2, "org.teiid.designer.compare", 58003, msg, null);
        return status;
    }

    protected IStatus createStatus(List problems) {
        IStatus resultStatus = null;
        if (problems == null || problems.isEmpty()) {
            Object[] params = new Object[]{this.getDescription()};
            String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Completed_generation", params);
            Status status = new Status(0, "org.teiid.designer.compare", 58004, msg, null);
            resultStatus = status;
        } else if (problems.size() == 1) {
            resultStatus = (IStatus)problems.get(0);
        } else {
            int numErrors = 0;
            int numWarnings = 0;
            for (IStatus aStatus : problems) {
                if (aStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (aStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] statusArray = problems.toArray(new IStatus[problems.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                Object[] params = new Object[]{this.getDescription(), new Integer(numWarnings)};
                String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Completed_generation_with_warning(s)", params);
                resultStatus = new MultiStatus("org.teiid.designer.compare", 58005, statusArray, msg, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                Object[] params = new Object[]{this.getDescription(), new Integer(numErrors)};
                String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Completed_generation_with_error(s)", params);
                resultStatus = new MultiStatus("org.teiid.designer.compare", 58006, statusArray, msg, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                Object[] params = new Object[]{this.getDescription(), new Integer(numErrors), new Integer(numWarnings)};
                String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Completed_generation_with_error(s)_and_warning(s)", params);
                resultStatus = new MultiStatus("org.teiid.designer.compare", 58007, statusArray, msg, null);
            } else {
                Object[] params = new Object[]{this.getDescription()};
                String msg = ModelerComparePlugin.Util.getString("AbstractModelGenerator.Completed_generation_with_no_errors_or_warnings", params);
                resultStatus = new MultiStatus("org.teiid.designer.compare", 58008, statusArray, msg, null);
            }
        }
        return resultStatus;
    }

    @Override
    public boolean isNewModelCase() {
        return this.isNewModelCase;
    }

    @Override
    public void setNewModelCase(boolean theIsNewModelCase) {
        this.isNewModelCase = theIsNewModelCase;
    }

    @Override
    public void setSaveAllBeforeFinish(boolean theDoSave) {
        this.saveAllBeforeFinish = theDoSave;
    }

    @Override
    public boolean isSaveAllBeforeFinish() {
        return this.saveAllBeforeFinish;
    }

    @Override
    public void saveModel() {
    }
}

