/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.generator;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.ModelerCoreRuntimeException;
import org.teiid.core.designer.UserCancelledException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.ModelProducer;
import org.teiid.designer.compare.ModelerComparePlugin;
import org.teiid.designer.compare.generator.AbstractModelGenerator;
import org.teiid.designer.compare.processor.DifferenceProcessorImpl;
import org.teiid.designer.compare.processor.MergeProcessorImpl;
import org.teiid.designer.compare.selector.ModelResourceSelector;
import org.teiid.designer.compare.selector.ModelSelector;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.workspace.ModelWorkspaceException;

public class BasicModelGenerator
extends AbstractModelGenerator {
    private static final int UNITS_GENERATION = 10000;
    private static final int UNITS_DIFFERENCE = 100;
    private static final int UNITS_DIFFERENCE_POST_PROCESS = 100;
    private static final int UNITS_MERGE = 1000;
    public static final boolean DEFAULT_USE_TRANSACTION_DURING_MERGE = true;
    private final ModelSelector original;
    final ModelProducer producer;
    private MergeProcessorImpl mergeProcessor;
    private boolean useTransactionDuringMerge = true;

    public BasicModelGenerator(ModelSelector original, ModelProducer outputProducer, List mappingAdapters) {
        super(mappingAdapters);
        CoreArgCheck.isNotNull((Object)original);
        CoreArgCheck.isNotNull((Object)outputProducer);
        this.original = original;
        this.producer = outputProducer;
    }

    @Override
    public void close() {
        super.close();
        this.producer.getOutputSelector().close();
    }

    public ModelSelector getOriginalModelSelector() {
        return this.original;
    }

    @Override
    protected void doGenerateOutput(final IProgressMonitor monitor, final LinkedList problems) throws UserCancelledException {
        CoreArgCheck.isNotNull((Object)monitor);
        Object[] taskParams = new Object[]{this.getDescription()};
        String taskName = ModelerComparePlugin.Util.getString("ModelGenerator.Performing_{0}", taskParams);
        monitor.beginTask(null, 10000);
        monitor.setTaskName(taskName);
        if (monitor.isCanceled()) {
            throw new UserCancelledException();
        }
        try {
            this.producer.getOutputSelector().open();
            TransactionRunnable op = new TransactionRunnable(){

                public Object run(UnitOfWork uow) throws ModelerCoreException {
                    try {
                        BasicModelGenerator.this.producer.execute(monitor, problems);
                    }
                    catch (Exception e) {
                        throw new WrappedModelerCoreException(e);
                    }
                    return null;
                }
            };
            if (this.useTransactionDuringMerge) {
                String desc = this.getDescription();
                ModelerCore.getModelEditor().executeAsTransaction(op, desc, true, (Object)this);
            } else {
                op.run(null);
            }
            monitor.worked(10000);
        }
        catch (WrappedModelerCoreException we) {
            Throwable e = we.getException();
            if (e instanceof ModelerCoreRuntimeException && ((ModelerCoreRuntimeException)e).getChild() instanceof UserCancelledException) {
                UserCancelledException cancellation = (UserCancelledException)((ModelerCoreRuntimeException)e).getChild();
                throw cancellation;
            }
            Object[] params = new Object[]{this.getDescription(), e.getLocalizedMessage()};
            String msg = ModelerComparePlugin.Util.getString("ModelGenerator.Error_during_generation", params);
            Status status = new Status(4, "org.teiid.designer.compare", 58001, msg, e);
            problems.addFirst(status);
        }
        catch (ModelerCoreRuntimeException e) {
            if (!(e.getChild() instanceof UserCancelledException)) {
                Object[] params = new Object[]{this.getDescription(), e.getLocalizedMessage()};
                String msg = ModelerComparePlugin.Util.getString("ModelGenerator.Error_during_generation", params);
                Status status = new Status(4, "org.teiid.designer.compare", 58001, msg, (Throwable)e);
                problems.addFirst(status);
            }
        }
        catch (Exception e) {
            Object[] params = new Object[]{this.getDescription(), e.getLocalizedMessage()};
            String msg = ModelerComparePlugin.Util.getString("ModelGenerator.Error_during_generation", params);
            Status status = new Status(4, "org.teiid.designer.compare", 58001, msg, (Throwable)e);
            problems.addFirst(status);
        }
        catch (Throwable e) {
            Object[] params = new Object[]{this.getDescription(), e.getLocalizedMessage()};
            String msg = ModelerComparePlugin.Util.getString("ModelGenerator.Unexpected_runtime_error_during_generation", params);
            Status status = new Status(4, "org.teiid.designer.compare", 58002, msg, e);
            problems.addFirst(status);
        }
        if (monitor.isCanceled()) {
            throw new UserCancelledException();
        }
    }

    @Override
    protected void doComputeDifferenceReport(IProgressMonitor monitor, LinkedList problems) throws UserCancelledException {
        CoreArgCheck.isNotNull((Object)monitor);
        Object[] taskParams = new Object[]{this.getDescription()};
        String taskName = ModelerComparePlugin.Util.getString("ModelGenerator.Performing_{0}", taskParams);
        monitor.beginTask(null, 200);
        monitor.setTaskName(taskName);
        if (monitor.isCanceled()) {
            throw new UserCancelledException();
        }
        List matcherFactories = this.getEObjectMatcherFactories();
        ModelSelector output = this.producer.getOutputSelector();
        DifferenceProcessorImpl diffProcessor = new DifferenceProcessorImpl(this.original, output);
        if (matcherFactories.size() != 0) {
            diffProcessor.addEObjectMatcherFactories(matcherFactories);
        }
        IStatus diffStatus = diffProcessor.execute(monitor);
        monitor.worked(100);
        DifferenceReport differenceReport = diffProcessor.getDifferenceReport();
        this.addDifferenceReport(differenceReport);
        if (diffStatus.getSeverity() == 4) {
            problems.addFirst(diffStatus);
        } else {
            problems.add(diffStatus);
        }
    }

    @Override
    protected void doPostProcessDifferenceReports() {
    }

    @Override
    protected void doMergeOutputIntoOriginal(IProgressMonitor monitor, LinkedList problems) throws UserCancelledException {
        CoreArgCheck.isNotNull((Object)monitor);
        Object[] taskParams = new Object[]{this.getDescription()};
        String taskName = ModelerComparePlugin.Util.getString("ModelGenerator.Performing_{0}", taskParams);
        monitor.beginTask(null, 1000);
        monitor.setTaskName(taskName);
        if (monitor.isCanceled()) {
            throw new UserCancelledException();
        }
        if (this.getAllDifferenceReports().size() != 0) {
            DifferenceReport diffReport = (DifferenceReport)this.getDifferenceReports().get(0);
            ModelSelector output = this.producer.getOutputSelector();
            boolean moveRatherThanCopyAdds = this.isNewModelCase();
            EObject[] dummyArray = null;
            this.mergeProcessor = new MergeProcessorImpl(diffReport, this.original, output, dummyArray, moveRatherThanCopyAdds);
            this.mergeProcessor.setEndingToSourceMapping(this.getProducedToOutputMapping());
            IStatus mergeStatus = this.mergeProcessor.execute(monitor);
            if (mergeStatus.getSeverity() == 4) {
                problems.add(mergeStatus);
            }
            output.close();
        }
        monitor.worked(1000);
    }

    @Override
    protected void doReresolveAndRebuildImports() {
        if (this.mergeProcessor != null) {
            this.mergeProcessor.reresolve(null);
        }
    }

    @Override
    public void saveModel() {
        super.saveModel();
        ModelSelector selector = this.getOriginalModelSelector();
        if (selector instanceof ModelResourceSelector) {
            try {
                ((ModelResourceSelector)selector).getModelResource().save(null, true);
            }
            catch (ModelWorkspaceException err) {
                ModelerComparePlugin.Util.log((Throwable)err);
            }
        }
    }

    protected class WrappedModelerCoreException
    extends ModelerCoreException {
        public WrappedModelerCoreException(Exception exception) {
            super((Throwable)exception);
        }
    }
}

