/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.generator;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.teiid.core.designer.UserCancelledException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.ModelGenerator;
import org.teiid.designer.compare.generator.AbstractModelGenerator;

public class CompositeModelGenerator
extends AbstractModelGenerator {
    private final List modelGenerators;

    public CompositeModelGenerator(List modelGenerators) {
        super(null);
        CoreArgCheck.isNotNull((Object)modelGenerators);
        this.modelGenerators = modelGenerators != null ? modelGenerators : new ArrayList();
    }

    public List getModelGenerators() {
        return this.modelGenerators;
    }

    @Override
    public List getAllDifferenceReports() {
        LinkedList reports = new LinkedList();
        for (ModelGenerator generator : this.getModelGenerators()) {
            reports.addAll(generator.getAllDifferenceReports());
        }
        return reports;
    }

    @Override
    public void close() {
        super.close();
        for (ModelGenerator generator : this.getModelGenerators()) {
            generator.close();
        }
    }

    @Override
    protected void doClearDifferenceReports() {
    }

    @Override
    protected void doGenerateOutput(IProgressMonitor monitor, LinkedList problems) throws UserCancelledException {
        for (ModelGenerator generator : this.getModelGenerators()) {
            IStatus status = generator.generateOutput(monitor);
            problems.add(status);
        }
    }

    @Override
    protected void doComputeDifferenceReport(IProgressMonitor monitor, LinkedList problems) throws UserCancelledException {
        for (ModelGenerator generator : this.getModelGenerators()) {
            IStatus status = generator.computeDifferenceReport(monitor);
            problems.add(status);
        }
    }

    @Override
    protected void doPostProcessDifferenceReports() {
    }

    @Override
    protected void doMergeOutputIntoOriginal(IProgressMonitor monitor, LinkedList problems) throws UserCancelledException {
        for (ModelGenerator generator : this.getModelGenerators()) {
            if (generator instanceof AbstractModelGenerator) {
                AbstractModelGenerator amg = (AbstractModelGenerator)generator;
                amg.setProducedToOutputMapping(this.getProducedToOutputMapping());
            }
            IStatus status = generator.mergeOutputIntoOriginal(monitor);
            problems.add(status);
        }
        this.doReresolveAndRebuildImports();
        if (this.isSaveAllBeforeFinish()) {
            this.saveModel();
        }
    }

    @Override
    protected void doReresolveAndRebuildImports() {
        for (ModelGenerator generator : this.getModelGenerators()) {
            if (!(generator instanceof AbstractModelGenerator)) continue;
            AbstractModelGenerator amg = (AbstractModelGenerator)generator;
            amg.doReresolveAndRebuildImports();
        }
    }

    @Override
    public void setNewModelCase(boolean theIsNewModelCase) {
        super.setNewModelCase(theIsNewModelCase);
        for (ModelGenerator generator : this.getModelGenerators()) {
            generator.setNewModelCase(theIsNewModelCase);
        }
    }

    @Override
    public void saveModel() {
        for (ModelGenerator generator : this.getModelGenerators()) {
            generator.saveModel();
        }
    }

    @Override
    public void setSaveAllBeforeFinish(boolean theDoSave) {
        super.setSaveAllBeforeFinish(theDoSave);
        for (ModelGenerator generator : this.getModelGenerators()) {
            generator.setSaveAllBeforeFinish(theDoSave);
        }
    }
}

