/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.mapping.Mapping;
import org.eclipse.emf.mapping.MappingHelper;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.DifferenceDescriptor;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.DifferenceType;
import org.teiid.designer.compare.MergeProcessor;
import org.teiid.designer.compare.ModelerComparePlugin;
import org.teiid.designer.compare.PropertyDifference;
import org.teiid.designer.compare.processor.DifferenceProcessorImpl;
import org.teiid.designer.compare.selector.ModelSelector;
import org.teiid.designer.core.ModelEditor;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.ModelVisitor;
import org.teiid.designer.core.util.ModelVisitorProcessor;
import org.teiid.designer.core.util.ModelVisitorWithFinish;

public class MergeProcessorImpl
implements MergeProcessor {
    private static final String PLUGINID = "org.teiid.designer.compare";
    protected static final int PROCESSOR_ALREADY_CLOSED = 60001;
    protected static final int NO_PROBLEMS = 60002;
    protected static final int HAS_WARNINGS = 60003;
    protected static final int HAS_ERRORS = 60004;
    protected static final int HAS_WARNINGS_AND_ERRORS = 60005;
    protected static final int NO_WARNINGS_AND_ERRORS = 60006;
    protected static final int ERROR_PLANNING_MERGE = 60010;
    protected static final int ERROR_MERGING_ADDS_AND_DELETES = 60011;
    protected static final int ERROR_MERGING_CHANGES = 60012;
    protected static final int ERROR_RESOLVING_REFERENCES = 60013;
    protected static final int AMOUNT_OF_WORK_FOR_PLANNING = 200;
    protected static final int AMOUNT_OF_WORK_FOR_MERGING_ADDS_AND_DELETES = 10000;
    protected static final int AMOUNT_OF_WORK_FOR_MERGING_CHANGES = 10000;
    protected static final int AMOUNT_OF_WORK_FOR_REFERENCE_RESOLUTION = 300;
    protected static final int AMOUNT_OF_WORK_FOR_CREATING_RESULTS = 100;
    public static final boolean DEFAULT_ADDS_MOVED_FROM_STARTING_INTO_ENDING = false;
    private final DifferenceReport differenceReport;
    private final ModelSelector sourceModelSelector;
    private IProgressMonitor monitor;
    private List problems;
    private WorkInfo workInfo;
    private ModelEditor editor;
    private Map resultObjectToSourceObject;
    private final List newRoots;
    private boolean computeTasks;
    private boolean closed;
    private final boolean moveAddedObjectsFromStartingSelector;

    public MergeProcessorImpl(DifferenceReport differenceReport, ModelSelector startingModelSelector, ModelSelector endingModelSelector, EObject[] externalReferences, boolean moveAddsRatherThanCopy) {
        CoreArgCheck.isNotNull((Object)differenceReport);
        CoreArgCheck.isNotNull((Object)startingModelSelector);
        CoreArgCheck.isNotNull((Object)endingModelSelector);
        this.differenceReport = differenceReport;
        this.sourceModelSelector = startingModelSelector;
        this.resultObjectToSourceObject = new HashMap();
        this.newRoots = new LinkedList();
        this.initializeResultToSourceMap(externalReferences);
        this.moveAddedObjectsFromStartingSelector = moveAddsRatherThanCopy;
    }

    public MergeProcessorImpl(DifferenceReport differenceReport, ModelSelector startingModelSelector, ModelSelector endingModelSelector, EObject[] externalReferences) {
        this(differenceReport, startingModelSelector, endingModelSelector, externalReferences, false);
    }

    public MergeProcessorImpl(DifferenceReport differenceReport, ModelSelector startingModelSelector, ModelSelector endingModelSelector) {
        this(differenceReport, startingModelSelector, endingModelSelector, null);
    }

    public MergeProcessorImpl(DifferenceProcessorImpl differenceProcessor, EObject[] externalReferences) {
        this(differenceProcessor.getDifferenceReport(), differenceProcessor.getBeforeSelector(), differenceProcessor.getAfterSelector(), externalReferences);
    }

    public MergeProcessorImpl(DifferenceProcessorImpl differenceProcessor, EObject[] externalReferences, boolean moveAddsRatherThanCopy) {
        this(differenceProcessor.getDifferenceReport(), differenceProcessor.getBeforeSelector(), differenceProcessor.getAfterSelector(), externalReferences, moveAddsRatherThanCopy);
    }

    public MergeProcessorImpl(DifferenceProcessorImpl differenceProcessor) {
        this(differenceProcessor.getDifferenceReport(), differenceProcessor.getBeforeSelector(), differenceProcessor.getAfterSelector());
    }

    private void initializeResultToSourceMap(EObject[] externalReferences) {
        if (externalReferences != null && externalReferences.length > 0) {
            int i = 0;
            while (i != externalReferences.length) {
                EObject obj = externalReferences[i];
                this.resultObjectToSourceObject.put(obj, obj);
                ++i;
            }
        }
    }

    public void setEndingToSourceMapping(Map mapping) {
        this.resultObjectToSourceObject = mapping != null ? mapping : new HashMap();
    }

    public boolean isMoveAddedObjectsFromStartingSelector() {
        return this.moveAddedObjectsFromStartingSelector;
    }

    @Override
    public IStatus execute(IProgressMonitor progressMonitor) {
        if (this.closed) {
            String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.The_processor_has_already_been_closed", new Object[0]);
            Status status = new Status(4, PLUGINID, 60001, msg, null);
            return status;
        }
        if (progressMonitor != null) {
            this.computeTasks = true;
            this.monitor = progressMonitor;
        } else {
            this.computeTasks = false;
            this.monitor = new NullProgressMonitor();
        }
        String taskName = this.doGetTaskName();
        int totalWork = this.doComputeTotalWork();
        this.monitor.beginTask(taskName, totalWork);
        Object[] paramsExec = new Object[]{this.sourceModelSelector.getLabel()};
        String execSubTask = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Performing_merge", paramsExec);
        this.monitor.subTask(execSubTask);
        this.newRoots.clear();
        this.editor = ModelerCore.getModelEditor();
        this.problems = new LinkedList();
        this.doExecute();
        IStatus resultStatus = null;
        try {
            String analysisSubTask = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Analyzing_problems", new Object[0]);
            this.monitor.subTask(analysisSubTask);
            if (this.problems.isEmpty()) {
                String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Execution_completed", new Object[0]);
                Status status = new Status(0, PLUGINID, 60002, msg, null);
                resultStatus = status;
            } else if (this.problems.size() == 1) {
                resultStatus = (IStatus)this.problems.get(0);
            } else {
                int numErrors = 0;
                int numWarnings = 0;
                for (IStatus aStatus : this.problems) {
                    if (aStatus.getSeverity() == 2) {
                        ++numWarnings;
                        continue;
                    }
                    if (aStatus.getSeverity() != 4) continue;
                    ++numErrors;
                }
                IStatus[] statusArray = this.problems.toArray(new IStatus[this.problems.size()]);
                if (numWarnings != 0 && numErrors == 0) {
                    Object[] params = new Object[]{new Integer(numWarnings)};
                    String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Execution_resulted_in_warnings", params);
                    resultStatus = new MultiStatus(PLUGINID, 60003, statusArray, msg, null);
                } else if (numWarnings == 0 && numErrors != 0) {
                    Object[] params = new Object[]{new Integer(numErrors)};
                    String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Execution_resulted_in_errors", params);
                    resultStatus = new MultiStatus(PLUGINID, 60004, statusArray, msg, null);
                } else if (numWarnings != 0 && numErrors != 0) {
                    Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
                    String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Execution_resulted_in_warnings_and_errors", params);
                    resultStatus = new MultiStatus(PLUGINID, 60005, statusArray, msg, null);
                } else {
                    String msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Execution_completed_with_no_warnings_or_errors", new Object[0]);
                    resultStatus = new MultiStatus(PLUGINID, 60006, statusArray, msg, null);
                }
            }
        }
        finally {
            this.monitor.worked(100);
        }
        return resultStatus;
    }

    @Override
    public void reresolve(IProgressMonitor monitor) {
        this.doReResolveAndRebuildImports();
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.doClose();
        this.closed = true;
    }

    protected IStatus newWarning(int code, String msg, Throwable t) {
        return new Status(2, PLUGINID, code, msg, t);
    }

    protected IStatus newInfo(int code, String msg, Throwable t) {
        return new Status(1, PLUGINID, code, msg, t);
    }

    protected IStatus newError(int code, String msg, Throwable t) {
        return new Status(4, PLUGINID, code, msg, t);
    }

    protected IStatus newOk(int code, String msg, Throwable t) {
        return new Status(0, PLUGINID, code, msg, t);
    }

    protected void doClose() {
        this.problems = null;
        this.monitor = null;
        this.newRoots.clear();
        this.resultObjectToSourceObject.clear();
    }

    protected int doComputeTotalWork() {
        return 20600;
    }

    protected String doGetTaskName() {
        return ModelerComparePlugin.Util.getString("MergeProcessorImpl.taskName", new Object[0]);
    }

    protected void doExecute() {
        IStatus status;
        String msg;
        block36: {
            block34: {
                IStatus status2;
                String msg2;
                block32: {
                    block30: {
                        PlanningVisitor planningVisitor;
                        block28: {
                            planningVisitor = new PlanningVisitor();
                            try {
                                try {
                                    ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)planningVisitor);
                                    processor.walk((EObject)this.differenceReport, 2);
                                }
                                catch (Throwable e) {
                                    String msg3 = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_planning_the_merge", new Object[0]);
                                    IStatus status3 = this.newError(60010, msg3, e);
                                    this.problems.add(status3);
                                    this.monitor.worked(200);
                                    break block28;
                                }
                            }
                            catch (Throwable throwable) {
                                this.monitor.worked(200);
                                throw throwable;
                            }
                            this.monitor.worked(200);
                        }
                        int numMappings = planningVisitor.getMappingCount();
                        this.workInfo = new WorkInfo(numMappings, 10000);
                        AddAndDeleteVisitor addAndDeleteVisitor = new AddAndDeleteVisitor();
                        try {
                            try {
                                ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)addAndDeleteVisitor);
                                processor.walk((EObject)this.differenceReport, 2);
                            }
                            catch (Throwable e) {
                                String msg4 = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_merging_adds_and_deletes", new Object[0]);
                                IStatus status4 = this.newError(60011, msg4, e);
                                this.problems.add(status4);
                                this.monitor.worked(this.workInfo.workRemaining);
                                break block30;
                            }
                        }
                        catch (Throwable throwable) {
                            this.monitor.worked(this.workInfo.workRemaining);
                            throw throwable;
                        }
                        this.monitor.worked(this.workInfo.workRemaining);
                    }
                    ChangeVisitor changeVisitor = new ChangeVisitor();
                    try {
                        try {
                            ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)changeVisitor);
                            processor.walk((EObject)this.differenceReport, 2);
                        }
                        catch (Throwable e) {
                            msg2 = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_merging_changes", new Object[0]);
                            status2 = this.newError(60012, msg2, e);
                            this.problems.add(status2);
                            this.monitor.worked(this.workInfo.workRemaining);
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        this.monitor.worked(this.workInfo.workRemaining);
                        throw throwable;
                    }
                    this.monitor.worked(this.workInfo.workRemaining);
                }
                if (this.newRoots != null && !this.newRoots.isEmpty()) {
                    try {
                        try {
                            int indexOfLastMappedRoot = -1;
                            int index = -1;
                            for (EObject root : this.sourceModelSelector.getRootObjects()) {
                                ++index;
                                if (!this.resultObjectToSourceObject.containsValue(root)) continue;
                                indexOfLastMappedRoot = index;
                            }
                            this.sourceModelSelector.addRootObjects(this.newRoots, indexOfLastMappedRoot + 1);
                        }
                        catch (Throwable e) {
                            msg2 = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_adding_new_root_objects", new Object[0]);
                            status2 = this.newError(60013, msg2, e);
                            this.problems.add(status2);
                            this.monitor.worked(300);
                            break block34;
                        }
                    }
                    catch (Throwable throwable) {
                        this.monitor.worked(300);
                        throw throwable;
                    }
                    this.monitor.worked(300);
                }
            }
            ResolutionVisitor resolveVisitor = new ResolutionVisitor();
            try {
                try {
                    ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)resolveVisitor);
                    List sourceRoots = this.doGetSourceRoots();
                    processor.walk((Collection)sourceRoots, 2);
                }
                catch (Throwable e) {
                    msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_resolving_references", new Object[0]);
                    status = this.newError(60013, msg, e);
                    this.problems.add(status);
                    this.monitor.worked(300);
                    break block36;
                }
            }
            catch (Throwable throwable) {
                this.monitor.worked(300);
                throw throwable;
            }
            this.monitor.worked(300);
        }
        try {
            try {
                this.sourceModelSelector.rebuildModelImports();
            }
            catch (Throwable e) {
                msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_rebuilding_imports", new Object[0]);
                status = this.newError(60013, msg, e);
                this.problems.add(status);
                this.monitor.worked(300);
            }
        }
        finally {
            this.monitor.worked(300);
        }
    }

    protected void doReResolveAndRebuildImports() {
        IStatus status;
        String msg;
        block10: {
            ResolutionVisitor resolveVisitor = new ResolutionVisitor();
            try {
                try {
                    ModelVisitorProcessor processor = new ModelVisitorProcessor((ModelVisitor)resolveVisitor);
                    List sourceRoots = this.doGetSourceRoots();
                    processor.walk((Collection)sourceRoots, 2);
                }
                catch (Throwable e) {
                    msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_resolving_references", new Object[0]);
                    status = this.newError(60013, msg, e);
                    this.problems.add(status);
                    this.monitor.worked(300);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                this.monitor.worked(300);
                throw throwable;
            }
            this.monitor.worked(300);
        }
        try {
            try {
                this.sourceModelSelector.rebuildModelImports();
            }
            catch (Throwable e) {
                msg = ModelerComparePlugin.Util.getString("MergeProcessorImpl.Error_while_rebuilding_imports", new Object[0]);
                status = this.newError(60013, msg, e);
                this.problems.add(status);
                this.monitor.worked(300);
            }
        }
        finally {
            this.monitor.worked(300);
        }
    }

    protected List doGetSourceRoots() throws ModelerCoreException {
        LinkedList<EObject> roots = new LinkedList<EObject>(this.sourceModelSelector.getRootObjects());
        for (Object newRoot : this.newRoots) {
            if (roots.contains(newRoot)) continue;
            roots.add((EObject)newRoot);
        }
        return roots;
    }

    protected void doProcess(Mapping mapping, boolean adds, boolean changes, boolean deletes) throws ModelerCoreException {
        block11: {
            try {
                DifferenceDescriptor diffDesc;
                boolean skip;
                MappingHelper helper = mapping.getHelper();
                if (helper == null || !(helper instanceof DifferenceDescriptor) || (skip = (diffDesc = (DifferenceDescriptor)helper).isSkip())) break block11;
                DifferenceType type = diffDesc.getType();
                int typeValue = type.getValue();
                switch (typeValue) {
                    case 1: {
                        if (adds) {
                            this.doAdd(mapping, diffDesc);
                        }
                        break;
                    }
                    case 3: {
                        if (changes) {
                            this.doChange(mapping, diffDesc);
                        }
                        break;
                    }
                    case 2: {
                        if (deletes) {
                            this.doDelete(mapping, diffDesc);
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            finally {
                this.monitor.worked(this.workInfo.workPerMapping);
            }
        }
    }

    protected void doPostProcess(Mapping mapping) {
        try {
            MappingHelper helper = mapping.getHelper();
            if (helper != null && helper instanceof DifferenceDescriptor) {
                boolean skip;
                DifferenceDescriptor diffDesc = (DifferenceDescriptor)helper;
                boolean bl = skip = diffDesc.isSkip() || mapping.getNestedIn() == null;
                if (!skip) {
                    DifferenceType type = diffDesc.getType();
                    int typeValue = type.getValue();
                    switch (typeValue) {
                        case 0: 
                        case 3: 
                        case 4: {
                            this.doOrderContained(mapping, diffDesc);
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
        }
        finally {
            this.monitor.worked(this.workInfo.workPerMapping);
        }
    }

    protected String computeSubtaskPath(EObject object) {
        return this.editor.getModelRelativePath(object).toString();
    }

    protected void doAdd(Mapping mapping, DifferenceDescriptor diffDesc) throws ModelerCoreException {
        EList outputs = mapping.getOutputs();
        EObject newObject = (EObject)outputs.get(0);
        if (this.computeTasks) {
            String path = this.computeSubtaskPath(newObject);
            Object[] params = new Object[]{path};
            String loadingSubTask = ModelerComparePlugin.Util.getString("MergeProcessorImpl.AddingSubTask", params);
            this.monitor.subTask(loadingSubTask);
        }
        EObject copy = this.moveAddedObjectsFromStartingSelector ? newObject : this.editor.copy(newObject, this.resultObjectToSourceObject);
        EReference feature = newObject.eContainmentFeature();
        if (feature == null) {
            if (this.moveAddedObjectsFromStartingSelector) {
                newObject.eResource().getContents().remove((Object)copy);
            }
            this.newRoots.add(copy);
        } else {
            EObject parent = (EObject)this.resultObjectToSourceObject.get(newObject.eContainer());
            if (feature.isMany()) {
                List values = (List)parent.eGet((EStructuralFeature)feature);
                values.add(copy);
            } else {
                parent.eSet((EStructuralFeature)feature, (Object)copy);
            }
        }
    }

    protected void doChange(Mapping mapping, DifferenceDescriptor diffDesc) {
        EList inputs = mapping.getInputs();
        EObject oldObject = (EObject)inputs.get(0);
        if (this.computeTasks) {
            String path = this.computeSubtaskPath(oldObject);
            Object[] params = new Object[]{path};
            String loadingSubTask = ModelerComparePlugin.Util.getString("MergeProcessorImpl.ChangingSubTask", params);
            this.monitor.subTask(loadingSubTask);
        }
        EList propDiffs = diffDesc.getPropertyDifferences();
        for (PropertyDifference propDiff : propDiffs) {
            if (propDiff.isSkip()) continue;
            EStructuralFeature feature = propDiff.getAffectedFeature();
            Object newValue = propDiff.getNewValue();
            Object oldValue = propDiff.getOldValue();
            if (feature.isMany()) {
                EList newValues = (EList)newValue;
                EList oldValues = (EList)oldValue;
                List newValuesInSource = this.convertFromResultsToSource(newValues);
                ECollections.setEList((EList)oldValues, (List)newValuesInSource);
                continue;
            }
            if (newValue instanceof EObject) {
                EObject newValueInSource = (EObject)this.resultObjectToSourceObject.get(newValue);
                if (newValueInSource == null) {
                    oldObject.eSet(feature, newValue);
                    continue;
                }
                oldObject.eSet(feature, (Object)newValueInSource);
                continue;
            }
            oldObject.eSet(feature, newValue);
        }
    }

    protected List convertFromResultsToSource(EList newValues) {
        ArrayList<EObject> result = new ArrayList<EObject>(newValues.size());
        for (EObject newValue : newValues) {
            EObject newValueInSource = (EObject)this.resultObjectToSourceObject.get(newValue);
            if (newValueInSource != null) {
                result.add(newValueInSource);
                continue;
            }
            result.add(newValue);
        }
        return result;
    }

    protected void doDelete(Mapping mapping, DifferenceDescriptor diffDesc) throws ModelerCoreException {
        EList inputs = mapping.getInputs();
        EObject deletedObject = (EObject)inputs.get(0);
        if (this.computeTasks) {
            String path = this.computeSubtaskPath(deletedObject);
            Object[] params = new Object[]{path};
            String loadingSubTask = ModelerComparePlugin.Util.getString("MergeProcessorImpl.RemovingSubTask", params);
            this.monitor.subTask(loadingSubTask);
        }
        this.editor.delete(deletedObject);
    }

    protected void doResolve(EObject sourceObject) {
        EClass metaclass = sourceObject.eClass();
        EList features = metaclass.getEAllReferences();
        for (EReference ref : features) {
            if (ref.isVolatile()) continue;
            if (ref.isMany()) {
                List values = (List)sourceObject.eGet((EStructuralFeature)ref);
                if (values.size() == 0) continue;
                ArrayList<Object> newValues = new ArrayList<Object>(values.size());
                boolean foundNewValue = false;
                int i = 0;
                while (i != values.size()) {
                    Object value = values.get(i);
                    Object sourceValue = this.resultObjectToSourceObject.get(value);
                    if (sourceValue != null) {
                        if (!newValues.contains(sourceValue)) {
                            newValues.add(sourceValue);
                            foundNewValue = true;
                        }
                    } else if (!newValues.contains(value)) {
                        newValues.add(value);
                    }
                    ++i;
                }
                if (!foundNewValue) continue;
                values.clear();
                values.addAll(newValues);
                continue;
            }
            Object value = sourceObject.eGet((EStructuralFeature)ref);
            Object sourceValue = this.resultObjectToSourceObject.get(value);
            if (sourceValue == null) continue;
            sourceObject.eSet((EStructuralFeature)ref, sourceValue);
        }
    }

    protected void recordMapping(Object source, Object result) {
        this.resultObjectToSourceObject.put(result, source);
    }

    protected void doOrderContained(Mapping mapping, DifferenceDescriptor diffDesc) {
        EList inputs = mapping.getInputs();
        EList outputs = mapping.getOutputs();
        if (inputs.isEmpty() || outputs.isEmpty()) {
            return;
        }
        EObject sourceObject = (EObject)inputs.get(0);
        EObject resultObject = (EObject)outputs.get(0);
        EClass sourceMetaclass = sourceObject.eClass();
        for (EStructuralFeature feature : sourceMetaclass.getEAllContainments()) {
            if (!feature.isMany()) continue;
            List resultsValues = (List)resultObject.eGet(feature);
            ArrayList<Object> sourceValuesFromResults = new ArrayList<Object>();
            for (Object resultValue : resultsValues) {
                Object sourceValue = this.resultObjectToSourceObject.get(resultValue);
                if (sourceValue == null || sourceValuesFromResults.contains(sourceValue)) continue;
                sourceValuesFromResults.add(sourceValue);
            }
            EList sourceValues = (EList)sourceObject.eGet(feature);
            for (Object obj : sourceValues) {
                if (sourceValuesFromResults.contains(obj)) continue;
                sourceValuesFromResults.add(obj);
            }
            ECollections.setEList((EList)sourceValues, sourceValuesFromResults);
        }
    }

    protected class AddAndDeleteVisitor
    implements ModelVisitorWithFinish {
        protected AddAndDeleteVisitor() {
        }

        public boolean visit(EObject object) throws ModelerCoreException {
            if (object instanceof Mapping) {
                MergeProcessorImpl.this.doProcess((Mapping)object, true, false, true);
                return true;
            }
            return true;
        }

        public boolean visit(Resource resource) {
            return true;
        }

        public void postVisit(EObject object) {
            if (object instanceof Mapping) {
                MergeProcessorImpl.this.doPostProcess((Mapping)object);
            }
        }
    }

    protected class ChangeVisitor
    implements ModelVisitor {
        protected ChangeVisitor() {
        }

        public boolean visit(EObject object) throws ModelerCoreException {
            if (object instanceof Mapping) {
                MergeProcessorImpl.this.doProcess((Mapping)object, false, true, false);
                return true;
            }
            return true;
        }

        public boolean visit(Resource resource) {
            return true;
        }
    }

    protected class PlanningVisitor
    implements ModelVisitor {
        int numMappings = 0;

        protected PlanningVisitor() {
        }

        public boolean visit(EObject object) {
            if (object instanceof Mapping) {
                MappingHelper helper;
                ++this.numMappings;
                Mapping mapping = (Mapping)object;
                if (mapping.getNestedIn() != null && (helper = mapping.getHelper()) != null && helper instanceof DifferenceDescriptor) {
                    EList inputs = mapping.getInputs();
                    EList outputs = mapping.getOutputs();
                    if (inputs.size() == 1 && outputs.size() == 1) {
                        Object source = inputs.get(0);
                        Object result = outputs.get(0);
                        MergeProcessorImpl.this.recordMapping(source, result);
                    }
                }
            }
            return true;
        }

        public boolean visit(Resource resource) {
            return true;
        }

        public int getMappingCount() {
            return this.numMappings;
        }
    }

    protected class ResolutionVisitor
    implements ModelVisitor {
        protected ResolutionVisitor() {
        }

        public boolean visit(EObject object) {
            MergeProcessorImpl.this.doResolve(object);
            return true;
        }

        public boolean visit(Resource resource) {
            return true;
        }
    }

    protected class WorkInfo {
        protected final int numMappings;
        protected final int workPerMapping;
        protected final int workRemaining;

        protected WorkInfo(int numMappings, int workForMerging) {
            this.numMappings = numMappings;
            if (numMappings > 0) {
                this.workPerMapping = numMappings <= workForMerging ? workForMerging / numMappings : 0;
                this.workRemaining = workForMerging - this.workPerMapping * numMappings;
            } else {
                this.workPerMapping = 0;
                this.workRemaining = workForMerging;
            }
        }
    }
}

