/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.selector;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.selector.AbstractModelSelector;
import org.teiid.designer.compare.selector.ModelContentsModelHelper;
import org.teiid.designer.compare.selector.ModelHelper;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class EmfResourceSelector
extends AbstractModelSelector {
    private final Resource resource;
    private String label;
    private ModelContents contents;
    private ModelHelper helper;

    public EmfResourceSelector(Resource resource) {
        CoreArgCheck.isNotNull((Object)resource);
        this.resource = resource;
    }

    @Override
    public void open() {
        if (this.resource instanceof EmfResource) {
            this.contents = ((EmfResource)this.resource).getModelContents();
        }
        if (this.contents == null) {
            this.contents = new ModelContents(this.resource);
        }
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public List getRootObjects() {
        return this.resource.getContents();
    }

    @Override
    public URI getUri() {
        return this.resource.getURI();
    }

    @Override
    public void close() {
        this.contents = null;
        this.helper = null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public ModelAnnotation getModelAnnotation() {
        return this.contents.getModelAnnotation();
    }

    @Override
    public ModelHelper getModelHelper() {
        if (this.helper == null) {
            this.helper = new ModelContentsModelHelper(this.contents);
        }
        return this.helper;
    }

    @Override
    public ModelContents getModelContents() {
        return this.contents;
    }
}

