/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.selector;

import java.io.InputStream;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.selector.ModelContentsModelHelper;
import org.teiid.designer.compare.selector.ModelHelper;
import org.teiid.designer.compare.selector.TemporaryResourceModelSelector;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.resource.RegisteredUriConverter;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class InputStreamModelSelector
extends TemporaryResourceModelSelector {
    public static final URI XMI_URI = URI.createURI((String)"streamscheme://metamatrix/hard-codedstream.xmi");
    public static final URI XML_URI = URI.createURI((String)"streamscheme://metamatrix/hard-codedstream.xml");
    public static final URI XSD_URI = URI.createURI((String)"streamscheme://metamatrix/hard-codedstream.xsd");
    public static final URI VDB_URI = URI.createURI((String)"streamscheme://metamatrix/hard-codedstream.vdb");
    private Resource resource;
    private final InputStream stream;
    private ModelContents contents;
    private ModelHelper helper;
    private final URI uri;

    public InputStreamModelSelector(InputStream stream, URI uri) {
        CoreArgCheck.isNotNull((Object)stream);
        this.stream = stream;
        this.uri = uri;
    }

    @Override
    public void open() {
        if (this.resource == null) {
            URIConverter origConverter = this.getResourceSet().getURIConverter();
            RegisteredUriConverter converter = new RegisteredUriConverter(origConverter);
            converter.register(this.uri, this.stream);
            this.getResourceSet().setURIConverter((URIConverter)converter);
            this.resource = this.getResourceSet().getResource(this.uri, false);
            if (this.resource != null) {
                this.resource.unload();
            }
            this.resource = this.getResourceSet().getResource(this.uri, true);
            if (this.resource instanceof EmfResource) {
                this.contents = ((EmfResource)this.resource).getModelContents();
            }
            if (this.contents == null) {
                this.contents = new ModelContents(this.resource);
            }
        }
    }

    @Override
    public Resource getResource() {
        if (this.resource == null) {
            this.open();
        }
        return this.resource;
    }

    public List getRootObjects() {
        return this.getResource().getContents();
    }

    @Override
    public URI getUri() {
        return this.getResource().getURI();
    }

    @Override
    public void close() {
        try {
            if (this.resource != null) {
                this.resource.unload();
            }
        }
        finally {
            this.contents = null;
            this.helper = null;
            this.resource = null;
        }
    }

    @Override
    public ModelAnnotation getModelAnnotation() {
        return this.contents.getModelAnnotation();
    }

    @Override
    public ModelHelper getModelHelper() {
        if (this.helper == null) {
            this.helper = new ModelContentsModelHelper(this.contents);
        }
        return this.helper;
    }

    @Override
    public ModelContents getModelContents() {
        return this.contents;
    }

    public static URI getTemporatyResourceURI(IPath path) {
        if (ModelUtil.isXsdFile((IPath)path)) {
            return XSD_URI;
        }
        if (ModelUtil.isModelFile((IPath)path)) {
            return XMI_URI;
        }
        if (ModelUtil.isVdbArchiveFile((IPath)path)) {
            return VDB_URI;
        }
        return null;
    }
}

