/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.selector;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.selector.AbstractModelSelector;
import org.teiid.designer.compare.selector.ModelContentsModelHelper;
import org.teiid.designer.compare.selector.ModelHelper;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class ModelResourceSelector
extends AbstractModelSelector {
    private final ModelResource modelResource;
    private ModelContents contents;
    private String label;
    private ModelHelper helper;

    public ModelResourceSelector(ModelResource modelResource) {
        CoreArgCheck.isNotNull((Object)modelResource);
        this.modelResource = modelResource;
    }

    @Override
    public void open() {
    }

    @Override
    public Resource getResource() throws ModelerCoreException {
        return this.modelResource.getEmfResource();
    }

    public ModelResource getModelResource() {
        return this.modelResource;
    }

    public List getRootObjects() throws ModelerCoreException {
        return this.getResource().getContents();
    }

    @Override
    public URI getUri() {
        IPath path = this.modelResource.getPath();
        URI result = URI.createFileURI((String)path.toFile().getAbsolutePath());
        return result;
    }

    @Override
    public void close() {
        this.helper = null;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public ModelAnnotation getModelAnnotation() throws ModelWorkspaceException {
        return this.modelResource.getModelAnnotation();
    }

    @Override
    public ModelHelper getModelHelper() throws ModelWorkspaceException {
        if (this.helper == null) {
            this.helper = new ModelContentsModelHelper(this.getModelContents());
        }
        return this.helper;
    }

    @Override
    public ModelContents getModelContents() throws ModelWorkspaceException {
        if (this.contents == null) {
            this.contents = ModelContents.getModelContents((ModelResource)this.modelResource);
        }
        return this.contents;
    }
}

