/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.compare.selector;

import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.selector.ModelContentsModelHelper;
import org.teiid.designer.compare.selector.ModelHelper;
import org.teiid.designer.compare.selector.TemporaryResourceModelSelector;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.util.ModelContents;
import org.teiid.designer.metamodels.core.ModelAnnotation;

public class URIModelSelector
extends TemporaryResourceModelSelector {
    protected Resource resource;
    private final URI modelUri;
    protected ModelContents contents;
    private ModelHelper helper;

    public URIModelSelector(URI modelUri) {
        CoreArgCheck.isNotNull((Object)modelUri);
        this.modelUri = modelUri;
    }

    @Override
    public void open() {
        if (this.resource == null) {
            this.resource = this.getResourceSet().getResource(this.modelUri, true);
            if (this.resource instanceof EmfResource) {
                this.contents = ((EmfResource)this.resource).getModelContents();
            }
            if (this.contents == null) {
                this.contents = new ModelContents(this.resource);
            }
        }
    }

    @Override
    public Resource getResource() {
        this.open();
        return this.resource;
    }

    public List getRootObjects() {
        this.open();
        return this.resource.getContents();
    }

    @Override
    public URI getUri() {
        return this.modelUri;
    }

    @Override
    public void close() {
        try {
            if (this.resource != null) {
                this.resource.unload();
            }
        }
        finally {
            this.contents = null;
            this.helper = null;
            this.resource = null;
        }
    }

    @Override
    public ModelAnnotation getModelAnnotation() {
        this.open();
        return this.contents.getModelAnnotation();
    }

    @Override
    public ModelHelper getModelHelper() {
        if (this.helper == null) {
            this.open();
            this.helper = new ModelContentsModelHelper(this.contents);
        }
        return this.helper;
    }

    @Override
    public ModelContents getModelContents() {
        this.open();
        return this.contents;
    }
}

