/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.karaf.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.fusesource.ide.server.karaf.core.server.KarafServerDelegate;
import org.fusesource.ide.server.karaf.core.server.internal.IServerConnectionProvider;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListenerManager;
import org.jboss.tools.jmx.core.AbstractConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionCategory;
import org.jboss.tools.jmx.core.IConnectionProviderEventEmitter;
import org.jboss.tools.jmx.core.IConnectionWrapper;

public abstract class AbstractKarafJMXConnectionProvider
extends AbstractConnectionProvider
implements IServerConnectionProvider,
IConnectionProviderEventEmitter,
IConnectionCategory {
    private HashMap<String, IConnectionWrapper> idToConnection;

    public AbstractKarafJMXConnectionProvider() {
        UnitedServerListener listener = this.createUnitedListener();
        UnitedServerListenerManager.getDefault().addListener(listener);
    }

    private UnitedServerListener createUnitedListener() {
        UnitedServerListener listener = new UnitedServerListener(){

            public boolean canHandleServer(IServer server) {
                return server.loadAdapter(KarafServerDelegate.class, (IProgressMonitor)new NullProgressMonitor()) != null;
            }

            public void serverChanged(ServerEvent event) {
                IConnectionWrapper con = (IConnectionWrapper)AbstractKarafJMXConnectionProvider.this.idToConnection.get(event.getServer().getId());
                if (con != null) {
                    if (1.serverSwitchesToState((ServerEvent)event, (int)2)) {
                        AbstractKarafJMXConnectionProvider.this.fireAdded(con);
                    } else if (1.serverSwitchesToState((ServerEvent)event, (int)4)) {
                        AbstractKarafJMXConnectionProvider.this.fireRemoved(con);
                    }
                }
            }

            public void serverAdded(IServer server) {
                if (AbstractKarafJMXConnectionProvider.this.belongsHere(server)) {
                    AbstractKarafJMXConnectionProvider.this.getConnections();
                    if (!AbstractKarafJMXConnectionProvider.this.idToConnection.containsKey(server.getId())) {
                        IConnectionWrapper connection = AbstractKarafJMXConnectionProvider.this.createConnection(server);
                        AbstractKarafJMXConnectionProvider.this.idToConnection.put(server.getId(), connection);
                        if (connection != null && server.getServerState() == 2) {
                            AbstractKarafJMXConnectionProvider.this.fireAdded((IConnectionWrapper)AbstractKarafJMXConnectionProvider.this.idToConnection.get(server.getId()));
                        }
                    }
                }
            }

            public void serverChanged(IServer server) {
                if (AbstractKarafJMXConnectionProvider.this.belongsHere(server)) {
                    AbstractKarafJMXConnectionProvider.this.getConnections();
                    Object o = AbstractKarafJMXConnectionProvider.this.idToConnection.get(server.getId());
                    if (o == null) {
                        IConnectionWrapper connection = AbstractKarafJMXConnectionProvider.this.createConnection(server);
                        AbstractKarafJMXConnectionProvider.this.idToConnection.put(server.getId(), connection);
                        if (connection != null && server.getServerState() == 2) {
                            AbstractKarafJMXConnectionProvider.this.fireAdded((IConnectionWrapper)AbstractKarafJMXConnectionProvider.this.idToConnection.get(server.getId()));
                        }
                    }
                }
            }

            public void serverRemoved(IServer server) {
                if (AbstractKarafJMXConnectionProvider.this.belongsHere(server)) {
                    if (AbstractKarafJMXConnectionProvider.this.idToConnection != null) {
                        IConnectionWrapper connection = (IConnectionWrapper)AbstractKarafJMXConnectionProvider.this.idToConnection.get(server.getId());
                        if (connection != null) {
                            AbstractKarafJMXConnectionProvider.this.idToConnection.remove(server.getId());
                            AbstractKarafJMXConnectionProvider.this.fireRemoved(connection);
                        }
                    } else {
                        AbstractKarafJMXConnectionProvider.this.getConnections();
                        IConnectionWrapper dummy = AbstractKarafJMXConnectionProvider.this.createConnection(server);
                        if (dummy != null) {
                            AbstractKarafJMXConnectionProvider.this.fireRemoved(dummy);
                        }
                    }
                }
            }
        };
        return listener;
    }

    protected abstract boolean belongsHere(IServer var1);

    public abstract String getId();

    protected abstract IConnectionWrapper createConnection(IServer var1);

    public abstract String getName(IConnectionWrapper var1);

    public IConnectionWrapper findConnection(IServer s) {
        this.getConnections();
        return this.idToConnection.get(s.getId());
    }

    public IConnectionWrapper[] getConnections() {
        if (this.idToConnection == null) {
            this.idToConnection = new HashMap();
            IServer[] allServers = ServerCore.getServers();
            int i = 0;
            while (i < allServers.length) {
                IConnectionWrapper c;
                if (this.belongsHere(allServers[i]) && (c = this.createConnection(allServers[i])) != null) {
                    this.idToConnection.put(allServers[i].getId(), c);
                }
                ++i;
            }
        }
        ArrayList<IConnectionWrapper> list = new ArrayList<IConnectionWrapper>();
        Set<String> serverIds = this.idToConnection.keySet();
        for (String id : serverIds) {
            if (!this.isServerStarted(id)) continue;
            list.add(this.idToConnection.get(id));
        }
        return list.toArray(new IConnectionWrapper[list.size()]);
    }

    private boolean isServerStarted(String id) {
        IServer s = ServerCore.findServer((String)id);
        if (s != null) {
            return s.getServerState() == 2;
        }
        return false;
    }

    public boolean canCreate() {
        return false;
    }

    public IConnectionWrapper createConnection(Map map) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.fusesource.ide.jmx.karaf", "", null));
    }

    public void addConnection(IConnectionWrapper connection) {
    }

    public void removeConnection(IConnectionWrapper connection) {
    }

    public boolean canDelete(IConnectionWrapper wrapper) {
        return false;
    }

    public void connectionChanged(IConnectionWrapper connection) {
    }

    public String getCategoryId() {
        return "IConnectionCategory.server";
    }
}

