/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.karaf.connection;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;
import org.fusesource.ide.jmx.karaf.connection.KarafServerConnection;
import org.jboss.tools.jmx.jvmmonitor.core.AbstractJvm;
import org.jboss.tools.jmx.jvmmonitor.core.Activator;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IJvm;
import org.jboss.tools.jmx.jvmmonitor.core.ISWTResourceMonitor;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;
import org.jboss.tools.jmx.jvmmonitor.core.JvmModel;
import org.jboss.tools.jmx.jvmmonitor.core.JvmModelEvent;
import org.jboss.tools.jmx.jvmmonitor.core.cpu.ICpuProfiler;
import org.jboss.tools.jmx.jvmmonitor.core.mbean.IMBeanServer;
import org.jboss.tools.jmx.jvmmonitor.internal.core.AbstractMBeanServer;
import org.jboss.tools.jmx.jvmmonitor.internal.core.Messages;
import org.jboss.tools.jmx.jvmmonitor.internal.core.SWTResourceMonitor;
import org.jboss.tools.jmx.jvmmonitor.internal.core.Util;
import org.jboss.tools.jmx.jvmmonitor.internal.core.cpu.CpuProfiler;

public class KarafActiveJvm
extends AbstractJvm
implements IActiveJvm {
    private boolean isAttachSupported = true;
    private boolean isConnectSupported = true;
    private boolean isRemote = false;
    private boolean isAttached;
    private KarafMBeanServer mBeanServer;
    private ICpuProfiler cpuProfiler;
    private ISWTResourceMonitor swtResourceMonitor;
    private KarafServerConnection jmxConnection;
    private IActiveJvm delegateJvm;

    public KarafActiveJvm(KarafServerConnection connection, IActiveJvm delegate) throws JvmCoreException {
        super(delegate.getPid(), delegate.getHost());
        this.jmxConnection = connection;
        this.delegateJvm = delegate;
        this.initialize();
        this.connect();
        this.saveJvmProperties();
    }

    public void connect() throws JvmCoreException {
        this.connect(500);
    }

    public void connect(int updatePeriod) throws JvmCoreException {
        this.connect(updatePeriod, false);
    }

    public void connect(int updatePeriod, boolean attach) throws JvmCoreException {
        if (!this.isConnectSupported) {
            throw new IllegalStateException(Messages.connectNotSupportedMsg);
        }
        this.mBeanServer.connect(updatePeriod);
        if (attach) {
            this.attach(false);
        }
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmConnected, (IJvm)this));
    }

    public void attach() throws JvmCoreException {
        this.attach(true);
    }

    private void attach(boolean fireEvent) throws JvmCoreException {
        if (!this.isAttachSupported) {
            throw new IllegalStateException(Messages.attachNotSupportedMsg);
        }
        if (!this.isAttached) {
            if (!this.isRemote) {
                JvmModel.getInstance().getAgentLoadHandler().loadAgent((IActiveJvm)this);
                this.isAttached = true;
            }
            if (this.swtResourceMonitor.isSupported()) {
                this.swtResourceMonitor.setTracking(true);
            }
        }
        if (fireEvent) {
            JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmModified, (IJvm)this));
        }
    }

    public void disconnect() {
        this.mBeanServer.dispose();
        try {
            if (this.swtResourceMonitor.isSupported()) {
                this.swtResourceMonitor.setTracking(false);
            }
        }
        catch (JvmCoreException jvmCoreException) {}
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmDisconnected, (IJvm)this));
    }

    public boolean isAttached() {
        return this.isAttached;
    }

    public boolean isConnected() {
        return this.jmxConnection.isConnected();
    }

    public boolean isConnectionSupported() {
        return this.isAttachSupported;
    }

    public String getErrorStateMessage() {
        return null;
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public IMBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public ICpuProfiler getCpuProfiler() {
        return this.cpuProfiler;
    }

    public ISWTResourceMonitor getSWTResourceMonitor() {
        return this.swtResourceMonitor;
    }

    public String toString() {
        return this.getMainClass();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveJvmProperties() {
        IFileStore fileStore;
        try {
            fileStore = Util.getFileStore((String)"properties.xml", (IPath)this.getPersistenceDirectory());
            if (fileStore.fetchInfo().exists()) {
                return;
            }
        }
        catch (JvmCoreException e) {
            Activator.log((int)4, (String)Messages.savePropertiesFileFailedMsg, (Throwable)e);
            return;
        }
        Properties props = new Properties();
        OutputStream os = null;
        try {
            os = fileStore.openOutputStream(0, null);
            int pid = this.getPid();
            int port = this.getPort();
            String mainClass = this.getMainClass();
            props.setProperty("Pid", String.valueOf(pid));
            props.setProperty("Port", String.valueOf(port));
            if (mainClass != null) {
                props.setProperty("MainClass", mainClass);
            }
            props.setProperty("Host", this.getHost().getName());
            props.storeToXML(os, "JVM Properties");
        }
        catch (CoreException e) {
            Activator.log((int)4, (String)NLS.bind((String)Messages.openOutputStreamFailedMsg, (Object)fileStore.toURI().getPath()), (Throwable)e);
            if (os == null) return;
            try {
                os.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            try {
                try {
                    fileStore.delete(0, null);
                }
                catch (CoreException coreException) {}
                Activator.log((int)4, (String)NLS.bind((String)Messages.writePropertiesFileFailedMsg, (Object)fileStore.toURI().getPath()), (Throwable)e);
                if (os == null) return;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (IOException iOException) {}
    }

    private void initialize() {
        this.mBeanServer = this.createMBeanServer();
        this.cpuProfiler = new CpuProfiler((IActiveJvm)this);
        this.swtResourceMonitor = new SWTResourceMonitor((IActiveJvm)this);
    }

    private KarafMBeanServer createMBeanServer() {
        return new KarafMBeanServer(this.jmxConnection, this);
    }

    private static class KarafMBeanServer
    extends AbstractMBeanServer {
        private KarafServerConnection jmxConn;

        protected KarafMBeanServer(KarafServerConnection connection, IActiveJvm jvm) {
            super(jvm);
            this.setJvmReachable(true);
            this.jmxConn = connection;
        }

        public MBeanServerConnection getConnection() {
            return this.jmxConn.getActiveConnection();
        }

        protected MBeanServerConnection createMBeanServerConnection() throws JvmCoreException {
            return this.getConnection();
        }

        public void connect(int updatePeriod) throws JvmCoreException {
            super.connect(updatePeriod);
        }

        public void dispose() {
            super.dispose();
        }
    }
}

