/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.karaf.navigator.osgi;

import java.util.ArrayList;
import java.util.List;
import javax.management.openmbean.TabularData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.foundation.ui.propsrc.PropertySourceTableSheetPage;
import org.fusesource.ide.foundation.ui.tree.RefreshableCollectionNode;
import org.fusesource.ide.jmx.karaf.KarafJMXPlugin;
import org.fusesource.ide.jmx.karaf.navigator.osgi.OsgiFacade;
import org.fusesource.ide.jmx.karaf.navigator.osgi.ServicesTableSheetPage;
import org.fusesource.ide.jmx.karaf.navigator.osgi.TabularDataHelper;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class ServicesNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final OsgiFacade facade;

    public ServicesNode(Node parent, OsgiFacade facade) {
        super(parent);
        this.facade = facade;
    }

    public String toString() {
        return "Services";
    }

    public Image getImage() {
        return KarafJMXPlugin.getDefault().getImage("container.png");
    }

    protected void loadChildren() {
    }

    public OsgiFacade getFacade() {
        return this.facade;
    }

    protected PropertySourceTableSheetPage createPropertySourceTableSheetPage() {
        return new ServicesTableSheetPage(this);
    }

    public List<IPropertySource> getPropertySourceList() {
        ArrayList<IPropertySource> answer = new ArrayList<IPropertySource>();
        try {
            TabularData tabularData = this.facade.listServices();
            return TabularDataHelper.toPropertySources(tabularData);
        }
        catch (Exception e) {
            KarafJMXPlugin.getLogger().error("Failed to fetch bundle state: " + e, (Throwable)e);
            return answer;
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof ServicesNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.getConnection() != null && this.getConnection().getProvider() != null) {
            return ("OSGiServicesNode" + this.getConnection().getProvider().getName(this.getConnection())).hashCode();
        }
        return super.hashCode();
    }
}

