/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.designer.webservice.IWebServiceResource;
import org.teiid.designer.webservice.WebServicePlugin;

public abstract class AbstractWebServiceResource
implements IWebServiceResource {
    private final String fullPath;
    private final String namespace;
    private final Set referencingResources;
    private final Set referencedResources = new HashSet();
    private final Set resolvedByThis;
    private IWebServiceResource resolvedResource;

    protected AbstractWebServiceResource(String namespace, String fullPath) {
        this.referencingResources = new HashSet();
        this.resolvedByThis = new HashSet();
        this.fullPath = fullPath != null && fullPath.trim().length() != 0 ? fullPath : null;
        this.namespace = namespace;
    }

    protected abstract boolean exists();

    protected abstract File doGetFile();

    protected abstract InputStream doGetRawInputStream() throws Exception;

    @Override
    public String getFullPath() {
        if (this.fullPath != null && this.isResolvedToSelf()) {
            return this.fullPath;
        }
        if (this.getResolvedResource() != null) {
            return this.getResolvedResource().getFullPath();
        }
        return null;
    }

    @Override
    public File getFile() {
        if (this.resolvedResource != null) {
            return this.getResolvedResource().getFile();
        }
        return this.doGetFile();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isWsdl() {
        String path = this.getFullPath();
        return path != null && path.length() > "wsdl".length() && path.toLowerCase().endsWith(".wsdl");
    }

    @Override
    public InputStream getInputStream() throws Exception {
        if (this.isResolvedToSelf()) {
            if (this.exists()) {
                InputStream rawStream = this.doGetRawInputStream();
                return new BufferedInputStream(rawStream);
            }
            return null;
        }
        if (this.resolvedResource != null) {
            return this.resolvedResource.getInputStream();
        }
        return null;
    }

    @Override
    public boolean isXsd() {
        String path = this.getFullPath();
        return path != null && path.length() > "xsd".length() && path.toLowerCase().endsWith(".xsd");
    }

    @Override
    public Collection getReferencingResources() {
        return this.referencingResources;
    }

    @Override
    public Collection getReferencedResources() {
        return this.referencedResources;
    }

    public synchronized void removeFromAllReferencers() {
        for (AbstractWebServiceResource referencing : this.getReferencingResources()) {
            referencing.removeReferencedResource(this);
        }
    }

    public synchronized boolean removeReferencedResource(IWebServiceResource referenced) {
        if (referenced == null) {
            return false;
        }
        if (referenced == this) {
            return false;
        }
        boolean removedReferenced = this.referencedResources.remove(referenced);
        if (removedReferenced && referenced instanceof AbstractWebServiceResource) {
            ((AbstractWebServiceResource)referenced).referencingResources.remove(this);
        }
        return removedReferenced;
    }

    public synchronized boolean addReferencedResource(IWebServiceResource referenced) {
        if (referenced == null) {
            return false;
        }
        if (referenced == this) {
            return false;
        }
        boolean directOrIndirect = this.isReferencedDirectlyOrIndirectly(referenced);
        if (directOrIndirect) {
            return false;
        }
        this.referencedResources.add(referenced);
        if (referenced instanceof AbstractWebServiceResource) {
            ((AbstractWebServiceResource)referenced).referencingResources.add(this);
        }
        return true;
    }

    protected boolean isReferencedDirectlyOrIndirectly(IWebServiceResource referenced) {
        for (AbstractWebServiceResource directRef : this.referencedResources) {
            if (directRef.equals(referenced)) {
                return true;
            }
            boolean indirect = directRef.isReferencedDirectlyOrIndirectly(referenced);
            if (!indirect) continue;
            return true;
        }
        return false;
    }

    @Override
    public IStatus getStatus() {
        if (this.isResolvedToSelf()) {
            Object[] params = new Object[]{this.getNamespace(), this.getFullPath()};
            String msg = WebServicePlugin.Util.getString("AbstractWebServiceResource.NamespaceIsResolvedToSelf", params);
            return new Status(0, "org.teiid.designer.webservice", 1, msg, null);
        }
        if (this.isResolved()) {
            Object[] params = new Object[]{this.getNamespace(), this.getFullPath()};
            String msg = WebServicePlugin.Util.getString("AbstractWebServiceResource.NamespaceIsResolved", params);
            return new Status(0, "org.teiid.designer.webservice", 2, msg, null);
        }
        if (this.getFullPath() != null) {
            Object[] params = new Object[]{this.getNamespace(), this.getFullPath()};
            String msg = WebServicePlugin.Util.getString("AbstractWebServiceResource.NamespaceIsResolvedToNonExistantFile", params);
            return new Status(4, "org.teiid.designer.webservice", 3, msg, null);
        }
        Object[] params = new Object[]{this.getNamespace()};
        String msg = WebServicePlugin.Util.getString("AbstractWebServiceResource.NamespaceIsUnresolved", params);
        return new Status(4, "org.teiid.designer.webservice", 4, msg, null);
    }

    @Override
    public boolean isResolved() {
        if (this.isResolvedToSelf()) {
            return true;
        }
        if (this.resolvedResource == null) {
            return this.exists();
        }
        return this.resolvedResource.isResolved();
    }

    @Override
    public boolean isResolvedToSelf() {
        return this.resolvedResource == null && this.exists();
    }

    @Override
    public IWebServiceResource getResolvedResource() {
        return this.exists() && this.resolvedResource == null ? this : this.resolvedResource;
    }

    @Override
    public Collection getResourcesResolved() {
        return this.resolvedByThis;
    }

    @Override
    public IWebServiceResource getLastResolvedResource() {
        IWebServiceResource result = this;
        while (result != null) {
            IWebServiceResource resolved = result.getResolvedResource();
            if (resolved == null || resolved == result) {
                return resolved;
            }
            result = result.getResolvedResource();
        }
        return null;
    }

    @Override
    public boolean setResolvedResource(IWebServiceResource resource) {
        if (resource == this.resolvedResource) {
            return true;
        }
        if (this.resolvedResource instanceof AbstractWebServiceResource) {
            ((AbstractWebServiceResource)this.resolvedResource).resolvedByThis.remove(this);
        }
        if (resource == null) {
            this.resolvedResource = null;
            return true;
        }
        if (resource == this) {
            if (this.exists()) {
                this.resolvedResource = this;
                return true;
            }
            return false;
        }
        this.resolvedResource = resource;
        if (this.resolvedResource instanceof AbstractWebServiceResource) {
            ((AbstractWebServiceResource)this.resolvedResource).resolvedByThis.add(this);
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractWebServiceResource that = (AbstractWebServiceResource)obj;
        if (!this.getNamespace().equals(that.getNamespace())) {
            return false;
        }
        if (this.exists() != that.exists()) {
            return false;
        }
        String thisPath = this.getFullPath();
        String thatPath = that.getFullPath();
        if (thisPath == null) {
            if (thatPath != null) {
                return false;
            }
        } else {
            if (thatPath == null) {
                return false;
            }
            if (!this.getFullPath().equals(that.getFullPath())) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.namespace});
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getFullPath()});
        return hc;
    }

    public String toString() {
        if (this.isResolvedToSelf()) {
            return String.valueOf(this.getNamespace()) + "->self->" + this.getFullPath();
        }
        return String.valueOf(this.getNamespace()) + "->" + this.getFullPath();
    }
}

