/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDFactoryImpl;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.compare.ModelGenerator;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelWorkspaceItem;
import org.teiid.designer.core.workspace.ModelWorkspaceManager;
import org.teiid.designer.metamodels.wsdl.Definitions;
import org.teiid.designer.metamodels.wsdl.Import;
import org.teiid.designer.metamodels.wsdl.Types;
import org.teiid.designer.webservice.AbstractWebServiceResource;
import org.teiid.designer.webservice.FileSystemWebServiceResource;
import org.teiid.designer.webservice.IInternalWebServiceXsdResource;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceResource;
import org.teiid.designer.webservice.IWebServiceXsdResource;
import org.teiid.designer.webservice.NonResolvableXSDSchema;
import org.teiid.designer.webservice.UnresolvedWebServiceResource;
import org.teiid.designer.webservice.WebServicePlugin;
import org.teiid.designer.webservice.WebServiceResources;
import org.teiid.designer.webservice.WebServiceXsdResource;
import org.teiid.designer.webservice.WorkspaceFileWebServiceResource;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BasicWebServiceModelBuilder
implements IWebServiceModelBuilder {
    private IResource parentResource;
    private MetamodelDescriptor modelDescriptor;
    private IPath modelPath;
    private IPath xmlModel;
    private final List resources;
    private Collection selectedWsdlOperations;
    private final Map emfResourceUriByWebServiceResource;
    private final WebServiceResources resourceSet;
    private List xsdWorkspaceResources;
    private final Object xsdWorkspaceResourcesLock = new Object();
    private boolean saveAllBeforeFinish = false;
    private Map urlMap = new HashMap();
    private boolean processedXsdResources = false;

    public BasicWebServiceModelBuilder() {
        this.resources = new ArrayList();
        this.resourceSet = new WebServiceResources();
        this.emfResourceUriByWebServiceResource = new HashMap();
        this.selectedWsdlOperations = new HashSet();
        this.xsdWorkspaceResources = new ArrayList();
    }

    @Override
    public IPath getXmlModel() {
        return this.xmlModel;
    }

    @Override
    public IResource getParentResource() {
        return this.parentResource;
    }

    @Override
    public IPath getModelPath() {
        return this.modelPath;
    }

    @Override
    public Map getUrlMap() {
        return this.urlMap;
    }

    @Override
    public void setMetamodelDescriptor(MetamodelDescriptor theDescriptor) {
        this.modelDescriptor = theDescriptor;
    }

    @Override
    public void setParentResource(IResource theResource) {
        this.parentResource = theResource;
    }

    @Override
    public void setModelPath(IPath thePath) {
        this.modelPath = thePath;
    }

    @Override
    public void setXmlModel(IPath theXmlModel) {
        this.xmlModel = theXmlModel;
    }

    protected IWebServiceResource addOrFind(IWebServiceResource resource) {
        for (IWebServiceResource r : this.resources) {
            if (!r.equals(resource)) continue;
            return r;
        }
        this.resources.add(resource);
        return resource;
    }

    @Override
    public IWebServiceResource addResource(File theFile) throws CoreException {
        CoreArgCheck.isNotNull((Object)theFile);
        if (!theFile.exists()) {
            Object[] params = new Object[]{theFile};
            String msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.FileDoesNotExist", params);
            throw new IllegalArgumentException(msg);
        }
        URI uri = URI.createFileURI((String)theFile.getAbsolutePath());
        Resource resource = null;
        try {
            resource = this.resourceSet.add(uri);
        }
        catch (Exception theException) {
            this.resourceSet.remove(uri);
            String msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.ProblemLoadingWsdl", (Object)theFile);
            Status status = new Status(4, "org.teiid.designer.webservice", 0, msg, (Throwable)theException);
            throw new CoreException((IStatus)status);
        }
        String targetNamespace = this.resourceSet.getTargetNamespace(resource);
        AbstractWebServiceResource wsResource = new FileSystemWebServiceResource(targetNamespace, theFile);
        this.emfResourceUriByWebServiceResource.put(wsResource.getFullPath(), uri);
        wsResource = (AbstractWebServiceResource)this.addOrFind(wsResource);
        this.processedXsdResources = false;
        this.xsdWorkspaceResources = new ArrayList();
        return wsResource;
    }

    @Override
    public IWebServiceResource addResource(IFile theFile) throws CoreException {
        CoreArgCheck.isNotNull((Object)theFile);
        if (!theFile.exists()) {
            Object[] params = new Object[]{theFile};
            String msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.FileDoesNotExist", params);
            throw new IllegalArgumentException(msg);
        }
        URI uri = URI.createFileURI((String)theFile.getFullPath().toString());
        Resource resource = null;
        try {
            resource = this.resourceSet.add(uri);
        }
        catch (Exception theException) {
            this.resourceSet.remove(uri);
            String msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.ProblemLoadingWsdl", (Object)theFile);
            Status status = new Status(4, "org.teiid.designer.webservice", 0, msg, (Throwable)theException);
            throw new CoreException((IStatus)status);
        }
        String targetNamespace = this.resourceSet.getTargetNamespace(resource);
        AbstractWebServiceResource wsResource = new WorkspaceFileWebServiceResource(targetNamespace, theFile);
        this.emfResourceUriByWebServiceResource.put(wsResource.getFullPath(), uri);
        wsResource = (AbstractWebServiceResource)this.addOrFind(wsResource);
        this.processedXsdResources = false;
        this.xsdWorkspaceResources = new ArrayList();
        return wsResource;
    }

    @Override
    public void resolve(IWebServiceResource resource, File theFile) {
        Collection resolvesResources;
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)theFile);
        FileSystemWebServiceResource resolved = new FileSystemWebServiceResource(resource.getNamespace(), theFile);
        IWebServiceResource origResolvedResource = resolved.getResolvedResource();
        if (resource instanceof AbstractWebServiceResource) {
            ((AbstractWebServiceResource)resource).setResolvedResource(resolved);
        }
        if (origResolvedResource != null && (resolvesResources = origResolvedResource.getResourcesResolved()).size() == 0) {
            this.remove(origResolvedResource);
        }
    }

    @Override
    public void unresolve(IWebServiceResource resource) {
        URI uri;
        CoreArgCheck.isNotNull((Object)resource);
        if (resource.isResolved()) {
            resource.setResolvedResource(null);
        }
        if ((uri = (URI)this.emfResourceUriByWebServiceResource.remove(resource.getFullPath())) != null) {
            this.resourceSet.remove(uri);
        }
    }

    @Override
    public void resolve(IWebServiceResource resource, IFile theFile) {
        Collection resolvesResources;
        CoreArgCheck.isNotNull((Object)resource);
        CoreArgCheck.isNotNull((Object)theFile);
        WorkspaceFileWebServiceResource resolved = new WorkspaceFileWebServiceResource(resource.getNamespace(), theFile);
        IWebServiceResource origResolvedResource = resolved.getResolvedResource();
        if (resource instanceof AbstractWebServiceResource) {
            ((AbstractWebServiceResource)resource).setResolvedResource(resolved);
        }
        if (origResolvedResource != null && (resolvesResources = origResolvedResource.getResourcesResolved()).size() == 0) {
            this.remove(origResolvedResource);
        }
    }

    @Override
    public void remove(IWebServiceResource theResource) {
        CoreArgCheck.isNotNull((Object)theResource);
        if (!this.resources.remove(theResource)) {
            return;
        }
        URI uri = (URI)this.emfResourceUriByWebServiceResource.remove(theResource.getFullPath());
        if (uri != null) {
            this.resourceSet.remove(uri);
        }
        if (theResource instanceof AbstractWebServiceResource) {
            AbstractWebServiceResource wsResource = (AbstractWebServiceResource)theResource;
            wsResource.removeFromAllReferencers();
            for (AbstractWebServiceResource referenced : wsResource.getReferencedResources()) {
                wsResource.removeReferencedResource(referenced);
                if (referenced.getReferencingResources().size() != 0) continue;
                this.remove(referenced);
            }
        }
        this.processedXsdResources = false;
        this.xsdWorkspaceResources = new ArrayList();
    }

    public Collection getResources() {
        return this.resources;
    }

    @Override
    public Resource getEmfResource(IWebServiceResource theResource) {
        URI uri = (URI)this.emfResourceUriByWebServiceResource.get(theResource.getFullPath());
        if (uri != null) {
            return this.resourceSet.get(uri);
        }
        return null;
    }

    @Override
    public Collection getWSDLResources() {
        ArrayList<IWebServiceResource> resourcesCollection = new ArrayList<IWebServiceResource>();
        LinkedList<IWebServiceResource> resourcesToProcessForDependencies = new LinkedList<IWebServiceResource>(this.resources);
        while (!resourcesToProcessForDependencies.isEmpty()) {
            URI uri;
            Resource resourceToProcess;
            IWebServiceResource wsResourceToProcess = (IWebServiceResource)resourcesToProcessForDependencies.removeFirst();
            resourcesCollection.add(wsResourceToProcess);
            if (wsResourceToProcess == null || wsResourceToProcess instanceof UnresolvedWebServiceResource || !this.resourceSet.isWsdl(resourceToProcess = this.resourceSet.add(uri = URI.createFileURI((String)wsResourceToProcess.getFullPath())))) continue;
            EList roots = resourceToProcess.getContents();
            for (Object object : roots) {
                if (!(object instanceof Definitions)) continue;
                Definitions defns = (Definitions)object;
                EList imports = defns.getImports();
                Iterator iter2 = imports.iterator();
                while (iter2.hasNext()) {
                    File f;
                    IWebServiceResource wsr = null;
                    Import theImport = (Import)iter2.next();
                    URI locationUri = URI.createURI((String)theImport.getLocation());
                    URI resolvedLocationUri = locationUri.resolve(uri);
                    if (resolvedLocationUri != null && resolvedLocationUri.isFile() && (f = new File(resolvedLocationUri.toFileString())).exists()) {
                        wsr = new FileSystemWebServiceResource(theImport.getNamespace(), f);
                    }
                    if (wsr == null) {
                        wsr = new UnresolvedWebServiceResource(theImport.getNamespace());
                    }
                    if ((wsr = this.addOrFind(wsr)) instanceof AbstractWebServiceResource) {
                        ((AbstractWebServiceResource)wsResourceToProcess).addReferencedResource(wsr);
                    }
                    if (this.emfResourceUriByWebServiceResource.get(wsr.getFullPath()) != null) continue;
                    this.emfResourceUriByWebServiceResource.put(wsr.getFullPath(), resolvedLocationUri);
                    resourcesToProcessForDependencies.add(wsr);
                }
            }
        }
        return resourcesCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection getXsdDestinations() {
        List xsdResources = this.xsdWorkspaceResources;
        if (!this.processedXsdResources) {
            Object object = this.xsdWorkspaceResourcesLock;
            synchronized (object) {
                List xsdWsrTuples = this.doDiscoverReferencedXsds();
                ArrayList usedNames = new ArrayList();
                for (XSDWebServiceResourceTuple tuple : xsdWsrTuples) {
                    IWebServiceXsdResource wsXsdResource;
                    XSDSchema schema = tuple.getSchema();
                    IWebServiceResource wsr = tuple.getResource();
                    boolean inWorkspaceAlready = wsr instanceof WorkspaceFileWebServiceResource;
                    if (!wsr.isWsdl() && (!wsr.isXsd() || inWorkspaceAlready) || (wsXsdResource = this.doCreateWebServiceXsdResource(schema, wsr, usedNames)) == null) continue;
                    this.xsdWorkspaceResources.add(wsXsdResource);
                }
                xsdResources = this.xsdWorkspaceResources;
                this.processedXsdResources = true;
            }
        }
        return xsdResources;
    }

    @Override
    public void setDestinationPath(IWebServiceXsdResource xsdResource, IPath workspacePathForXsd) {
        if (xsdResource instanceof IInternalWebServiceXsdResource) {
            IPath existing = xsdResource.getDestinationPath();
            boolean match = false;
            if (existing == null) {
                if (workspacePathForXsd == null) {
                    match = true;
                }
            } else {
                match = workspacePathForXsd == null ? existing.segmentCount() == 0 : (!existing.toFile().exists() ? false : existing.makeAbsolute().equals((Object)workspacePathForXsd.makeAbsolute()));
            }
            if (!match) {
                ((IInternalWebServiceXsdResource)xsdResource).setDestinationPath(workspacePathForXsd.makeAbsolute());
            }
        }
    }

    public IWebServiceXsdResource doCreateWebServiceXsdResource(XSDSchema schema, IWebServiceResource origResource, List usedNames) {
        WebServiceXsdResource result = new WebServiceXsdResource(schema, schema.getTargetNamespace(), schema.eResource().getURI().toFileString());
        try {
            URI schemaUri = schema.eResource().getURI();
            schemaUri = schemaUri.isFile() ? URI.createFileURI((String)schemaUri.toFileString()) : schema.eResource().getURI();
            URI wsdlUri = URI.createFileURI((String)origResource.getFullPath());
            IPath webServiceContainerPath = this.modelPath.removeLastSegments(1);
            if (wsdlUri.equals(schemaUri)) {
                URI wsdlUriWOFileExtension = wsdlUri.trimFileExtension();
                String name = wsdlUriWOFileExtension.lastSegment();
                String uniqueName = this.getUniqueName(name, usedNames);
                IPath uniqueSchemaNamePath = webServiceContainerPath.append(String.valueOf(uniqueName) + ".xsd");
                result.setDestinationPath(uniqueSchemaNamePath);
            } else {
                URI relativeUri = schemaUri.deresolve(wsdlUri);
                if (!relativeUri.isFile()) {
                    relativeUri = URI.createURI((String)relativeUri.path());
                }
                String workspacePath = null;
                workspacePath = relativeUri.isRelative() ? relativeUri.toString() : schemaUri.lastSegment();
                IPath newPath = webServiceContainerPath.append(workspacePath);
                result.setDestinationPath(newPath);
            }
        }
        catch (RuntimeException err) {
            WebServicePlugin.Util.log((Throwable)err);
        }
        return result;
    }

    private String getUniqueName(String name, Collection collection) {
        if (collection == null) {
            collection = Collections.EMPTY_SET;
        }
        String result = name;
        int incr = 1;
        while (collection.contains(result)) {
            result = String.valueOf(name) + incr;
            ++incr;
        }
        collection.add(result);
        return result;
    }

    protected List doDiscoverReferencedXsds() {
        LinkedList<XSDWebServiceResourceTuple> wsResourceTuples = new LinkedList<XSDWebServiceResourceTuple>();
        ArrayList<String> schemaPathsAlreadyAdded = new ArrayList<String>();
        for (IWebServiceResource wsr : this.getResources()) {
            Resource emfResource;
            IWebServiceResource resolved = wsr.getLastResolvedResource();
            if (resolved == null) continue;
            boolean findXsdSchema = false;
            if (resolved.isWsdl()) {
                findXsdSchema = true;
            } else if (resolved.isXsd() && !(resolved instanceof WorkspaceFileWebServiceResource)) {
                findXsdSchema = true;
            }
            if (!findXsdSchema || (emfResource = this.getEmfResource(wsr)) == null) continue;
            EList roots = emfResource.getContents();
            for (EObject root : roots) {
                ArrayList schemas = new ArrayList();
                if (root instanceof Definitions) {
                    schemas.addAll(this.doDiscoverReferencedXsdsForWSDLResource((Definitions)root, emfResource));
                } else if (root instanceof XSDSchema) {
                    schemas.addAll(this.processSchemas((XSDSchema)root, schemas, emfResource, new ArrayList()));
                }
                for (XSDSchema schema : schemas) {
                    if (schema == null) continue;
                    XSDWebServiceResourceTuple tuple = new XSDWebServiceResourceTuple(wsr, schema);
                    String schemaPath = schema.eResource().getURI().toString();
                    if (root instanceof Definitions) {
                        wsResourceTuples.add(tuple);
                        continue;
                    }
                    if (schemaPathsAlreadyAdded.contains(schemaPath)) continue;
                    schemaPathsAlreadyAdded.add(schemaPath);
                    wsResourceTuples.add(tuple);
                }
            }
        }
        return wsResourceTuples;
    }

    protected List doDiscoverReferencedXsdsForWSDLResource(Definitions wsdlDefinition, Resource emfResource) {
        EList schemasFromTypes;
        ArrayList schemas = new ArrayList();
        Types types = wsdlDefinition.getTypes();
        if (types != null && (schemasFromTypes = types.getSchemas()) != null) {
            for (XSDSchemaImpl schemaTemp : schemasFromTypes) {
                this.processSchemas((XSDSchema)schemaTemp, schemas, emfResource, new ArrayList());
            }
        }
        return schemas;
    }

    protected List getSchemaImportsAndIncludes(XSDSchema schema) {
        LinkedList referencingDirectives = new LinkedList();
        for (Object contentObject : schema.eContents()) {
            if (contentObject instanceof XSDSchemaDirective) {
                referencingDirectives.add(contentObject);
                continue;
            }
            if (!(contentObject instanceof XSDAnnotation)) break;
        }
        return referencingDirectives;
    }

    protected List processSchemas(XSDSchema schema, List schemas, Resource referrringResource, List schemaLocationsAlreadyAdded) {
        for (XSDSchemaContent xsdSchemaContent : schema.getContents()) {
            if (xsdSchemaContent instanceof XSDSchemaDirective) {
                Object o;
                Resource resSchemaResource;
                URI uriSchemaLocation;
                block11: {
                    NonResolvableXSDSchema xsdImpl;
                    XSDSchemaDirective xsdImportImpl = (XSDSchemaDirective)xsdSchemaContent;
                    String sSchemaLocation = xsdImportImpl.getSchemaLocation();
                    if (sSchemaLocation == null) {
                        Node schemaObject = xsdImportImpl.getElement().getAttributes().getNamedItem("schemaLocation");
                        if (schemaObject == null) continue;
                        sSchemaLocation = xsdImportImpl.getElement().getAttributes().getNamedItem("schemaLocation").toString();
                        sSchemaLocation = this.trimNamedItem(sSchemaLocation, "schemaLocation");
                    }
                    if ((uriSchemaLocation = URI.createURI((String)sSchemaLocation)).isRelative()) {
                        URI referringResourceUri = referrringResource.getURI();
                        uriSchemaLocation = uriSchemaLocation.resolve(referringResourceUri);
                    }
                    if (schemaLocationsAlreadyAdded.contains(uriSchemaLocation)) continue;
                    resSchemaResource = null;
                    try {
                        resSchemaResource = ModelerCore.getModelContainer().getResource(uriSchemaLocation, true);
                        if (resSchemaResource == null) {
                            NonResolvableXSDSchema xsdImpl2 = new NonResolvableXSDSchema(uriSchemaLocation);
                            if (!schemas.contains((Object)xsdImpl2)) {
                                schemas.add(xsdImpl2);
                            }
                            String sMessage = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.ProblemLoadingXsdFromImport", (Object)URI.decode((String)uriSchemaLocation.toString()));
                            this.addDiagnosticToSchema(xsdImpl2, sMessage);
                        }
                    }
                    catch (CoreException theException) {
                        xsdImpl = new NonResolvableXSDSchema(uriSchemaLocation);
                        this.addDiagnosticToSchema(xsdImpl, theException.getLocalizedMessage());
                        if (!schemas.contains((Object)xsdImpl)) {
                            schemas.add(xsdImpl);
                        }
                    }
                    catch (Exception theException) {
                        xsdImpl = new NonResolvableXSDSchema(uriSchemaLocation);
                        this.addDiagnosticToSchema(xsdImpl, theException.getLocalizedMessage());
                        if (schemas.contains((Object)xsdImpl)) break block11;
                        schemas.add(xsdImpl);
                    }
                }
                if (resSchemaResource == null || resSchemaResource.getContents() == null || resSchemaResource.getContents().size() <= 0 || !((o = resSchemaResource.getContents().get(0)) instanceof XSDSchema)) continue;
                XSDSchema tempSchema = (XSDSchema)o;
                schemaLocationsAlreadyAdded.add(uriSchemaLocation);
                if (!schemas.contains(o)) {
                    schemas.add(o);
                }
                this.processSchemas(tempSchema, schemas, resSchemaResource, schemaLocationsAlreadyAdded);
                continue;
            }
            if (xsdSchemaContent instanceof XSDAnnotation) continue;
            if (schemas.contains(schema)) break;
            schemas.add(schema);
            break;
        }
        return schemas;
    }

    private void addDiagnosticToSchema(XSDSchemaImpl schema, String sMessage) {
        XSDDiagnostic xsdDiagnostic = new XSDFactoryImpl().createXSDDiagnostic();
        XSDDiagnosticSeverity severity = XSDDiagnosticSeverity.get((int)1);
        xsdDiagnostic.setSeverity(severity);
        xsdDiagnostic.setMessage(sMessage);
        xsdDiagnostic.setPrimaryComponent((XSDConcreteComponent)schema);
        xsdDiagnostic.setNode((Node)schema.getElement());
        Element theElement = schema.getElement();
        xsdDiagnostic.setNode((Node)theElement);
        schema.getDiagnostics().add((Object)xsdDiagnostic);
    }

    private String trimNamedItem(String sNamedItem, String sId) {
        String sResult = sNamedItem;
        String sMatchString = String.valueOf(sId) + "=" + "\"";
        if (sResult.startsWith(sMatchString)) {
            sResult = sResult.substring(sMatchString.length() - 1);
        }
        sResult = sResult.replace('\"', ' ');
        sResult = sResult.trim();
        return sResult;
    }

    public String getNamespaceFromImport(XSDSchema schema) {
        String sResultNamespace = null;
        int i = 0;
        while (i < schema.eContents().size()) {
            NamedNodeMap nodeMap;
            XSDImportImpl xsdImport;
            Element element;
            Object o = schema.eContents().get(i);
            if (o instanceof XSDImportImpl && (element = (xsdImport = (XSDImportImpl)o).getElement()) != null && (nodeMap = element.getAttributes()) != null) {
                sResultNamespace = nodeMap.getNamedItem("namespace").toString();
                break;
            }
            ++i;
        }
        return sResultNamespace;
    }

    @Override
    public IStatus validateWSDLNamespaces() {
        String msg;
        LinkedList<Object> problems = new LinkedList<Object>();
        boolean foundErrors = false;
        if (this.parentResource == null) {
            msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.MissingWebServiceModelLocation", new Object[0]);
            problems.add(new Status(4, "org.teiid.designer.webservice", 18107, msg, null));
            foundErrors = true;
        } else if (!this.parentResource.exists()) {
            msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.NonExistantWebServiceModelLocation", new Object[0]);
            problems.add(new Status(4, "org.teiid.designer.webservice", 18106, msg, null));
            foundErrors = true;
        }
        if (this.modelPath == null) {
            msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.MissingWebServiceModelPath", new Object[0]);
            problems.add(new Status(4, "org.teiid.designer.webservice", 18105, msg, null));
            foundErrors = true;
        }
        if (this.modelDescriptor == null) {
            msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.MissingWebServiceModelDescriptor", new Object[0]);
            problems.add(new Status(4, "org.teiid.designer.webservice", 18104, msg, null));
            foundErrors = true;
        }
        ArrayList<Status> unresolved = new ArrayList<Status>();
        for (IWebServiceResource resource : this.getResources()) {
            if (resource.isResolved()) continue;
            Object[] params = new Object[]{resource.getNamespace()};
            String msg2 = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.UnresolvedNamespace", params);
            unresolved.add(new Status(4, "org.teiid.designer.webservice", 18102, msg2, null));
            foundErrors = true;
        }
        if (!unresolved.isEmpty()) {
            int size = unresolved.size();
            if (size == 1) {
                problems.add(unresolved.get(0));
            } else if (size > 1) {
                IStatus[] errors = new IStatus[size];
                int i = 0;
                while (i < size) {
                    errors[i] = (IStatus)unresolved.get(i);
                    ++i;
                }
                Object[] params = new Object[]{new Integer(size)};
                String msg3 = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.MultipleUnresolvedNamespaces", params);
                problems.add(new MultiStatus("org.teiid.designer.webservice", 18102, errors, msg3, null));
            }
        }
        return this.constructStatuses(problems, foundErrors);
    }

    @Override
    public IStatus validateXSDNamespaces() {
        LinkedList<IStatus> problems = new LinkedList<IStatus>();
        boolean foundErrors = false;
        for (IWebServiceXsdResource dest : this.getXsdDestinations()) {
            IStatus status = dest.isValid();
            if (status.getSeverity() != 2 && status.getSeverity() != 4) continue;
            problems.add(status);
            foundErrors = true;
        }
        return this.constructStatuses(problems, foundErrors);
    }

    public IStatus constructStatuses(List problems, boolean foundErrors) {
        IStatus result = null;
        if (problems.size() == 0) {
            String msg = WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.ReadyToGenerate", new Object[0]);
            result = new Status(0, "org.teiid.designer.webservice", 0, msg, null);
        } else if (problems.size() == 1) {
            result = (IStatus)problems.get(0);
        } else {
            String msg = foundErrors ? WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.UnableToGenerate", new Object[0]) : WebServicePlugin.Util.getString("BasicWebServiceModelBuilder.ReadyToGenerate", new Object[0]);
            MultiStatus multi = new MultiStatus("org.teiid.designer.webservice", 18101, msg, null);
            for (IStatus problem : problems) {
                multi.add(problem);
            }
            result = multi;
        }
        return result;
    }

    @Override
    public ModelGenerator getModelGenerator(boolean isNewModel) {
        return this.doCreateModelGenerator(isNewModel);
    }

    protected ModelGenerator doCreateModelGenerator(boolean isNewModel) {
        ModelGenerator generator = WebServicePlugin.createModelGenerator(this);
        String desc = null;
        generator.setDescription(desc);
        generator.setNewModelCase(isNewModel);
        generator.setSaveAllBeforeFinish(this.saveAllBeforeFinish);
        return generator;
    }

    @Override
    public void setSaveAllBeforeFinish(boolean theDoSave) {
        this.saveAllBeforeFinish = theDoSave;
    }

    @Override
    public List getAllNewResources() {
        ModelWorkspaceItem wsItem;
        IResource resource;
        ArrayList<IResource> resources = new ArrayList<IResource>(10);
        if (!this.xsdWorkspaceResources.isEmpty()) {
            for (IWebServiceXsdResource xsdRes : this.xsdWorkspaceResources) {
                IPath xsdPath = xsdRes.getDestinationPath();
                IResource resource2 = null;
                ModelWorkspaceItem wsItem2 = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(xsdPath, 1);
                if (wsItem2 != null) {
                    resource2 = wsItem2.getResource();
                }
                if (resource2 == null) continue;
                resources.add(resource2);
            }
        }
        if (this.xmlModel != null) {
            resource = null;
            wsItem = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(this.xmlModel, 1);
            if (wsItem != null) {
                resource = wsItem.getResource();
            }
            if (resource != null) {
                resources.add(resource);
            }
        }
        if (this.modelPath != null) {
            resource = null;
            wsItem = ModelWorkspaceManager.getModelWorkspaceManager().findModelWorkspaceItem(this.modelPath, 1);
            if (wsItem != null) {
                resource = wsItem.getResource();
            }
            if (resource != null) {
                resources.add(resource);
            }
        }
        return resources;
    }

    @Override
    public void setSelectedOperations(Collection operations) {
        this.selectedWsdlOperations = operations;
    }

    @Override
    public Collection getSelectedOperations() {
        return this.selectedWsdlOperations;
    }

    public class XSDWebServiceResourceTuple {
        private IWebServiceResource resource;
        private XSDSchema schema;

        public XSDWebServiceResourceTuple(IWebServiceResource resource, XSDSchema schema) {
            this.schema = schema;
            this.resource = resource;
        }

        public IWebServiceResource getResource() {
            return this.resource;
        }

        public void setResource(IWebServiceResource resource) {
            this.resource = resource;
        }

        public XSDSchema getSchema() {
            return this.schema;
        }

        public void setSchema(XSDSchema schema) {
            this.schema = schema;
        }
    }
}

