/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice;

import java.io.File;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.compare.ModelGenerator;
import org.teiid.designer.compare.selector.ModelResourceSelector;
import org.teiid.designer.compare.selector.ModelSelector;
import org.teiid.designer.compare.selector.TransientModelSelector;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspace;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.webservice.BasicWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceGenerator;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceXmlDocumentGenerator;
import org.teiid.designer.webservice.IWsdlGenerator;
import org.teiid.designer.webservice.WebServiceModelGenerator;
import org.teiid.designer.webservice.gen.BasicWebServiceGenerator;
import org.teiid.designer.webservice.gen.BasicWebServiceXmlDocumentGenerator;
import org.teiid.designer.webservice.gen.BasicWsdlGenerator;

public class WebServicePlugin
extends Plugin {
    private static WebServicePlugin plugin = null;
    public static final String PLUGIN_ID = "org.teiid.designer.webservice";
    public static final String PACKAGE_ID = WebServicePlugin.class.getPackage().getName();
    private static final String I18N_NAME = String.valueOf(PACKAGE_ID) + ".i18n";
    public static final PluginUtil Util = new PluginUtilImpl("org.teiid.designer.webservice", I18N_NAME, ResourceBundle.getBundle(I18N_NAME));
    public static boolean DEBUG = false;
    public static String[] WSDL_FILE_EXTENSIONS = new String[]{"wsdl"};
    public static final String WAR_DEFAULT = Util.getString("WebServicePlugin.defaultWARFileLocation", new Object[0]);

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
    }

    public static IWebServiceModelBuilder createModelBuilder(IResource theParentResource, IPath theModelPath, MetamodelDescriptor theDescriptor) {
        BasicWebServiceModelBuilder builder = new BasicWebServiceModelBuilder();
        builder.setModelPath(theModelPath);
        builder.setMetamodelDescriptor(theDescriptor);
        builder.setParentResource(theParentResource);
        return builder;
    }

    public static IWsdlGenerator createWsdlGenerator() {
        return new BasicWsdlGenerator();
    }

    public static IWebServiceGenerator createWebServiceGenerator() {
        return new BasicWebServiceGenerator();
    }

    public static IWebServiceXmlDocumentGenerator createXmlDocumentGenerator() {
        return new BasicWebServiceXmlDocumentGenerator();
    }

    public static boolean isWsdlFileExtension(String theExtension) {
        boolean result = false;
        if (theExtension != null && theExtension.length() > 0) {
            int i = 0;
            while (i < WSDL_FILE_EXTENSIONS.length) {
                if (theExtension.equalsIgnoreCase(WSDL_FILE_EXTENSIONS[i])) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean isWsdlFile(IFile theFile) {
        return WebServicePlugin.isWsdlFileExtension(theFile.getFileExtension());
    }

    public static boolean isWsdlFile(File theFile) {
        boolean result = false;
        String name = theFile.getName();
        int index = name.lastIndexOf(FileUtils.Constants.FILE_EXTENSION_SEPARATOR);
        if (index != -1 && index + 2 < name.length()) {
            result = WebServicePlugin.isWsdlFileExtension(name.substring(index + 1));
        }
        return result;
    }

    public static ModelGenerator createModelGenerator(IWebServiceModelBuilder builder) {
        IPath wsModelPath;
        ModelWorkspace modelWorkspace = ModelerCore.getModelWorkspace();
        ModelResource wsModelResource = modelWorkspace.findModelResource(wsModelPath = builder.getModelPath());
        if (wsModelResource == null) {
            IWorkspaceRoot workspaceRoot = ModelerCore.getWorkspace().getRoot();
            IFile file = workspaceRoot.getFile(wsModelPath);
            wsModelResource = ModelerCore.create((IFile)file);
            try {
                wsModelResource.getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
                wsModelResource.getModelAnnotation().setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/WebService");
                wsModelResource.save((IProgressMonitor)new NullProgressMonitor(), true);
            }
            catch (ModelWorkspaceException theException) {
                Util.log((Throwable)theException);
            }
        }
        ModelResourceSelector wsSelector = new ModelResourceSelector(wsModelResource);
        IPath xmlModelPath = builder.getXmlModel();
        TransientModelSelector xmlSelector = null;
        if (xmlModelPath != null) {
            ModelResource xmlModelResource = modelWorkspace.findModelResource(xmlModelPath);
            if (xmlModelResource == null) {
                IWorkspaceRoot workspaceRoot = ModelerCore.getWorkspace().getRoot();
                IFile file = workspaceRoot.getFile(xmlModelPath);
                xmlModelResource = ModelerCore.create((IFile)file);
                try {
                    xmlModelResource.getModelAnnotation().setModelType(ModelType.VIRTUAL_LITERAL);
                    xmlModelResource.getModelAnnotation().setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/XmlDocument");
                    xmlModelResource.save((IProgressMonitor)new NullProgressMonitor(), true);
                }
                catch (ModelWorkspaceException theException) {
                    Util.log((Throwable)theException);
                }
            }
            xmlSelector = new ModelResourceSelector(xmlModelResource);
        } else {
            xmlSelector = new TransientModelSelector("WebServiceModelGenerator_XmlDocumentModelOutput.xmi");
        }
        return new WebServiceModelGenerator(builder, (ModelSelector)wsSelector, (ModelSelector)xmlSelector);
    }

    public static WebServicePlugin getInstance() {
        return plugin;
    }

    public static String getDefaultWarFileSaveLocation() {
        File parentFolder;
        String defaultWarFileSaveLocation = ModelerCore.getWorkspace().getRoot().getLocation().toString();
        File workspaceFile = new File(defaultWarFileSaveLocation);
        if (workspaceFile.exists() && (parentFolder = workspaceFile.getParentFile()) != null) {
            File saveFolder = new File(parentFolder, WAR_DEFAULT);
            defaultWarFileSaveLocation = saveFolder.toString();
        }
        return defaultWarFileSaveLocation;
    }
}

