/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.util.StringConstants;
import org.teiid.designer.metamodels.wsdl.Definitions;
import org.teiid.designer.metamodels.wsdl.io.DelegatingResourceSet;
import org.teiid.designer.metamodels.wsdl.io.WsdlResourceFactoryImpl;
import org.teiid.designer.metamodels.wsdl.io.WsdlResourceImpl;

public class WebServiceResources
implements StringConstants {
    private final ResourceSet resourceSet = new DelegatingResourceSet();

    public WebServiceResources() {
        ResourceSet xsdGlobalResourceSet = XSDSchemaImpl.getGlobalResourceSet();
        ((DelegatingResourceSet)this.resourceSet).addDelegateResourceSet(xsdGlobalResourceSet);
        Resource.Factory.Registry registry = this.resourceSet.getResourceFactoryRegistry();
        Map map = registry.getExtensionToFactoryMap();
        if (!map.containsKey("wsdl")) {
            map.put("wsdl", new WsdlResourceFactoryImpl());
        }
        if (!map.containsKey("xsd")) {
            map.put("xsd", new XSDResourceFactoryImpl());
        }
        registry.getProtocolToFactoryMap().put("http://schemas.xmlsoap.org/wsdl/", new WsdlResourceFactoryImpl());
    }

    public Resource add(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, true);
        return resource;
    }

    public Resource get(URI uri) {
        Resource resource = this.resourceSet.getResource(uri, true);
        return resource;
    }

    public void refresh(Resource resource) throws IOException {
        resource.unload();
        Map options = resource.getResourceSet() != null ? resource.getResourceSet().getLoadOptions() : Collections.EMPTY_MAP;
        resource.load(options);
    }

    public void remove(URI uri) {
        Resource existing = this.resourceSet.getResource(uri, false);
        if (existing != null) {
            this.resourceSet.getResources().remove((Object)existing);
        }
    }

    public void remove(Resource resource) {
        this.resourceSet.getResources().remove((Object)resource);
    }

    public boolean isWsdl(Resource resource) {
        return resource instanceof WsdlResourceImpl;
    }

    public boolean isXsd(Resource resource) {
        return resource instanceof XSDResourceImpl;
    }

    public String getTargetNamespace(Resource resource) {
        if (this.isWsdl(resource)) {
            return this.doGetTargetNamespace((WsdlResourceImpl)resource);
        }
        if (this.isXsd(resource)) {
            return this.doGetTargetNamespace((XSDResourceImpl)resource);
        }
        return null;
    }

    protected String doGetTargetNamespace(WsdlResourceImpl resource) {
        EList roots = resource.getContents();
        for (Object object : roots) {
            if (!(object instanceof Definitions)) continue;
            Definitions defns = (Definitions)object;
            return defns.getTargetNamespace();
        }
        return null;
    }

    protected String doGetTargetNamespace(XSDResourceImpl resource) {
        XSDSchema schema = resource.getSchema();
        return schema.getTargetNamespace();
    }

    public class Reference {
        public final String namespace;
        public final String location;
        public final Resource resource;

        public Reference(String namespace, String location, Resource resource) {
            this.namespace = namespace;
            this.location = location;
            this.resource = resource;
        }
    }
}

