/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.impl.XSDDiagnosticImpl;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.webservice.IInternalWebServiceXsdResource;
import org.teiid.designer.webservice.WebServicePlugin;

public class WebServiceXsdResource
implements IInternalWebServiceXsdResource {
    private final String targetNamespace;
    private final String originalPath;
    private IPath destinationPath;
    private final Validator validator;
    private final XSDSchema schema;

    public WebServiceXsdResource(XSDSchema schema, String targetNamespace, String originalPath) {
        this(schema, targetNamespace, originalPath, null);
    }

    public WebServiceXsdResource(XSDSchema schema, String targetNamespace, String originalPath, Validator validator) {
        CoreArgCheck.isNotNull((Object)schema);
        this.schema = schema;
        this.targetNamespace = targetNamespace;
        this.originalPath = originalPath;
        this.validator = validator != null ? validator : new WorkspaceValidator();
    }

    @Override
    public XSDSchema getSchema() {
        return this.schema;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Override
    public String getOriginalPath() {
        return this.originalPath;
    }

    @Override
    public IPath getDestinationPath() {
        return this.destinationPath;
    }

    @Override
    public void setDestinationPath(IPath workspacePathForXsd) {
        this.destinationPath = workspacePathForXsd;
    }

    @Override
    public IStatus isValid() {
        IStatus stResult = null;
        Status stSchemaStatus = null;
        IStatus stValidDestination = this.validator.isValid(this.getDestinationPath());
        EList lstDiags = this.getSchema().getDiagnostics();
        if (lstDiags != null && lstDiags.size() > 0) {
            for (XSDDiagnosticImpl diag : lstDiags) {
                if (diag.getSeverity().getValue() != 1 && diag.getSeverity().getValue() != 0) continue;
                String sMessage = diag.getMessage();
                stSchemaStatus = new Status(4, "org.teiid.designer.webservice", 18108, sMessage, null);
            }
        }
        if (stValidDestination != null && stSchemaStatus != null) {
            IStatus[] errors = new IStatus[]{stValidDestination, stSchemaStatus};
            stResult = new MultiStatus("org.teiid.designer.webservice", 18108, errors, stSchemaStatus.getMessage(), null);
        } else if (stValidDestination != null) {
            stResult = stValidDestination;
        } else if (stSchemaStatus != null) {
            stResult = stSchemaStatus;
        }
        return stResult;
    }

    @Override
    public IStatus isValid(IPath proposedDestination) {
        return this.validator.isValid(proposedDestination);
    }

    public static IStatus isValidInWorkspace(IPath destPath) {
        if (destPath == null) {
            String msg = WebServicePlugin.Util.getString("WebServiceXsdResource.LocationInWorkspaceRequired", new Object[0]);
            return new Status(4, "org.teiid.designer.webservice", 0, msg, null);
        }
        if (destPath.segmentCount() == 0) {
            Object[] params = new Object[]{destPath.toString()};
            String msg = WebServicePlugin.Util.getString("WebServiceXsdResource.PathNotValid", params);
            return new Status(4, "org.teiid.designer.webservice", 0, msg, null);
        }
        if (destPath.segmentCount() == 1) {
            Object[] params = new Object[]{destPath.toString()};
            String msg = WebServicePlugin.Util.getString("WebServiceXsdResource.PathSpecifiesProject", params);
            return new Status(4, "org.teiid.designer.webservice", 0, msg, null);
        }
        IResource existing = ModelerCore.getWorkspace().getRoot().findMember(destPath, false);
        if (existing != null && existing.exists()) {
            if (existing instanceof IFolder) {
                Object[] params = new Object[]{destPath.toString()};
                String msg = WebServicePlugin.Util.getString("WebServiceXsdResource.PathSpecifiesFolder", params);
                return new Status(4, "org.teiid.designer.webservice", 0, msg, null);
            }
            if (existing instanceof IFile) {
                if ("xsd".equalsIgnoreCase(existing.getFullPath().getFileExtension())) {
                    Object[] params = new Object[]{destPath.toString()};
                    String msg = WebServicePlugin.Util.getString("WebServiceXsdResource.PathSpecifiesExistingXsdWillBeOverwritten", params);
                    return new Status(2, "org.teiid.designer.webservice", 0, msg, null);
                }
                Object[] params = new Object[]{destPath.toString()};
                String msg = WebServicePlugin.Util.getString("WebServiceXsdResource.PathSpecifiesExistingNonXsd", params);
                return new Status(4, "org.teiid.designer.webservice", 0, msg, null);
            }
        }
        if (!"xsd".equalsIgnoreCase(destPath.getFileExtension())) {
            Object[] params = new Object[]{destPath.toString()};
            String msg = WebServicePlugin.Util.getString("WebServiceXsdResource.PathMustHaveAnXsdExtension", params);
            return new Status(4, "org.teiid.designer.webservice", 0, msg, null);
        }
        Object[] params = new Object[]{destPath.toString()};
        String msg = WebServicePlugin.Util.getString("WebServiceXsdResource.XsdWillBePlacedAt", params);
        return new Status(0, "org.teiid.designer.webservice", 0, msg, null);
    }

    public static interface Validator {
        public IStatus isValid(IPath var1);
    }

    public class WorkspaceValidator
    implements Validator {
        @Override
        public IStatus isValid(IPath destPath) {
            return WebServiceXsdResource.isValidInWorkspace(destPath);
        }
    }
}

