/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.teiid.designer.compare.ModelProducer;
import org.teiid.designer.compare.selector.ModelSelector;
import org.teiid.designer.compare.selector.TransientModelSelector;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.WebServiceComponent;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceXmlDocumentGenerator;
import org.teiid.designer.webservice.WebServiceModelProducer;
import org.teiid.designer.webservice.WebServicePlugin;

public class XmlDocumentModelProducer
implements ModelProducer {
    public static final int WARNING_NO_WEBSERVICE_OBJECTS = 32301;
    private final IWebServiceModelBuilder builder;
    private final WebServiceModelProducer wsProducer;
    private final TransientModelSelector output;
    private final boolean shouldBuild;

    public XmlDocumentModelProducer(IWebServiceModelBuilder builder, WebServiceModelProducer wsProducer) {
        this.builder = builder;
        this.wsProducer = wsProducer;
        if (this.builder.getXmlModel() != null) {
            this.shouldBuild = true;
            this.output = new TransientModelSelector(builder.getXmlModel().toString());
        } else {
            this.shouldBuild = false;
            this.output = new TransientModelSelector("WebServiceModelBuilder-XmlDocumentModel-Temporary");
        }
    }

    public void execute(IProgressMonitor monitor, List problems) throws Exception {
        if (!this.shouldBuild) {
            return;
        }
        ModelAnnotation modelAnnotation = this.output.getModelAnnotation();
        modelAnnotation.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/XmlDocument");
        modelAnnotation.setModelType(ModelType.VIRTUAL_LITERAL);
        IWebServiceXmlDocumentGenerator generator = WebServicePlugin.createXmlDocumentGenerator();
        generator.setXmlDocumentResource(this.output.getResource());
        ModelSelector wsModelSelector = this.wsProducer.getOutputSelector();
        generator.setWebServiceModelSelector(wsModelSelector);
        for (EObject root : wsModelSelector.getRootObjects()) {
            if (!(root instanceof Interface)) continue;
            generator.addWebServiceComponent((WebServiceComponent)((Interface)root));
        }
        if (generator.getWebServiceComponents().isEmpty()) {
            String msg = WebServicePlugin.Util.getString("XmlDocumentModelProducer.NoWebServiceComponentsFound", new Object[0]);
            problems.add(new Status(2, "org.teiid.designer.webservice", 32301, msg, null));
        } else {
            generator.generate(monitor, problems);
        }
    }

    public ModelSelector getOutputSelector() {
        return this.output;
    }
}

