/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.procedure;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDFeature;
import org.eclipse.xsd.XSDModelGroup;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.webservice.procedure.XsdInstanceNode;

public class DocumentGenerator
implements CoreStringUtil.Constants {
    public static final DocumentGenerator SHARED = new DocumentGenerator();
    private static final int INDENT = 4;
    private static final String XML_DECL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    private void add(StringBuffer document, XsdInstanceNode node, int depth, int declarationIndex, Map namespacesToPrefixes, List<String> paramValues) {
        String pfx;
        this.indentChild(document, depth);
        int attrIndent = document.length();
        document.append('<');
        XSDConcreteComponent comp = node.getResolvedXsdComponent();
        boolean choice = comp instanceof XSDModelGroup;
        this.addCommentStartIfChoice(document, choice);
        if (declarationIndex == 0) {
            this.addName(document, node, "");
            declarationIndex = document.length();
            pfx = this.updateNamespaceDeclarations(document, node, declarationIndex, namespacesToPrefixes);
        } else {
            pfx = this.updateNamespaceDeclarations(document, node, declarationIndex, namespacesToPrefixes);
            this.addName(document, node, pfx);
        }
        attrIndent = document.length() - attrIndent;
        boolean attrAdded = false;
        boolean childAdded = false;
        XsdInstanceNode[] nodes = node.getChildren();
        int nodeNdx = 0;
        while (nodeNdx < nodes.length) {
            XsdInstanceNode child = nodes[nodeNdx];
            XSDConcreteComponent childComp = child.getResolvedXsdComponent();
            if (childComp instanceof XSDAttributeDeclaration) {
                if (attrAdded) {
                    document.append('\n');
                    this.indent(document, attrIndent);
                } else {
                    attrAdded = true;
                }
                document.append(' ');
                String attrPfx = this.updateNamespaceDeclarations(document, child, declarationIndex, namespacesToPrefixes);
                this.addName(document, child, attrPfx);
                document.append("=\"");
                this.addFixedValue(document, childComp);
                document.append('\"');
            } else {
                if (!childAdded) {
                    childAdded = true;
                    this.addCommentEndIfChoice(document, choice);
                    document.append(">\n");
                }
                this.add(document, child, depth + 1, declarationIndex, namespacesToPrefixes, paramValues);
            }
            ++nodeNdx;
        }
        if (childAdded) {
            XSDFeature feature;
            if (comp instanceof XSDFeature && (feature = (XSDFeature)comp).getConstraint() == XSDConstraint.FIXED_LITERAL) {
                this.indentChild(document, depth + 1);
                document.append(feature.getLexicalValue());
                document.append('\n');
            }
            this.indentChild(document, depth);
        } else {
            document.append(">");
            if (!this.addFixedValue(document, comp) && paramValues != null && !paramValues.isEmpty()) {
                document.append(paramValues.remove(0));
            }
        }
        document.append('<');
        this.addCommentStartIfChoice(document, choice);
        document.append('/');
        this.addName(document, node, pfx);
        this.addCommentEndIfChoice(document, choice);
        document.append(">\n");
    }

    private boolean addFixedValue(StringBuffer document, XSDConcreteComponent component) {
        XSDFeature feature;
        if (component instanceof XSDFeature && (feature = (XSDFeature)component).getConstraint() == XSDConstraint.FIXED_LITERAL) {
            document.append(feature.getLexicalValue());
            return true;
        }
        return false;
    }

    private void addCommentEndIfChoice(StringBuffer document, boolean choice) {
        if (choice) {
            document.append(" --");
        }
    }

    private void addCommentStartIfChoice(StringBuffer document, boolean choice) {
        if (choice) {
            document.append("!-- ");
        }
    }

    private void addName(StringBuffer document, XsdInstanceNode node, String prefix) {
        if (prefix.length() > 0 && node.isNamespaceQualifiedInDocument()) {
            document.append(prefix);
            document.append(':');
        }
        document.append(node.getName());
    }

    public String generate(XsdInstanceNode node, List<String> paramValues) {
        StringBuffer doc = new StringBuffer(XML_DECL);
        this.add(doc, node, 0, 0, new HashMap(), paramValues);
        return doc.toString();
    }

    public String generate(XsdInstanceNode node) {
        List<String> emptyList = Collections.emptyList();
        return this.generate(node, emptyList);
    }

    private void indentChild(StringBuffer document, int depth) {
        this.indent(document, depth * 4);
    }

    private void indent(StringBuffer buffer, int indent) {
        int ndx = indent;
        while (--ndx >= 0) {
            buffer.append(' ');
        }
    }

    private String updateNamespaceDeclarations(StringBuffer document, XsdInstanceNode node, int declarationIndex, Map namespacesToPrefixes) {
        String ns = node.getTargetNamespace();
        String pfx = (String)namespacesToPrefixes.get(ns);
        if (pfx == null) {
            StringBuffer decl = new StringBuffer();
            decl.append(" xmlns");
            int count = namespacesToPrefixes.size();
            if (count == 0) {
                pfx = "";
            } else {
                pfx = "ns" + count;
                decl.append(':');
                decl.append(pfx);
            }
            decl.append("=\"");
            decl.append(ns);
            decl.append('\"');
            if (document.length() > declarationIndex && document.charAt(declarationIndex) == ' ') {
                decl.append('\n');
                this.indent(decl, declarationIndex - XML_DECL.length());
            }
            document.insert(declarationIndex, decl);
            namespacesToPrefixes.put(ns, pfx);
        }
        return pfx;
    }
}

