/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.xsd.XSDNamedComponent;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.metamodels.xml.XmlValueHolder;

public class InputVariable {
    private String name;
    private String xpath;
    private final XSDNamedComponent schemaComponent;
    private final List xmlDocEntityForCriteria;

    public InputVariable(XSDNamedComponent schemaComponent) {
        this(schemaComponent, null, null);
    }

    public InputVariable(XSDNamedComponent schemaComponent, String name) {
        this(schemaComponent, name, null);
    }

    public InputVariable(XSDNamedComponent schemaComponent, String name, String xpath) {
        CoreArgCheck.isNotNull((Object)schemaComponent);
        this.schemaComponent = schemaComponent;
        this.name = name;
        this.xpath = xpath;
        this.xmlDocEntityForCriteria = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public boolean isNameValid() {
        return this.name != null && this.name.trim().length() != 0;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getXpath() {
        return this.xpath;
    }

    public void setXpath(String xpath) {
        this.xpath = xpath;
    }

    public XSDNamedComponent getSchemaComponent() {
        return this.schemaComponent;
    }

    public List getXmlDocumentEntityForCriteria() {
        return this.xmlDocEntityForCriteria;
    }

    public void addXmlDocumentEntityForCriteria(XmlValueHolder elementOrAttribute) {
        if (!this.xmlDocEntityForCriteria.contains(elementOrAttribute)) {
            this.xmlDocEntityForCriteria.add(elementOrAttribute);
        }
    }

    public String toString() {
        return String.valueOf(this.name) + ":" + this.xpath + " = " + this.schemaComponent.getQName();
    }
}

