/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.test.util;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.test.util.xpl.DisplayDelayHelper;

public class JobUtils {
    private static final long MAX_IDLE = 1200000L;
    private static final long DEFAULT_DELAY = 500L;
    private static final String[] IGNORE_JOBS_NAMES = new String[]{"workbench auto-save job"};

    public static void waitForIdle() {
        JobUtils.waitForIdle(500L);
    }

    public static void waitForIdle(long delay) {
        JobUtils.waitForIdle(delay, 1200000L);
    }

    public static void waitForIdle(long delay, long maxIdle) {
        long start = System.currentTimeMillis();
        while (!JobUtils.isIdle()) {
            JobUtils.delay(delay);
            if (System.currentTimeMillis() - start <= maxIdle) continue;
            Job[] jobs = Job.getJobManager().find(null);
            StringBuffer str = new StringBuffer();
            Job[] jobArray = jobs;
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job.getThread() != null && !JobUtils.shouldIgnoreJob(job)) {
                    str.append("\n").append(job.getName()).append(" (").append(job.getClass()).append(")");
                }
                ++n2;
            }
            if (str.length() <= 0) continue;
            throw new RuntimeException("Long running tasks detected:" + str.toString());
        }
    }

    private static boolean isIdle() {
        boolean isIdle = Job.getJobManager().isIdle();
        if (!isIdle) {
            Job[] jobs;
            Job[] jobArray = jobs = Job.getJobManager().find(null);
            int n = jobs.length;
            int n2 = 0;
            while (n2 < n) {
                Job job = jobArray[n2];
                if (job.getThread() != null && !JobUtils.shouldIgnoreJob(job)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private static boolean shouldIgnoreJob(Job job) {
        String[] stringArray = IGNORE_JOBS_NAMES;
        int n = IGNORE_JOBS_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (name != null && job != null && job.getName() != null && name.equalsIgnoreCase(job.getName().trim())) {
                System.out.println("Ignoring the non-build long running job: " + job.getName());
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void delay(long waitTimeMillis) {
        Display display = Display.getCurrent();
        if (PlatformUI.isWorkbenchRunning() && display != null) {
            DisplayDelayHelper delay = new DisplayDelayHelper(waitTimeMillis);
            delay.waitForCondition(display, waitTimeMillis);
        } else {
            try {
                Thread.sleep(waitTimeMillis);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static void runDeferredEvents() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }
}

