/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.test.util;

import junit.extensions.TestSetup;
import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.jboss.tools.test.util.JUnitUtils;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.test.util.ResourcesUtils;

public class ProjectImportTestSetup
extends TestSetup {
    private String bundleName;
    protected String[] projectPaths;
    protected String[] projectNames;
    protected IProject[] projects;

    public ProjectImportTestSetup(Test test, String bundleName, String projectPath, String projectName) {
        super(test);
        this.bundleName = bundleName;
        this.projectPaths = new String[]{projectPath};
        this.projectNames = new String[]{projectName};
    }

    public ProjectImportTestSetup(Test test, String bundleName, String[] projectPaths, String[] projectNames) {
        super(test);
        this.bundleName = bundleName;
        this.projectPaths = projectPaths;
        this.projectNames = projectNames;
    }

    public IProject importProject() throws Exception {
        return this.importProjects()[0];
    }

    public IProject[] importProjects() throws Exception {
        this.projects = new IProject[this.projectPaths.length];
        JobUtils.waitForIdle();
        int i = 0;
        while (i < this.projectPaths.length) {
            this.projects[i] = ResourcesUtils.importProject(this.bundleName, this.projectPaths[i]);
            this.projects[i].build(10, null);
            ++i;
        }
        return this.projects;
    }

    public static IProject loadProject(String projectName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        ProjectImportTestSetup.assertNotNull((String)("Can't load " + projectName), (Object)project);
        try {
            project.build(6, null);
        }
        catch (CoreException e) {
            JUnitUtils.fail(e.getMessage(), (Exception)((Object)e));
        }
        JobUtils.waitForIdle();
        return project;
    }

    protected void setUp() throws Exception {
        this.importProjects();
    }

    protected void tearDown() throws Exception {
        boolean saveAutoBuild = ResourcesUtils.setBuildAutomatically(false);
        int i = 0;
        while (i < this.projectNames.length) {
            ResourcesUtils.deleteProject(this.projectNames[i]);
            JobUtils.waitForIdle();
            ++i;
        }
        ResourcesUtils.setBuildAutomatically(saveAutoBuild);
    }

    public void deleteProjects() throws Exception {
        this.tearDown();
    }
}

