/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.test.util;

import java.awt.AWTException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.Registry;
import org.monte.media.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.monte.screenrecorder.ScreenRecorder;

public class ScreenRecorderExt
extends ScreenRecorder {
    private String useFileName = null;
    public static final String STATE_DONE = "DONE";
    public static final String STATE_RECORDING = "RECORDING";
    public static final String STATE_FAILED = "FAILED";

    public ScreenRecorderExt() throws IOException, AWTException {
        this(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration(), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "rle ", VideoFormatKeys.CompressorNameKey, "rle ", VideoFormatKeys.DepthKey, 24, FormatKeys.FrameRateKey, Rational.valueOf((double)15.0), VideoFormatKeys.QualityKey, Float.valueOf(1.0f), FormatKeys.KeyFrameIntervalKey, 900}), new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.EncodingKey, "black", FormatKeys.FrameRateKey, Rational.valueOf((double)30.0)}), null);
    }

    public ScreenRecorderExt(GraphicsConfiguration cfg, Format fileFormat, Format screenFormat, Format mouseFormat, Format audioFormat) throws IOException, AWTException {
        super(cfg, fileFormat, screenFormat, mouseFormat, audioFormat);
    }

    public void start(String fileName) throws IOException {
        this.useFileName = fileName;
        super.start();
    }

    public void start() throws IOException {
        this.useFileName = null;
        super.start();
    }

    protected File createMovieFile(Format fileFormat) throws IOException {
        File fileToWriteMovie;
        if (this.useFileName == null || this.useFileName.length() == 0) {
            fileToWriteMovie = super.createMovieFile(fileFormat);
        } else {
            if (this.useFileName.indexOf(46) < 0) {
                this.useFileName = String.valueOf(this.useFileName) + '.' + Registry.getInstance().getExtension(fileFormat);
            }
            if ((fileToWriteMovie = new File(this.useFileName)).exists()) {
                fileToWriteMovie.delete();
            }
        }
        return fileToWriteMovie;
    }

    public boolean isState(String state) {
        boolean result = false;
        if (state.equals(STATE_DONE) && this.getState().equals((Object)ScreenRecorder.State.DONE)) {
            result = true;
        } else if (state.equals(STATE_RECORDING) && this.getState().equals((Object)ScreenRecorder.State.RECORDING)) {
            result = true;
        } else if (state.equals(STATE_RECORDING) && this.getState().equals((Object)ScreenRecorder.State.RECORDING)) {
            result = true;
        } else if (state.equals(STATE_FAILED) && this.getState().equals((Object)ScreenRecorder.State.FAILED)) {
            result = true;
        }
        return result;
    }

    public void stop() throws IOException {
        super.stop();
    }
}

