/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.test.util;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.jboss.tools.test.util.JUnitUtils;

public class WorkbenchUtils {
    public static IWizard findWizardByDefId(String definitionId) {
        IWizardDescriptor aWizardDescr = WorkbenchUtils.getWorkbench().getNewWizardRegistry().findWizard(definitionId);
        TestCase.assertNotNull((String)("Cannot find wizard " + definitionId + " definition in wizard registry"), (Object)aWizardDescr);
        IWorkbenchWizard aWizard = null;
        try {
            aWizard = aWizardDescr.createWizard();
        }
        catch (CoreException e) {
            JUnitUtils.fail("Cannot create IWorkbenchWizard instance", (Exception)((Object)e));
        }
        return aWizard;
    }

    public static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    public static IWorkbenchPage getWorkbenchActivePage() {
        return WorkbenchUtils.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static Shell getActiveShell() {
        return WorkbenchUtils.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public static PreferenceManager getPreferenceManager() {
        return WorkbenchUtils.getWorkbench().getPreferenceManager();
    }

    public static PreferenceDialog createPreferenceDialog(String pageId) {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)WorkbenchUtils.getActiveShell(), (String)pageId, (String[])new String[]{pageId}, null);
        dialog.setBlockOnOpen(false);
        return dialog;
    }

    public static PreferenceDialog createPropertyDialog(String pageId, IProject project) {
        return PreferencesUtil.createPropertyDialogOn((Shell)WorkbenchUtils.getActiveShell(), (IAdaptable)project, (String)pageId, (String[])new String[]{pageId}, null);
    }

    public static IEditorPart openEditor(String inputFile) {
        return WorkbenchUtils.openEditor((IPath)new Path(inputFile));
    }

    public static IEditorPart openEditor(IPath inputFile) {
        IEditorPart part = null;
        try {
            part = IDE.openEditor((IWorkbenchPage)WorkbenchUtils.getWorkbenchActivePage(), (IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(inputFile));
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return part;
    }

    public static IEditorPart openEditor(String inputFile, String editorId) {
        IEditorPart part = null;
        try {
            part = IDE.openEditor((IWorkbenchPage)WorkbenchUtils.getWorkbenchActivePage(), (IFile)ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(inputFile)), (String)editorId);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return part;
    }

    public static IEditorPart openEditor(IFile inputFile, String editorId) {
        IEditorPart part = null;
        try {
            part = IDE.openEditor((IWorkbenchPage)WorkbenchUtils.getWorkbenchActivePage(), (IFile)inputFile, (String)editorId);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return part;
    }

    public static void closeAllEditors() {
        WorkbenchUtils.getWorkbenchActivePage().closeAllEditors(false);
    }
}

