/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tests;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.tests.AbstractRuntimeTest;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AbstractPluginsLoadTest
extends AbstractRuntimeTest {
    private static final String PLUGIN_TAG_NAME = "plugin";
    private static final String ID_ATTRIBUTE_NAME = "id";

    public void testBundlesAreLoadedFor(final String featureId) {
        Bundle firstBundle = this.getFirstBundleFor(featureId);
        File bundleLocation = null;
        try {
            bundleLocation = FileLocator.getBundleFile((Bundle)firstBundle);
        }
        catch (IOException iOException) {
            AbstractPluginsLoadTest.fail((String)MessageFormat.format("Cannot find location for feature {0}", featureId));
        }
        File featuresFolder = new File(bundleLocation.getParentFile().getParentFile(), "features");
        String[] features = featuresFolder.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                File featureDescriptor = new File(new File(dir, name), "feature.xml");
                return name.startsWith(featureId) && featureDescriptor.canRead();
            }
        });
        AbstractPluginsLoadTest.assertEquals((int)1, (int)features.length);
        File featureDescriptor = new File(new File(featuresFolder, features[0]), "feature.xml");
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document feature = builder.parse(featureDescriptor);
            NodeList plugins = feature.getElementsByTagName(PLUGIN_TAG_NAME);
            int i = 0;
            while (i < plugins.getLength()) {
                String pluginId = plugins.item(i).getAttributes().getNamedItem(ID_ATTRIBUTE_NAME).getNodeValue();
                this.isPluginResolved(pluginId);
                System.out.println(MessageFormat.format("Plugn {0} was resolved and activated", pluginId));
                ++i;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            AbstractPluginsLoadTest.fail((String)MessageFormat.format("Cannot configure parser to parse feature descriptor ''{0}''", featureDescriptor.getAbsolutePath()));
        }
        catch (SAXException sAXException) {
            AbstractPluginsLoadTest.fail((String)MessageFormat.format("Cannot parse feature descriptor ''{0}''", featureDescriptor.getAbsolutePath()));
        }
        catch (IOException e) {
            AbstractPluginsLoadTest.fail((String)e.getMessage());
        }
    }

    public void assertPluginsResolved(Bundle[] bundles) {
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            AbstractPluginsLoadTest.assertTrue((String)("Plugin '" + bundle.getSymbolicName() + "' is not resolved"), (boolean)this.isPluginResolved(bundle.getSymbolicName()));
            System.out.println(String.valueOf(bundle.getSymbolicName()) + " was resolved and activated");
            ++n2;
        }
    }

    public void assertPluginResolved(Bundle bundle) {
        this.assertPluginsResolved(new Bundle[]{bundle});
    }

    public void assertPluginsResolved(String[] ids) {
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Bundle bundle = Platform.getBundle((String)id);
            AbstractPluginsLoadTest.assertNotNull((String)MessageFormat.format("Could not get bundle {0} instance", id), (Object)bundle);
            AbstractPluginsLoadTest.assertTrue((String)MessageFormat.format("Plugin '{0}' is not resolved", bundle.getSymbolicName()), (boolean)this.isPluginResolved(bundle.getSymbolicName()));
            System.out.println(MessageFormat.format("{0} was resolved and activated", bundle.getSymbolicName()));
            ++n2;
        }
    }

    public void assertPluginResolved(String id) {
        this.assertPluginsResolved(new String[]{id});
    }
}

