/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tests;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.test.util.JUnitUtils;
import org.jboss.tools.test.util.JobUtils;
import org.jboss.tools.tests.IAnnotationTest;
import org.jboss.tools.tests.IMarkerFilter;

public class AbstractResourceMarkerTest
extends TestCase
implements IAnnotationTest {
    public static final String MARKER_TYPE = "org.eclipse.wst.validation.problemmarker";
    protected IProject project = null;

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public AbstractResourceMarkerTest() {
    }

    public AbstractResourceMarkerTest(String name) {
        super(name);
    }

    protected void copyContentsFile(String originalName, String newContentName) throws CoreException {
        IFile originalFile = this.project.getFile(originalName);
        IFile newContentFile = this.project.getFile(newContentName);
        this.copyContentsFile(originalFile, newContentFile);
    }

    protected void copyContentsFile(IFile originalFile, String newContentName) throws CoreException {
        IFile newContentFile = this.project.getFile(newContentName);
        this.copyContentsFile(originalFile, newContentFile);
    }

    protected void copyContentsFile(IFile originalFile, IFile newContentFile) throws CoreException {
        AbstractResourceMarkerTest.assertTrue((boolean)originalFile.exists());
        AbstractResourceMarkerTest.assertTrue((boolean)newContentFile.exists());
        InputStream is = null;
        try {
            is = newContentFile.getContents();
            originalFile.setContents(is, 1, null);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        originalFile.getProject().build(10, null);
        JobUtils.waitForIdle();
    }

    public static int findMarkerLine(IResource resource, String type, String errorMessage, boolean pattern) throws CoreException {
        int number = -1;
        List<Integer> lines = AbstractResourceMarkerTest.findMarkerLines(resource, type, errorMessage, pattern);
        if (!lines.isEmpty()) {
            number = lines.get(0);
        }
        return number;
    }

    public static List<Integer> findMarkerLines(IResource resource, String type, String pattern) throws CoreException {
        return AbstractResourceMarkerTest.findMarkerLines(resource, type, pattern, true);
    }

    public static List<Integer> findMarkerLines(IResource resource, String type, String errorMessage, boolean pattern) throws CoreException {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        IMarker[] markers = AbstractResourceMarkerTest.findMarkers(resource, type, errorMessage, pattern);
        int i = 0;
        while (i < markers.length) {
            numbers.add(markers[i].getAttribute("lineNumber", -1));
            ++i;
        }
        return numbers;
    }

    public static IMarker[] findMarkers(IResource resource, String type, String pattern) throws CoreException {
        return AbstractResourceMarkerTest.findMarkers(resource, type, pattern, true);
    }

    public static IMarker[] findMarkers(IResource resource, String type, String errorMessage, boolean pattern) throws CoreException {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IMarker[] markers = resource.findMarkers(type, true, 2);
        int i = 0;
        while (i < markers.length) {
            String message = markers[i].getAttribute("message", "");
            if (pattern ? message.matches(errorMessage) || message.equals(errorMessage) : message.equals(errorMessage) && markers[i].exists()) {
                result.add(markers[i]);
            }
            ++i;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    public static void assertMarkerIsCreated(IResource resource, MarkerData markerData) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsCreated(resource, markerData.type, markerData.pattern, true, markerData.line);
    }

    public static void assertMarkerIsCreated(IResource resource, String type, String pattern, int ... expectedLines) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsCreated(resource, type, pattern, true, expectedLines);
    }

    public static void assertMarkerIsCreated(IResource resource, String type, String errorMessage, boolean pattern, int ... expectedLines) throws CoreException {
        int n;
        int n2;
        Object[] objectArray;
        List<Integer> lines = AbstractResourceMarkerTest.findMarkerLines(resource, type, errorMessage, pattern);
        StringBuffer expectedString = new StringBuffer();
        StringBuffer realString = new StringBuffer();
        int j = 1;
        for (int line : lines) {
            realString.append(line);
            if (lines.size() <= j++) continue;
            realString.append(", ");
        }
        j = 1;
        int[] nArray = expectedLines;
        int n3 = expectedLines.length;
        int n4 = 0;
        while (n4 < n3) {
            int expected = nArray[n4];
            expectedString.append(expected);
            if (expectedLines.length > j++) {
                expectedString.append(", ");
            }
            ++n4;
        }
        if (lines.isEmpty()) {
            IMarker[] allMarkers = AbstractResourceMarkerTest.findMarkers(resource, null, ".*", true);
            StringBuffer sb = new StringBuffer("Marker matches the '");
            sb.append(errorMessage).append("' pattern wasn't found. Here is the list of found markers in ").append(resource.getFullPath().toOSString()).append(allMarkers.length == 0 ? " : [" : " : [\r\n");
            int i = 0;
            objectArray = allMarkers;
            n2 = allMarkers.length;
            n = 0;
            while (n < n2) {
                IMarker marker = objectArray[n];
                String message = marker.getAttribute("message", "");
                int line = marker.getAttribute("lineNumber", -1);
                String mType = marker.getType();
                sb.append(i).append(") line=\"").append(line).append("\"; type=\"").append(mType).append("\"; message=\"").append(message).append("\";\r\n");
                ++i;
                ++n;
            }
            sb.append("]");
            AbstractResourceMarkerTest.fail((String)sb.toString());
        }
        AbstractResourceMarkerTest.assertEquals((String)("Wrong number of found marker matches the '" + errorMessage + "' pattern. Expected the pattern at the following lines <" + expectedString + "> but was at <" + realString + ">."), (int)expectedLines.length, (int)lines.size());
        for (int line : lines) {
            boolean found = false;
            objectArray = expectedLines;
            n2 = expectedLines.length;
            n = 0;
            while (n < n2) {
                IMarker expected = objectArray[n];
                if (line == expected) {
                    found = true;
                    break;
                }
                ++n;
            }
            AbstractResourceMarkerTest.assertTrue((String)("Marker matches the '" + errorMessage + "' pattern was found at wrong lines. Expected: " + expectedString + " but were: " + realString), (boolean)found);
        }
    }

    public static void assertMarkerIsCreatedForGivenPosition(IResource resource, String type, String pattern, int lineNumber, int startPosition, int endPosition) throws CoreException {
        try {
            int lineDelimiterLength = AbstractResourceMarkerTest.getLineDelimiterLength(resource);
            if (lineDelimiterLength == 2) {
                startPosition += lineNumber - 1;
                endPosition += lineNumber - 1;
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.tests", e.getMessage(), (Throwable)e));
        }
        IMarker[] markers = AbstractResourceMarkerTest.findMarkers(resource, type, pattern, true);
        StringBuffer sb = new StringBuffer("[");
        int i = 0;
        while (i < markers.length) {
            int line = markers[i].getAttribute("lineNumber", -1);
            int start = markers[i].getAttribute("charStart", -1);
            int end = markers[i].getAttribute("charEnd", -1);
            if (lineNumber == line && start == startPosition && end == endPosition) {
                return;
            }
            if (i > 0) {
                sb.append("; ");
            }
            sb.append("line number - ").append(line).append(", start - ").append(start).append(", end - ").append(end);
            ++i;
        }
        sb.append("]");
        AbstractResourceMarkerTest.fail((String)("Marker matches the '" + pattern + "' pattern wasn't found for line - " + lineNumber + ", start - " + startPosition + ", end - " + endPosition + ". Found markers for given patern: " + sb.toString()));
    }

    static int getLineDelimiterLength(IResource resource) throws CoreException, IOException {
        int di;
        IFile f = (IFile)resource;
        InputStream is = f.getContents();
        byte[] b = new byte[512];
        while ((di = is.read(b, 0, b.length)) >= 0) {
            String s = new String(b, 0, di);
            int i = 0;
            while (i < s.length()) {
                if (s.indexOf("\r\n") >= 0) {
                    return 2;
                }
                if (s.indexOf("\r") >= 0 || s.indexOf("\n") >= 0) {
                    return 1;
                }
                ++i;
            }
        }
        return 1;
    }

    public static void assertMarkerIsNotCreated(IResource resource, String type, String pattern) throws CoreException {
        IMarker[] markers = AbstractResourceMarkerTest.findMarkers(resource, type, pattern);
        AbstractResourceMarkerTest.assertFalse((String)("Marker matches the '" + pattern + "' pattern was found"), (markers.length > 0 ? 1 : 0) != 0);
    }

    public static void assertMarkerIsNotCreated(IResource resource, String type, String pattern, int expectedLine) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsNotCreated(resource, type, pattern, true, expectedLine);
    }

    public static void assertMarkerIsNotCreated(IResource resource, String type, String errorMessage, boolean pattern, int expectedLine) throws CoreException {
        List<Integer> lines = AbstractResourceMarkerTest.findMarkerLines(resource, type, errorMessage, pattern);
        AbstractResourceMarkerTest.assertFalse((String)("Marker matches the '" + errorMessage + "' pattern was found"), (boolean)lines.contains(expectedLine));
    }

    public static void assertMarkerIsCreated(IResource resource, String type, String pattern) throws CoreException {
        IMarker[] markers = AbstractResourceMarkerTest.findMarkers(resource, type, pattern);
        AbstractResourceMarkerTest.assertTrue((String)("Marker matches the '" + pattern + "' pattern wasn't found"), (markers.length > 0 ? 1 : 0) != 0);
    }

    public static void assertMarkersIsCreated(IResource resource, MarkerData[] markersData) throws CoreException {
        MarkerData[] markerDataArray = markersData;
        int n = markersData.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerData markerData = markerDataArray[n2];
            AbstractResourceMarkerTest.assertMarkerIsCreated(resource, markerData);
            ++n2;
        }
    }

    public static int getMarkersNumber(IResource resource) {
        return AbstractResourceMarkerTest.getMarkersNumber(resource, null);
    }

    public static int getMarkersNumber(IResource resource, IMarkerFilter filter) {
        try {
            IMarker[] markers = resource.findMarkers(null, true, 2);
            int length = markers.length;
            int i = 0;
            while (i < markers.length) {
                if (markers[i].exists() && (filter == null || !filter.accept(markers[i]))) {
                    --length;
                }
                ++i;
            }
            return length;
        }
        catch (CoreException ex) {
            JUnitUtils.fail("Can't get problem markers", (Exception)((Object)ex));
            return -1;
        }
    }

    public static String[] getMarkersMessage(IResource resource) {
        return AbstractResourceMarkerTest.getMarkersMessage(resource, null);
    }

    public static String[] getMarkersMessage(IResource resource, IMarkerFilter filter) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            IMarker[] markers = resource.findMarkers(null, true, 2);
            int i = 0;
            while (i < markers.length) {
                if (markers[i].exists() && (filter == null || filter.accept(markers[i]))) {
                    messages.add(markers[i].getAttribute("message", ""));
                }
                ++i;
            }
        }
        catch (CoreException ex) {
            JUnitUtils.fail("Can't get problem markers", (Exception)((Object)ex));
        }
        return messages.toArray(new String[0]);
    }

    public static Integer[] getMarkersNumbersOfLine(IResource resource) {
        return AbstractResourceMarkerTest.getMarkersNumbersOfLine(resource, null);
    }

    public static Integer[] getMarkersNumbersOfLine(IResource resource, IMarkerFilter filter) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        try {
            IMarker[] markers = resource.findMarkers(null, true, 2);
            int i = 0;
            while (i < markers.length) {
                if (markers[i].exists() && (filter == null || filter.accept(markers[i]))) {
                    numbers.add(markers[i].getAttribute("lineNumber", 0));
                }
                ++i;
            }
        }
        catch (CoreException ex) {
            JUnitUtils.fail("Can't get problem markers.", (Exception)((Object)ex));
        }
        return numbers.toArray(new Integer[0]);
    }

    public static int getMarkersNumberByGroupName(String type, IResource resource, String messageGroup) {
        try {
            IMarker[] markers = resource.findMarkers(type, true, 2);
            int length = markers.length;
            int i = 0;
            while (i < markers.length) {
                String groupName = markers[i].getAttribute("groupName", null);
                if (groupName == null || !groupName.equals(messageGroup) && !groupName.equals("markedKbResource")) {
                    --length;
                }
                ++i;
            }
            return length;
        }
        catch (CoreException ex) {
            JUnitUtils.fail("Can'r get problem markers", (Exception)((Object)ex));
            return -1;
        }
    }

    public static int getMarkersNumberByGroupName(IResource resource, String messageGroup) {
        return AbstractResourceMarkerTest.getMarkersNumberByGroupName(MARKER_TYPE, resource, messageGroup);
    }

    public static void assertMarkerIsCreated(IResource resource, String pattern, int ... expectedLines) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsCreated(resource, pattern, true, expectedLines);
    }

    public static void assertMarkerIsCreated(IResource resource, String message, boolean pattern, int ... expectedLines) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsCreated(resource, MARKER_TYPE, pattern ? AbstractResourceMarkerTest.convertMessageToPatern(message) : message, pattern, expectedLines);
    }

    public static void assertMarkerIsNotCreated(IResource resource, String message) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsNotCreated(resource, MARKER_TYPE, AbstractResourceMarkerTest.convertMessageToPatern(message));
    }

    public static void assertMarkerIsNotCreated(IResource resource, String message, int expectedLine) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsNotCreated(resource, MARKER_TYPE, AbstractResourceMarkerTest.convertMessageToPatern(message), expectedLine);
    }

    public static void assertMarkerIsCreatedForGivenPosition(IResource resource, String message, int lineNumber, int startPosition, int endPosition) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsCreatedForGivenPosition(resource, MARKER_TYPE, AbstractResourceMarkerTest.convertMessageToPatern(message), lineNumber, startPosition, endPosition);
    }

    public static String convertMessageToPatern(String message) {
        return message.replace("[", "\\[").replace("]", "\\]").replace("<", "\\<").replace(">", "\\>").replace("(", "\\(").replace(")", "\\)").replace("{", "\\{").replace("}", "\\}").replace("'", "\\'");
    }

    @Override
    public void assertAnnotationIsCreated(IResource resource, String pattern, int ... expectedLines) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsCreated(resource, pattern, expectedLines);
    }

    @Override
    public void assertAnnotationIsCreated(IResource resource, String message, boolean pattern, int ... expectedLines) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsCreated(resource, message, pattern, expectedLines);
    }

    @Override
    public void assertAnnotationIsNotCreated(IResource resource, String message) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsNotCreated(resource, message);
    }

    @Override
    public void assertAnnotationIsNotCreated(IResource resource, String message, int expectedLine) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsNotCreated(resource, message, expectedLine);
    }

    @Override
    public void assertAnnotationIsCreatedForGivenPosition(IResource resource, String message, int lineNumber, int startPosition, int endPosition) throws CoreException {
        AbstractResourceMarkerTest.assertMarkerIsCreatedForGivenPosition(resource, message, lineNumber, startPosition, endPosition);
    }

    public static class MarkerData {
        private String type;
        private String pattern;
        private int line = -1;

        public MarkerData(String type, String pattern, int line) {
            this.type = type;
            this.pattern = pattern;
            this.line = line;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }
}

