/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.codenorm;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.StringTokenizer;
import net.sf.saxon.codenorm.NormalizerData;
import net.sf.saxon.codenorm.UnicodeData;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntToIntHashMap;
import net.sf.saxon.sort.IntToIntMap;

class UnicodeDataParser {
    private static final int SBase = 44032;
    private static final int LBase = 4352;
    private static final int VBase = 4449;
    private static final int TBase = 4519;
    private static final int LCount = 19;
    private static final int VCount = 21;
    private static final int TCount = 28;
    private static final int NCount = 588;
    private static final int SCount = 11172;

    private UnicodeDataParser() {
    }

    static NormalizerData build() {
        IntToIntHashMap canonicalClass = new IntToIntHashMap(400);
        canonicalClass.setDefaultValue(0);
        IntHashMap decompose = new IntHashMap(18000);
        IntToIntHashMap compose = new IntToIntHashMap(15000);
        compose.setDefaultValue(65535);
        BitSet isCompatibility = new BitSet(128000);
        BitSet isExcluded = new BitSet(128000);
        UnicodeDataParser.readExclusionList(isExcluded);
        UnicodeDataParser.readCompatibilityList(isCompatibility);
        UnicodeDataParser.readCanonicalClassTable(canonicalClass);
        UnicodeDataParser.readDecompositionTable(decompose, compose, isExcluded, isCompatibility);
        return new NormalizerData(canonicalClass, decompose, compose, isCompatibility, isExcluded);
    }

    private static void readExclusionList(BitSet isExcluded) {
        int i = 0;
        while (i < UnicodeData.exclusionList.length) {
            String s = UnicodeData.exclusionList[i];
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int value = Integer.parseInt(tok, 32);
                isExcluded.set(value);
            }
            ++i;
        }
    }

    private static void readCompatibilityList(BitSet isCompatible) {
        int i = 0;
        while (i < UnicodeData.compatibilityList.length) {
            String s = UnicodeData.compatibilityList[i];
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int value = Integer.parseInt(tok, 32);
                isCompatible.set(value);
            }
            ++i;
        }
    }

    private static void readCanonicalClassTable(IntToIntMap canonicalClasses) {
        ArrayList<Integer> keys = new ArrayList<Integer>(5000);
        int i = 0;
        while (i < UnicodeData.canonicalClassKeys.length) {
            String s = UnicodeData.canonicalClassKeys[i];
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int value = Integer.parseInt(tok, 32);
                keys.add(new Integer(value));
            }
            ++i;
        }
        int k = 0;
        int i2 = 0;
        while (i2 < UnicodeData.canonicalClassValues.length) {
            String s = UnicodeData.canonicalClassValues[i2];
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int clss = Integer.parseInt(tok, 32);
                canonicalClasses.put((Integer)keys.get(k++), clss);
            }
            ++i2;
        }
    }

    private static void readDecompositionTable(IntHashMap decompose, IntToIntMap compose, BitSet isExcluded, BitSet isCompatibility) {
        int k = 0;
        int i = 0;
        while (i < UnicodeData.decompositionKeys.length) {
            String s = UnicodeData.decompositionKeys[i];
            StringTokenizer st = new StringTokenizer(s, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                int key = Integer.parseInt(tok, 32);
                String value = UnicodeData.decompositionValues[k++];
                decompose.put(key, value);
                if (isCompatibility.get(key) || isExcluded.get(key)) continue;
                char first = '\u0000';
                char second = value.charAt(0);
                if (value.length() > 1) {
                    first = second;
                    second = value.charAt(1);
                }
                int pair = first << 16 | second;
                compose.put(pair, key);
            }
            ++i;
        }
        int SIndex = 0;
        while (SIndex < 11172) {
            char second;
            char first;
            int TIndex = SIndex % 28;
            if (TIndex != 0) {
                first = (char)(44032 + SIndex - TIndex);
                second = (char)(4519 + TIndex);
            } else {
                first = (char)(4352 + SIndex / 588);
                second = (char)(4449 + SIndex % 588 / 28);
            }
            int pair = first << 16 | second;
            int key = SIndex + 44032;
            decompose.put(key, String.valueOf(String.valueOf(first)) + second);
            compose.put(pair, key);
            ++SIndex;
        }
    }
}

