/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.type.SchemaType;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class ParseOptions
implements Serializable {
    private int schemaValidation = 0;
    private int dtdValidation = 0;
    private StructuredQName topLevelElement;
    private SchemaType topLevelType;
    private transient XMLReader parser = null;
    private Boolean wrapDocument = null;
    private TreeModel treeModel = null;
    private int stripSpace = 3;
    private Boolean lineNumbering = null;
    private Boolean xIncludeAware = null;
    private boolean pleaseClose = false;
    private transient ErrorListener errorListener = new StandardErrorListener();
    private transient EntityResolver entityResolver = null;
    private List filters = null;
    private boolean sourceIsXQJ = false;
    private boolean continueAfterValidationErrors = false;
    private boolean expandAttributeDefaults = true;
    private boolean useXsiSchemaLocation = true;

    public ParseOptions() {
    }

    public ParseOptions(ParseOptions p) {
        this.schemaValidation = p.schemaValidation;
        this.dtdValidation = p.dtdValidation;
        this.topLevelElement = p.topLevelElement;
        this.topLevelType = p.topLevelType;
        this.parser = p.parser;
        this.wrapDocument = p.wrapDocument;
        this.treeModel = p.treeModel;
        this.stripSpace = p.stripSpace;
        this.lineNumbering = p.lineNumbering;
        this.xIncludeAware = p.xIncludeAware;
        this.pleaseClose = p.pleaseClose;
        this.errorListener = p.errorListener;
        this.entityResolver = p.entityResolver;
        if (p.filters != null) {
            this.filters = new ArrayList(p.filters);
        }
        this.sourceIsXQJ = p.sourceIsXQJ;
        this.expandAttributeDefaults = p.expandAttributeDefaults;
        this.useXsiSchemaLocation = p.useXsiSchemaLocation;
        this.continueAfterValidationErrors = p.continueAfterValidationErrors;
    }

    public void merge(ParseOptions options) {
        if (options.dtdValidation != 0) {
            this.dtdValidation = options.dtdValidation;
        }
        if (options.schemaValidation != 0) {
            this.schemaValidation = options.schemaValidation;
        }
        if (options.topLevelElement != null) {
            this.topLevelElement = options.topLevelElement;
        }
        if (options.topLevelType != null) {
            this.topLevelType = options.topLevelType;
        }
        if (options.parser != null) {
            this.parser = options.parser;
        }
        if (options.wrapDocument != null) {
            this.wrapDocument = options.wrapDocument;
        }
        if (options.treeModel != null) {
            this.treeModel = options.treeModel;
        }
        if (options.stripSpace != 3) {
            this.stripSpace = options.stripSpace;
        }
        if (options.lineNumbering != null) {
            this.lineNumbering = options.lineNumbering;
        }
        if (options.xIncludeAware != null) {
            this.xIncludeAware = options.xIncludeAware;
        }
        if (options.pleaseClose) {
            this.pleaseClose = true;
        }
        if (options.errorListener != null) {
            this.errorListener = options.errorListener;
        }
        if (options.entityResolver != null) {
            this.entityResolver = options.entityResolver;
        }
        if (options.filters != null) {
            if (this.filters == null) {
                this.filters = new ArrayList();
            }
            this.filters.addAll(options.filters);
        }
        if (options.sourceIsXQJ) {
            this.sourceIsXQJ = true;
        }
        if (!options.expandAttributeDefaults) {
            this.expandAttributeDefaults = false;
        }
        if (!options.useXsiSchemaLocation) {
            this.useXsiSchemaLocation = false;
        }
    }

    public void applyDefaults(Configuration config) {
        if (this.dtdValidation == 0) {
            int n = this.dtdValidation = config.isValidation() ? 1 : 4;
        }
        if (this.schemaValidation == 0) {
            this.schemaValidation = config.getSchemaValidationMode();
        }
        if (this.treeModel == null) {
            this.treeModel = TreeModel.getTreeModel(config.getTreeModel());
        }
        if (this.stripSpace == 3) {
            this.stripSpace = config.getStripsWhiteSpace();
        }
        if (this.lineNumbering == null) {
            this.lineNumbering = config.isLineNumbering();
        }
        if (this.xIncludeAware == null) {
            this.xIncludeAware = config.isXIncludeAware();
        }
        if (this.errorListener == null) {
            this.errorListener = config.getErrorListener();
        }
    }

    public void addFilter(ProxyReceiver filter) {
        if (this.filters == null) {
            this.filters = new ArrayList(5);
        }
        this.filters.add(filter);
    }

    public List getFilters() {
        return this.filters;
    }

    public void setStripSpace(int stripAction) {
        this.stripSpace = stripAction;
    }

    public int getStripSpace() {
        return this.stripSpace == 3 ? 1 : this.stripSpace;
    }

    public void setTreeModel(int model) {
        this.treeModel = TreeModel.getTreeModel(model);
    }

    public int getTreeModel() {
        if (this.treeModel == null) {
            return -1;
        }
        return this.treeModel.getSymbolicValue();
    }

    public void setModel(TreeModel model) {
        this.treeModel = model;
    }

    public TreeModel getModel() {
        return this.treeModel == null ? TreeModel.TINY_TREE : this.treeModel;
    }

    public void setSchemaValidationMode(int option) {
        this.schemaValidation = option;
    }

    public int getSchemaValidationMode() {
        return this.schemaValidation;
    }

    public void setExpandAttributeDefaults(boolean expand) {
        this.expandAttributeDefaults = expand;
    }

    public boolean isExpandAttributeDefaults() {
        return this.expandAttributeDefaults;
    }

    public void setTopLevelElement(StructuredQName elementName) {
        this.topLevelElement = elementName;
    }

    public StructuredQName getTopLevelElement() {
        return this.topLevelElement;
    }

    public void setTopLevelType(SchemaType type) {
        this.topLevelType = type;
    }

    public SchemaType getTopLevelType() {
        return this.topLevelType;
    }

    public void setUseXsiSchemaLocation(boolean use) {
        this.useXsiSchemaLocation = use;
    }

    public boolean isUseXsiSchemaLocation() {
        return this.useXsiSchemaLocation;
    }

    public void setDTDValidationMode(int option) {
        this.dtdValidation = option;
    }

    public int getDTDValidationMode() {
        return this.dtdValidation;
    }

    public void setLineNumbering(boolean lineNumbering) {
        this.lineNumbering = lineNumbering;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering != null && this.lineNumbering != false;
    }

    public boolean isLineNumberingSet() {
        return this.lineNumbering != null;
    }

    public void setXMLReader(XMLReader parser) {
        this.parser = parser;
    }

    public XMLReader getXMLReader() {
        return this.parser;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setWrapDocument(Boolean wrap) {
        this.wrapDocument = wrap;
    }

    public Boolean getWrapDocument() {
        return this.wrapDocument;
    }

    public void setXIncludeAware(boolean state) {
        this.xIncludeAware = state;
    }

    public boolean isXIncludeAwareSet() {
        return this.xIncludeAware != null;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware != null && this.xIncludeAware != false;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setContinueAfterValidationErrors(boolean keepGoing) {
        this.continueAfterValidationErrors = keepGoing;
    }

    public boolean isContinueAfterValidationErrors() {
        return this.continueAfterValidationErrors;
    }

    public void setPleaseCloseAfterUse(boolean close) {
        this.pleaseClose = close;
    }

    public boolean isPleaseCloseAfterUse() {
        return this.pleaseClose;
    }

    public static void close(Source source) {
        try {
            InputSource is;
            if (source instanceof StreamSource) {
                StreamSource ss = (StreamSource)source;
                if (ss.getInputStream() != null) {
                    ss.getInputStream().close();
                }
                if (ss.getReader() != null) {
                    ss.getReader().close();
                }
            } else if (source instanceof SAXSource && (is = ((SAXSource)source).getInputSource()) != null) {
                if (is.getByteStream() != null) {
                    is.getByteStream().close();
                }
                if (is.getCharacterStream() != null) {
                    is.getCharacterStream().close();
                }
            }
        }
        catch (IOException iOException) {}
    }
}

