/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;

public class IntegerRangeTest
extends Expression {
    Expression value;
    Expression min;
    Expression max;

    public IntegerRangeTest(Expression value, Expression min, Expression max) {
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public Expression getValueExpression() {
        return this.value;
    }

    public Expression getMinValueExpression() {
        return this.min;
    }

    public Expression getMaxValueExpression() {
        return this.max;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return BuiltInAtomicType.BOOLEAN;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression copy() {
        return new IntegerRangeTest(this.value.copy(), this.min.copy(), this.max.copy());
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        Expression[] e = new Expression[]{this.value, this.min, this.max};
        return Arrays.asList(e).iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.value == original) {
            this.value = replacement;
            found = true;
        }
        if (this.min == original) {
            this.min = replacement;
            found = true;
        }
        if (this.max == original) {
            this.max = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        if (offer.action != 13) {
            this.value = this.doPromotion(this, this.value, offer);
            this.min = this.doPromotion(this, this.min, offer);
            this.max = this.doPromotion(this, this.max, offer);
        }
        return this;
    }

    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        AtomicValue av = (AtomicValue)this.value.evaluateItem(c);
        if (av == null) {
            return BooleanValue.FALSE;
        }
        NumericValue v = (NumericValue)av;
        if (!v.isWholeNumber()) {
            return BooleanValue.FALSE;
        }
        AtomicValue av2 = (AtomicValue)this.min.evaluateItem(c);
        NumericValue v2 = (NumericValue)av2;
        if (v.compareTo(v2) < 0) {
            return BooleanValue.FALSE;
        }
        AtomicValue av3 = (AtomicValue)this.max.evaluateItem(c);
        NumericValue v3 = (NumericValue)av3;
        return BooleanValue.get(v.compareTo(v3) <= 0);
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("integerRangeTest");
        this.value.explain(destination);
        this.min.explain(destination);
        this.max.explain(destination);
        destination.endElement();
    }
}

