/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public abstract class SimpleExpression
extends Expression {
    public static final Expression[] NO_ARGUMENTS = new Expression[0];
    protected Expression[] arguments = NO_ARGUMENTS;

    public void setArguments(Expression[] sub) {
        this.arguments = sub;
        int i = 0;
        while (i < sub.length) {
            this.adoptChildExpression(sub[i]);
            ++i;
        }
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return Arrays.asList(this.arguments).iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        int i = 0;
        while (i < this.arguments.length) {
            if (this.arguments[i] == original) {
                this.arguments[i] = replacement;
                found = true;
            }
            ++i;
        }
        return found;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        int i = 0;
        while (i < this.arguments.length) {
            if (this.arguments[i] != null) {
                this.arguments[i] = visitor.simplify(this.arguments[i]);
            }
            ++i;
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int i = 0;
        while (i < this.arguments.length) {
            if (this.arguments[i] != null) {
                this.arguments[i] = visitor.typeCheck(this.arguments[i], contextItemType);
            }
            ++i;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        int i = 0;
        while (i < this.arguments.length) {
            if (this.arguments[i] != null) {
                this.arguments[i] = visitor.optimize(this.arguments[i], contextItemType);
            }
            ++i;
        }
        return this;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        int i = 0;
        while (i < this.arguments.length) {
            if (this.arguments[i] != null) {
                this.arguments[i] = this.doPromotion(this, this.arguments[i], offer);
            }
            ++i;
        }
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return Type.ITEM_TYPE;
    }

    @Override
    public int computeCardinality() {
        if ((this.getImplementationMethod() & 1) == 0) {
            return 49152;
        }
        return 24576;
    }

    @Override
    public int computeDependencies() {
        return super.computeDependencies();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        int m = this.getImplementationMethod();
        if ((m & 1) != 0) {
            throw new AssertionError((Object)("evaluateItem() is not implemented in the subclass " + this.getClass()));
        }
        if ((m & 2) != 0) {
            return this.iterate(context).next();
        }
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(1);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getContainer().getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        Item item = seq.getFirstItem();
        seq.reset();
        return item;
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        int m = this.getImplementationMethod();
        if ((m & 1) != 0) {
            Item item = this.evaluateItem(context);
            if (item == null) {
                return EmptyIterator.getInstance();
            }
            return SingletonIterator.makeIterator(item);
        }
        if ((m & 2) != 0) {
            throw new AssertionError((Object)("iterate() is not implemented in the subclass " + this.getClass()));
        }
        Controller controller = context.getController();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        SequenceOutputter seq = controller.allocateSequenceOutputter(10);
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(this.getContainer().getHostLanguage());
        seq.setPipelineConfiguration(pipe);
        c2.setTemporaryReceiver(seq);
        this.process(c2);
        SequenceIterator result = Value.getIterator(seq.getSequence());
        seq.reset();
        return result;
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        int m = this.getImplementationMethod();
        if ((m & 1) == 0) {
            Item it;
            SequenceIterator iter = this.iterate(context);
            while ((it = iter.next()) != null) {
                context.getReceiver().append(it, this.locationId, 2);
            }
        } else {
            Item item = this.evaluateItem(context);
            context.getReceiver().append(item, this.locationId, 2);
        }
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("userExpression");
        destination.emitAttribute("class", this.getExpressionType());
        int i = 0;
        while (i < this.arguments.length) {
            this.arguments[i].explain(destination);
            ++i;
        }
        destination.endElement();
    }

    public String getExpressionType() {
        return this.getClass().getName();
    }
}

