/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.codenorm.Normalizer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.tinytree.CompressedWhitespace;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class NormalizeUnicode
extends SystemFunction {
    @Override
    public Item evaluateItem(XPathContext c) throws XPathException {
        StringValue sv = (StringValue)this.argument[0].evaluateItem(c);
        if (sv == null) {
            return StringValue.EMPTY_STRING;
        }
        byte fb = 2;
        if (this.argument.length == 2) {
            String form = Whitespace.trim(this.argument[1].evaluateAsString(c));
            if (form.equalsIgnoreCase("NFC")) {
                fb = 2;
            } else if (form.equalsIgnoreCase("NFD")) {
                fb = 0;
            } else if (form.equalsIgnoreCase("NFKC")) {
                fb = 3;
            } else if (form.equalsIgnoreCase("NFKD")) {
                fb = 1;
            } else {
                if (form.length() == 0) {
                    return sv;
                }
                String msg = "Normalization form " + form + " is not supported";
                XPathException err = new XPathException(msg);
                err.setErrorCode("FOCH0003");
                err.setXPathContext(c);
                err.setLocator(this);
                throw err;
            }
        }
        boolean allASCII = true;
        CharSequence chars = sv.getStringValueCS();
        if (chars instanceof CompressedWhitespace) {
            return sv;
        }
        int i = chars.length() - 1;
        while (i >= 0) {
            if (chars.charAt(i) > '\u007f') {
                allASCII = false;
                break;
            }
            --i;
        }
        if (allASCII) {
            return sv;
        }
        Normalizer norm = new Normalizer(fb);
        CharSequence result = norm.normalize(sv.getStringValueCS());
        return StringValue.makeStringValue(result);
    }
}

