/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;

public final class KeyPattern
extends Pattern {
    private StructuredQName keyName;
    private KeyDefinitionSet keySet;
    private Expression keyExpression;

    public KeyPattern(StructuredQName keyName, Expression key) {
        this.keyName = keyName;
        this.keyExpression = key;
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.keyExpression = visitor.typeCheck(this.keyExpression, contextItemType);
        RoleLocator role = new RoleLocator(0, (Serializable)((Object)"key"), 2);
        this.keyExpression = TypeChecker.staticTypeCheck(this.keyExpression, SequenceType.ATOMIC_SEQUENCE, false, role, visitor);
        this.keySet = visitor.getExecutable().getKeyManager().getKeyDefinitionSet(this.keyName);
        if (this.keySet == null) {
            XPathException err = new XPathException("Unknown key name " + this.keyName.getClarkName() + " in pattern");
            err.setErrorCode("XTDE1260");
            err.setLocator(this);
            err.setIsStaticError(true);
            throw err;
        }
        return this;
    }

    @Override
    public int getDependencies() {
        return this.keyExpression.getDependencies();
    }

    @Override
    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.keyExpression);
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        this.keyExpression = this.keyExpression.promote(offer, parent);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        if (this.keyExpression == original) {
            this.keyExpression = replacement;
            return true;
        }
        return false;
    }

    @Override
    public int allocateSlots(StaticContext env, SlotManager slotManager, int nextFree) {
        return ExpressionTool.allocateSlots(this.keyExpression, nextFree, slotManager);
    }

    @Override
    public boolean matches(NodeInfo e, XPathContext context) throws XPathException {
        DocumentInfo doc;
        KeyDefinitionSet kds = this.keySet;
        if (kds == null) {
            kds = context.getController().getExecutable().getKeyManager().getKeyDefinitionSet(this.keyName);
        }
        if ((doc = e.getDocumentRoot()) == null) {
            return false;
        }
        KeyManager km = context.getController().getKeyManager();
        SequenceIterator iter = this.keyExpression.iterate(context);
        block0: while (true) {
            NodeInfo n;
            Item it;
            if ((it = iter.next()) == null) {
                return false;
            }
            SequenceIterator nodes = km.selectByKey(kds, doc, (AtomicValue)it, context);
            do {
                if ((n = (NodeInfo)nodes.next()) == null) continue block0;
            } while (!n.isSameNodeInfo(e));
            break;
        }
        return true;
    }

    @Override
    public NodeTest getNodeTest() {
        return AnyNodeTest.getInstance();
    }

    public boolean equals(Object other) {
        return other instanceof KeyPattern && ((KeyPattern)other).keyName.equals(this.keyName) && ((KeyPattern)other).keyExpression.equals(this.keyExpression);
    }

    public int hashCode() {
        return 0x87287310 ^ this.keyExpression.hashCode() & this.keyName.hashCode();
    }
}

