/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.query;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.ConstructorFunctionLibrary;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.functions.SystemFunctionLibrary;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.instruct.LocationMap;
import net.sf.saxon.instruct.SavedNamespaceContext;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.instruct.UserFunction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.GlobalVariableDefinition;
import net.sf.saxon.query.ImportedFunctionLibrary;
import net.sf.saxon.query.QueryParser;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.UnboundFunctionLibrary;
import net.sf.saxon.query.UndeclaredVariable;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.sort.IntArraySet;
import net.sf.saxon.sort.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.SequenceType;

public class QueryModule
implements StaticContext {
    private boolean isMainModule;
    private Configuration config;
    private StaticQueryContext userQueryContext;
    private QueryModule topModule;
    private URI locationURI;
    private String baseURI;
    private String moduleNamespace;
    private short moduleNamespaceURICode;
    private HashMap<String, String> explicitPrologNamespaces;
    private Stack<ActiveNamespace> activeNamespaces;
    private HashMap<StructuredQName, VariableDeclaration> variables;
    private HashMap<StructuredQName, GlobalVariableDefinition> libraryVariables;
    private HashMap<StructuredQName, UndeclaredVariable> undeclaredVariables;
    private HashSet<String> importedSchemata;
    private HashMap<String, HashSet<String>> loadedSchemata;
    private Executable executable;
    private List<QueryModule> importers;
    private FunctionLibraryList functionLibraryList;
    private XQueryFunctionLibrary globalFunctionLibrary;
    private int localFunctionLibraryNr;
    private int importedFunctionLibraryNr;
    private int unboundFunctionLibraryNr;
    private Set importedModuleNamespaces;
    private boolean inheritNamespaces = true;
    private boolean preserveNamespaces = true;
    private int constructionMode = 3;
    private String defaultFunctionNamespace;
    private String defaultElementNamespace;
    private boolean preserveSpace = false;
    private boolean defaultEmptyLeast = true;
    private String defaultCollationName;
    private int revalidationMode = 4;
    private boolean isUpdating = false;
    private String languageVersion = "1.0";
    private DecimalFormatManager decimalFormatManager = null;

    public QueryModule(StaticQueryContext sqc) throws XPathException {
        this.config = sqc.getConfiguration();
        this.isMainModule = true;
        this.topModule = this;
        this.activeNamespaces = new Stack();
        this.baseURI = sqc.getBaseURI();
        try {
            this.locationURI = this.baseURI == null ? null : new URI(this.baseURI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("Invalid location URI: " + this.baseURI);
        }
        this.executable = null;
        this.importers = null;
        this.init(sqc);
        Iterator vars = sqc.iterateDeclaredGlobalVariables();
        while (vars.hasNext()) {
            GlobalVariableDefinition var = (GlobalVariableDefinition)vars.next();
            this.declareVariable(var);
        }
    }

    public QueryModule(Configuration config, QueryModule importer) {
        this.config = config;
        this.importers = null;
        if (importer == null) {
            this.topModule = this;
        } else {
            this.topModule = importer.topModule;
            this.userQueryContext = importer.userQueryContext;
            this.importers = new ArrayList<QueryModule>(2);
            this.importers.add(importer);
        }
        this.init(this.userQueryContext);
        this.activeNamespaces = new Stack();
        this.executable = null;
    }

    private void init(StaticQueryContext sqc) {
        this.userQueryContext = sqc;
        this.variables = new HashMap(10);
        this.undeclaredVariables = new HashMap(5);
        if (this.isTopLevelModule()) {
            this.libraryVariables = new HashMap(10);
        }
        this.importedSchemata = null;
        this.importedModuleNamespaces = new HashSet(5);
        this.moduleNamespace = null;
        this.moduleNamespaceURICode = 0;
        this.activeNamespaces = new Stack();
        this.explicitPrologNamespaces = new HashMap(10);
        if (sqc != null) {
            this.inheritNamespaces = sqc.isInheritNamespaces();
            this.preserveNamespaces = sqc.isPreserveNamespaces();
            this.preserveSpace = sqc.isPreserveBoundarySpace();
            this.defaultEmptyLeast = sqc.isEmptyLeast();
            this.defaultFunctionNamespace = sqc.getDefaultFunctionNamespace();
            this.defaultElementNamespace = sqc.getDefaultElementNamespace();
            this.defaultCollationName = sqc.getDefaultCollationName();
            this.constructionMode = sqc.getConstructionMode();
            if (this.constructionMode == 3 && !sqc.isSchemaAware()) {
                this.constructionMode = 4;
            }
            this.isUpdating = sqc.isUpdatingEnabled();
            this.languageVersion = sqc.getLanguageVersion();
        }
        this.resetFunctionLibraries();
    }

    public static QueryModule makeQueryModule(String baseURI, Executable executable, QueryModule importer, String query, String namespaceURI, boolean allowCycles) throws XPathException {
        Configuration config = executable.getConfiguration();
        QueryModule module = new QueryModule(config, importer);
        try {
            module.setLocationURI(new URI(baseURI));
        }
        catch (URISyntaxException e) {
            throw new XPathException("Invalid location URI " + baseURI, e);
        }
        module.setBaseURI(baseURI);
        module.setExecutable(executable);
        module.setModuleNamespace(namespaceURI);
        executable.addQueryLibraryModule(module);
        QueryParser qp = importer.getUserQueryContext().newQueryParser(importer.isUpdating(), importer.getLanguageVersion());
        qp.setCompileWithTracing(config.isCompileWithTracing());
        qp.setDisableCycleChecks(allowCycles);
        qp.parseLibraryModule(query, module);
        if (module.getModuleNamespace() == null) {
            XPathException err = new XPathException("Imported module must be a library module");
            err.setErrorCode("XQST0059");
            err.setIsStaticError(true);
            throw err;
        }
        if (!module.getModuleNamespace().equals(namespaceURI)) {
            XPathException err = new XPathException("Imported module's namespace does not match requested namespace");
            err.setErrorCode("XQST0059");
            err.setIsStaticError(true);
            throw err;
        }
        return module;
    }

    private void resetFunctionLibraries() {
        Configuration config = this.getConfiguration();
        if (this.isTopLevelModule()) {
            this.globalFunctionLibrary = new XQueryFunctionLibrary(config);
        }
        int functionSet = 1;
        if (this.isUpdating()) {
            functionSet |= 8;
        }
        if (this.getLanguageVersion().equals("1.1")) {
            functionSet |= 0x10;
        }
        this.functionLibraryList = new FunctionLibraryList();
        this.functionLibraryList.addFunctionLibrary(SystemFunctionLibrary.getSystemFunctionLibrary(functionSet));
        this.functionLibraryList.addFunctionLibrary(config.getVendorFunctionLibrary());
        this.functionLibraryList.addFunctionLibrary(new ConstructorFunctionLibrary(config));
        this.localFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new XQueryFunctionLibrary(config));
        this.importedFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new ImportedFunctionLibrary(this, this.getTopLevelModule().getGlobalFunctionLibrary()));
        this.functionLibraryList.addFunctionLibrary(config.getIntegratedFunctionLibrary());
        config.addExtensionBinders(this.functionLibraryList);
        this.unboundFunctionLibraryNr = this.functionLibraryList.addFunctionLibrary(new UnboundFunctionLibrary());
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public boolean isTopLevelModule() {
        return this == this.topModule;
    }

    public void setIsMainModule(boolean main) {
        this.isMainModule = main;
    }

    public boolean isMainModule() {
        return this.isMainModule;
    }

    public boolean mayImportModule(String namespace) {
        if (namespace.equals(this.moduleNamespace)) {
            return false;
        }
        if (this.importers == null) {
            return true;
        }
        int i = 0;
        while (i < this.importers.size()) {
            if (!this.importers.get(i).mayImportModule(namespace)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setInheritNamespaces(boolean inherit) {
        this.inheritNamespaces = inherit;
    }

    public boolean isInheritNamespaces() {
        return this.inheritNamespaces;
    }

    public void setPreserveNamespaces(boolean inherit) {
        this.preserveNamespaces = inherit;
    }

    public boolean isPreserveNamespaces() {
        return this.preserveNamespaces;
    }

    public void setConstructionMode(int mode) {
        this.constructionMode = mode;
    }

    public int getConstructionMode() {
        return this.constructionMode;
    }

    public void setPreserveBoundarySpace(boolean preserve) {
        this.preserveSpace = preserve;
    }

    public boolean isPreserveBoundarySpace() {
        return this.preserveSpace;
    }

    public void setEmptyLeast(boolean least) {
        this.defaultEmptyLeast = least;
    }

    public boolean isEmptyLeast() {
        return this.defaultEmptyLeast;
    }

    public XQueryFunctionLibrary getGlobalFunctionLibrary() {
        return this.globalFunctionLibrary;
    }

    public ImportedFunctionLibrary getImportedFunctionLibrary() {
        return (ImportedFunctionLibrary)this.functionLibraryList.get(this.importedFunctionLibraryNr);
    }

    public void addImportedNamespace(String uri) {
        if (this.importedModuleNamespaces == null) {
            this.importedModuleNamespaces = new HashSet(5);
        }
        this.importedModuleNamespaces.add(uri);
        this.getImportedFunctionLibrary().addImportedNamespace(uri);
    }

    public boolean importsNamespace(String uri) {
        return this.importedModuleNamespaces != null && this.importedModuleNamespaces.contains(uri);
    }

    public boolean importsNamespaceIndirectly(String uri) {
        if (this.importsNamespace(uri)) {
            return true;
        }
        Iterator it = this.iterateImportedNamespaces();
        while (it.hasNext()) {
            String moduleURI = (String)it.next();
            List<QueryModule> list = this.executable.getQueryLibraryModules(moduleURI);
            for (QueryModule sqc : list) {
                if (!sqc.importsNamespaceIndirectly(uri)) continue;
                return true;
            }
        }
        return false;
    }

    public Iterator iterateImportedNamespaces() {
        if (this.importedModuleNamespaces == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.importedModuleNamespaces.iterator();
    }

    public QueryModule getTopLevelModule() {
        return this.topModule;
    }

    @Override
    public Executable getExecutable() {
        return this.executable;
    }

    public void setExecutable(Executable executable) {
        this.executable = executable;
    }

    public StaticQueryContext getUserQueryContext() {
        return this.userQueryContext;
    }

    @Override
    public LocationMap getLocationMap() {
        return this.executable.getLocationMap();
    }

    public void setModuleNamespace(String uri) {
        this.moduleNamespace = uri;
        this.moduleNamespaceURICode = this.getNamePool().getCodeForURI(uri);
    }

    public String getModuleNamespace() {
        return this.moduleNamespace;
    }

    public short getModuleNamespaceCode() {
        return this.moduleNamespaceURICode;
    }

    public void setLocationURI(URI uri) {
        this.locationURI = uri;
    }

    public URI getLocationURI() {
        return this.locationURI;
    }

    @Override
    public String getSystemId() {
        return this.locationURI == null ? null : this.locationURI.toString();
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    public SlotManager getGlobalStackFrameMap() {
        return this.executable.getGlobalVariableMap();
    }

    public void declareVariable(VariableDeclaration var) throws XPathException {
        VariableDeclaration old;
        StructuredQName key = var.getVariableQName();
        if (this.variables.get(key) != null && (old = this.variables.get(key)) != var) {
            String oldloc = "";
            if (old instanceof GlobalVariableDefinition && var instanceof GlobalVariableDefinition) {
                oldloc = " (see line " + ((GlobalVariableDefinition)old).getLineNumber();
                String oldSysId = ((GlobalVariableDefinition)old).getSystemId();
                if (oldSysId != null && !oldSysId.equals(((GlobalVariableDefinition)var).getSystemId())) {
                    oldloc = String.valueOf(oldloc) + " in module ((GlobalVariableDefinition)old).getSystemId()";
                }
                oldloc = String.valueOf(oldloc) + ')';
            }
            XPathException err = new XPathException("Duplicate definition of global variable " + var.getVariableQName().getDisplayName() + oldloc);
            err.setErrorCode("XQST0049");
            err.setIsStaticError(true);
            if (var instanceof GlobalVariableDefinition) {
                ExpressionLocation loc = new ExpressionLocation();
                loc.setLineNumber(((GlobalVariableDefinition)var).getLineNumber());
                loc.setSystemId(((GlobalVariableDefinition)var).getSystemId());
                err.setLocator(loc);
            }
            throw err;
        }
        this.variables.put(key, var);
        HashMap<StructuredQName, GlobalVariableDefinition> libVars = this.getTopLevelModule().libraryVariables;
        GlobalVariableDefinition old2 = libVars.get(key);
        if (old2 != null && old2 != var) {
            XPathException err = new XPathException("Duplicate definition of global variable " + var.getVariableQName().getDisplayName() + " (see line " + old2.getLineNumber() + " in module " + old2.getSystemId() + ')');
            err.setErrorCode("XQST0049");
            err.setIsStaticError(true);
            if (var instanceof GlobalVariableDefinition) {
                ExpressionLocation loc = new ExpressionLocation();
                loc.setLineNumber(((GlobalVariableDefinition)var).getLineNumber());
                loc.setSystemId(((GlobalVariableDefinition)var).getSystemId());
                err.setLocator(loc);
            }
            throw err;
        }
        if (!this.isMainModule()) {
            libVars.put(key, (GlobalVariableDefinition)var);
        }
    }

    public Iterator<GlobalVariableDefinition> getGlobalVariables() throws XPathException {
        return this.libraryVariables.values().iterator();
    }

    /*
     * Unable to fully structure code
     */
    public List<GlobalVariableDefinition> fixupGlobalVariables(SlotManager globalVariableMap) throws XPathException {
        varDefinitions = new ArrayList<GlobalVariableDefinition>(20);
        iters = new Iterator[]{this.variables.values().iterator(), this.libraryVariables.values().iterator()};
        i = 0;
        ** GOTO lbl17
        {
            var = (GlobalVariableDefinition)iters[i].next();
            slot = globalVariableMap.allocateSlotNumber(var.getVariableQName());
            gv = var.getCompiledVariable();
            if (gv == null) {
                var.compile(this.getExecutable(), slot);
            }
            if (!varDefinitions.contains(var)) {
                varDefinitions.add(var);
            }
            do {
                if (iters[i].hasNext()) continue block0;
                ++i;
lbl17:
                // 2 sources

            } while (i < 2);
        }
        return varDefinitions;
    }

    public void lookForModuleCycles(Stack referees, int lineNumber) throws XPathException {
        if (referees.contains(this)) {
            int s = referees.indexOf(this);
            referees.push(this);
            String message = "Circular dependency between modules. ";
            int i = s;
            while (i < referees.size() - 1) {
                QueryModule next = (QueryModule)referees.get(i + 1);
                message = i == s ? String.valueOf(message) + "Module " + this.getSystemId() + " references module " + next.getSystemId() : String.valueOf(message) + ", which references module " + next.getSystemId();
                ++i;
            }
            message = String.valueOf(message) + '.';
            XPathException err = new XPathException(message);
            err.setErrorCode("XQST0093");
            err.setIsStaticError(true);
            ExpressionLocation loc = new ExpressionLocation();
            loc.setSystemId(this.getSystemId());
            loc.setLineNumber(lineNumber);
            err.setLocator(loc);
            throw err;
        }
        referees.push(this);
        Iterator viter = this.getModuleVariables();
        while (viter.hasNext()) {
            String uri;
            GlobalVariableDefinition gv = (GlobalVariableDefinition)viter.next();
            ArrayList list = new ArrayList(10);
            Expression select = gv.getCompiledVariable().getSelectExpression();
            if (select == null) continue;
            ExpressionTool.gatherReferencedVariables(select, list);
            int i = 0;
            while (i < list.size()) {
                Binding b = (Binding)list.get(i);
                if (b instanceof GlobalVariable) {
                    boolean synthetic;
                    uri = ((GlobalVariable)b).getSystemId();
                    StructuredQName qName = b.getVariableQName();
                    boolean bl = synthetic = "http://saxon.sf.net/".equals(qName.getNamespaceURI()) && "gg".equals(qName.getPrefix());
                    if (!synthetic && !uri.equals(this.getSystemId())) {
                        QueryModule sqc = this.executable.getQueryModuleWithSystemId(uri, this.topModule);
                        sqc.lookForModuleCycles(referees, ((GlobalVariable)b).getLineNumber());
                    }
                }
                ++i;
            }
            list.clear();
            ExpressionTool.gatherCalledFunctions(select, list);
            i = 0;
            while (i < list.size()) {
                UserFunction f = (UserFunction)list.get(i);
                uri = f.getSystemId();
                if (!uri.equals(this.getSystemId())) {
                    QueryModule sqc = this.executable.getQueryModuleWithSystemId(uri, this.topModule);
                    sqc.lookForModuleCycles(referees, f.getLineNumber());
                }
                ++i;
            }
        }
        Iterator<XQueryFunction> fiter = this.getLocalFunctionLibrary().getFunctionDefinitions();
        while (fiter.hasNext()) {
            String uri;
            XQueryFunction gf = fiter.next();
            ArrayList list = new ArrayList(10);
            Expression body = gf.getUserFunction().getBody();
            if (body == null) continue;
            ExpressionTool.gatherReferencedVariables(body, list);
            int i = 0;
            while (i < list.size()) {
                Binding b = (Binding)list.get(i);
                if (b instanceof GlobalVariable) {
                    boolean synthetic;
                    uri = ((GlobalVariable)b).getSystemId();
                    StructuredQName qName = b.getVariableQName();
                    boolean bl = synthetic = "http://saxon.sf.net/".equals(qName.getNamespaceURI()) && "gg".equals(qName.getPrefix());
                    if (!synthetic && !uri.equals(this.getSystemId())) {
                        QueryModule sqc = this.executable.getQueryModuleWithSystemId(uri, this.topModule);
                        sqc.lookForModuleCycles(referees, ((GlobalVariable)b).getLineNumber());
                    }
                }
                ++i;
            }
            list.clear();
            ExpressionTool.gatherCalledFunctions(body, list);
            i = 0;
            while (i < list.size()) {
                UserFunction f = (UserFunction)list.get(i);
                uri = f.getSystemId();
                if (!uri.equals(this.getSystemId())) {
                    QueryModule sqc = this.executable.getQueryModuleWithSystemId(uri, this.topModule);
                    sqc.lookForModuleCycles(referees, f.getLineNumber());
                }
                ++i;
            }
        }
        referees.pop();
    }

    public Iterator getModuleVariables() {
        return this.variables.values().iterator();
    }

    public void checkForCircularities(List compiledVars, XQueryFunctionLibrary globalFunctionLibrary) throws XPathException {
        Iterator iter = compiledVars.iterator();
        Stack stack = null;
        while (iter.hasNext()) {
            if (stack == null) {
                stack = new Stack();
            }
            GlobalVariableDefinition gvd = (GlobalVariableDefinition)iter.next();
            GlobalVariable gv = gvd.getCompiledVariable();
            gv.lookForCycles(stack, globalFunctionLibrary);
        }
    }

    public void typeCheckGlobalVariables(List compiledVars) throws XPathException {
        ExpressionVisitor visitor = ExpressionVisitor.make(this);
        visitor.setExecutable(this.getExecutable());
        for (GlobalVariableDefinition gvd : compiledVars) {
            gvd.typeCheck(visitor);
        }
    }

    @Override
    public Expression bindVariable(StructuredQName qName) throws XPathException {
        VariableDeclaration var = this.variables.get(qName);
        if (var == null) {
            String uri = qName.getNamespaceURI();
            if (this.importsNamespace(uri)) {
                QueryModule main = this.getTopLevelModule();
                var = main.libraryVariables.get(qName);
                if (var == null) {
                    UndeclaredVariable uvar = new UndeclaredVariable();
                    uvar.setVariableQName(qName);
                    VariableReference ref = new VariableReference();
                    uvar.registerReference(ref);
                    this.undeclaredVariables.put(qName, uvar);
                    return ref;
                }
                GlobalVariableDefinition gvar = (GlobalVariableDefinition)var;
                this.checkImportedType(gvar.getRequiredType(), gvar);
            } else {
                XPathException err = new XPathException("Unresolved reference to variable");
                err.setErrorCode("XPST0008");
                err.setIsStaticError(true);
                throw err;
            }
        }
        VariableReference vref = new VariableReference();
        var.registerReference(vref);
        return vref;
    }

    public void setFunctionLibraryList(FunctionLibraryList functionLibrary) {
        this.functionLibraryList = functionLibrary;
    }

    @Override
    public FunctionLibrary getFunctionLibrary() {
        return this.functionLibraryList;
    }

    public XQueryFunctionLibrary getLocalFunctionLibrary() {
        return (XQueryFunctionLibrary)this.functionLibraryList.get(this.localFunctionLibraryNr);
    }

    public void declareFunction(XQueryFunction function) throws XPathException {
        Configuration config = this.getConfiguration();
        if (function.getNumberOfArguments() == 1) {
            SchemaType t;
            StructuredQName name = function.getFunctionName();
            int fingerprint = config.getNamePool().getFingerprint(name.getNamespaceURI(), name.getLocalName());
            if (fingerprint != -1 && (t = config.getSchemaType(fingerprint)) != null && t.isAtomicType()) {
                XPathException err = new XPathException("Function name " + function.getDisplayName() + " clashes with the name of the constructor function for an atomic type");
                err.setErrorCode("XQST0034");
                err.setIsStaticError(true);
                throw err;
            }
        }
        XQueryFunctionLibrary local = this.getLocalFunctionLibrary();
        local.declareFunction(function);
        QueryModule main = this.getTopLevelModule();
        main.globalFunctionLibrary.declareFunction(function);
    }

    public void bindUnboundFunctionCalls() throws XPathException {
        UnboundFunctionLibrary lib = (UnboundFunctionLibrary)this.functionLibraryList.get(this.unboundFunctionLibraryNr);
        lib.bindUnboundFunctionCalls(this.functionLibraryList, this.getConfiguration());
    }

    public void fixupGlobalFunctions() throws XPathException {
        this.globalFunctionLibrary.fixupGlobalFunctions(this);
    }

    public void optimizeGlobalFunctions() throws XPathException {
        this.globalFunctionLibrary.optimizeGlobalFunctions();
    }

    public void explainGlobalFunctions(ExpressionPresenter out) {
        this.globalFunctionLibrary.explainGlobalFunctions(out);
    }

    public UserFunction getUserDefinedFunction(String uri, String localName, int arity) {
        return this.globalFunctionLibrary.getUserDefinedFunction(uri, localName, arity);
    }

    public void bindUnboundVariables() throws XPathException {
        for (UndeclaredVariable uv : this.undeclaredVariables.values()) {
            String uri;
            StructuredQName qName = uv.getVariableQName();
            VariableDeclaration var = this.variables.get(qName);
            if (var == null && this.importsNamespace(uri = qName.getNamespaceURI())) {
                QueryModule main = this.getTopLevelModule();
                var = main.libraryVariables.get(qName);
            }
            if (var == null) {
                XPathException err = new XPathException("Unresolved reference to variable $" + uv.getVariableQName().getDisplayName());
                err.setErrorCode("XPST0008");
                err.setIsStaticError(true);
                throw err;
            }
            GlobalVariableDefinition gvar = (GlobalVariableDefinition)var;
            this.checkImportedType(gvar.getRequiredType(), gvar);
            uv.transferReferences(var);
        }
    }

    public void addImportedSchema(String targetNamespace, String baseURI, List locationURIs) {
        HashSet<String> entries;
        if (this.importedSchemata == null) {
            this.importedSchemata = new HashSet(5);
        }
        this.importedSchemata.add(targetNamespace);
        HashMap<String, HashSet<String>> loadedSchemata = this.getTopLevelModule().loadedSchemata;
        if (loadedSchemata == null) {
            loadedSchemata = new HashMap(5);
            this.getTopLevelModule().loadedSchemata = loadedSchemata;
        }
        if ((entries = loadedSchemata.get(targetNamespace)) == null) {
            entries = new HashSet(locationURIs.size());
            loadedSchemata.put(targetNamespace, entries);
        }
        for (String relative : locationURIs) {
            try {
                URI abs = ResolveURI.makeAbsolute(relative, baseURI);
                entries.add(abs.toString());
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
    }

    public Map<String, HashSet<String>> getAllImportedSchemata() {
        return this.loadedSchemata;
    }

    @Override
    public boolean isImportedSchema(String namespace) {
        return this.importedSchemata != null && this.importedSchemata.contains(namespace);
    }

    @Override
    public Set getImportedSchemaNamespaces() {
        if (this.importedSchemata == null) {
            return Collections.EMPTY_SET;
        }
        return this.importedSchemata;
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            try {
                if (this.userQueryContext == null) {
                    this.config.getErrorListener().fatalError(err);
                } else {
                    this.userQueryContext.getErrorListener().fatalError(err);
                }
            }
            catch (TransformerException transformerException) {}
            err.setHasBeenReported(true);
        }
    }

    public void checkImportedFunctionSignature(XQueryFunction fd) throws XPathException {
        this.checkImportedType(fd.getResultType(), fd);
        int a = 0;
        while (a < fd.getNumberOfArguments()) {
            SequenceType argType = fd.getArgumentTypes()[a];
            this.checkImportedType(argType, fd);
            ++a;
        }
    }

    public void checkImportedType(SequenceType importedType, Declaration declaration) throws XPathException {
        ItemType type = importedType.getPrimaryType();
        if (type instanceof AnyItemType) {
            return;
        }
        if (type.isAtomicType()) {
            int f = ((AtomicType)type).getFingerprint();
            this.checkSchemaNamespaceImported(f, declaration);
        } else if (type instanceof ContentTypeTest) {
            SchemaType annotation = ((ContentTypeTest)type).getSchemaType();
            int f = annotation.getFingerprint();
            this.checkSchemaNamespaceImported(f, declaration);
        } else if (type instanceof CombinedNodeTest) {
            NodeTest[] tests = ((CombinedNodeTest)type).getComponentNodeTests();
            int i = 0;
            while (i < tests.length) {
                SequenceType st = SequenceType.makeSequenceType(tests[i], 16384);
                this.checkImportedType(st, declaration);
                ++i;
            }
        }
    }

    @Override
    public XPathContext makeEarlyEvaluationContext() {
        return new EarlyEvaluationContext(this.getConfiguration(), this.userQueryContext.getCollationMap());
    }

    @Override
    public StringCollator getCollation(String name) {
        if (name == null) {
            name = this.defaultCollationName;
        }
        return this.userQueryContext.getCollation(name);
    }

    @Override
    public String getDefaultCollationName() {
        return this.defaultCollationName;
    }

    public void setDefaultCollationName(String collation) {
        this.defaultCollationName = collation;
    }

    public void declarePrologNamespace(String prefix, String uri) throws XPathException {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declarePrologNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declarePrologNamespace()");
        }
        if (prefix.equals("xml") != uri.equals("http://www.w3.org/XML/1998/namespace")) {
            XPathException err = new XPathException("Invalid declaration of the XML namespace");
            err.setErrorCode("XQST0070");
            err.setIsStaticError(true);
            throw err;
        }
        if (this.explicitPrologNamespaces.get(prefix) != null) {
            XPathException err = new XPathException("Duplicate declaration of namespace prefix \"" + prefix + '\"');
            err.setErrorCode("XQST0033");
            err.setIsStaticError(true);
            throw err;
        }
        this.explicitPrologNamespaces.put(prefix, uri);
        this.getNamePool().allocateNamespaceCode(prefix, uri);
    }

    public void declareActiveNamespace(String prefix, String uri) {
        if (prefix == null) {
            throw new NullPointerException("Null prefix supplied to declareActiveNamespace()");
        }
        if (uri == null) {
            throw new NullPointerException("Null namespace URI supplied to declareActiveNamespace()");
        }
        int nscode = this.getNamePool().allocateNamespaceCode(prefix, uri);
        ActiveNamespace entry = new ActiveNamespace();
        entry.prefix = prefix;
        entry.uri = uri;
        entry.code = nscode;
        this.activeNamespaces.push(entry);
    }

    public void undeclareNamespace() {
        this.activeNamespaces.pop();
    }

    @Override
    public String getURIForPrefix(String prefix) throws XPathException {
        String uri = this.checkURIForPrefix(prefix);
        if (uri == null) {
            XPathException err = new XPathException("Prefix " + prefix + " has not been declared");
            err.setErrorCode("XPST0081");
            err.setIsStaticError(true);
            throw err;
        }
        return uri;
    }

    public String checkURIForPrefix(String prefix) {
        if (this.activeNamespaces != null) {
            int i = this.activeNamespaces.size() - 1;
            while (i >= 0) {
                if (((ActiveNamespace)this.activeNamespaces.get((int)i)).prefix.equals(prefix)) {
                    return ((ActiveNamespace)this.activeNamespaces.get((int)i)).uri;
                }
                --i;
            }
        }
        if (prefix.length() == 0) {
            return this.defaultElementNamespace;
        }
        String uri = this.explicitPrologNamespaces.get(prefix);
        if (uri != null) {
            return uri.length() == 0 ? null : uri;
        }
        if (this.userQueryContext != null) {
            uri = this.userQueryContext.getNamespaceForPrefix(prefix);
            if (uri != null) {
                return uri;
            }
            NamespaceResolver externalResolver = this.userQueryContext.getExternalNamespaceResolver();
            if (externalResolver != null) {
                return externalResolver.getURIForPrefix(prefix, true);
            }
        }
        return null;
    }

    @Override
    public String getDefaultElementNamespace() {
        return this.checkURIForPrefix("");
    }

    public void setDefaultElementNamespace(String uri) {
        this.defaultElementNamespace = uri;
    }

    @Override
    public String getDefaultFunctionNamespace() {
        return this.defaultFunctionNamespace;
    }

    public void setDefaultFunctionNamespace(String uri) {
        this.defaultFunctionNamespace = uri;
    }

    public void setRevalidationMode(int mode) {
        if (mode != 1 && mode != 2 && mode != 4) {
            throw new IllegalArgumentException("Invalid mode " + mode);
        }
        this.revalidationMode = mode;
    }

    public int getRevalidationMode() {
        return this.revalidationMode;
    }

    public int[] getActiveNamespaceCodes() {
        if (this.activeNamespaces == null) {
            return IntArraySet.EMPTY_INT_ARRAY;
        }
        int[] nscodes = new int[this.activeNamespaces.size()];
        int used = 0;
        HashSet<String> prefixes = new HashSet<String>(10);
        int n = this.activeNamespaces.size() - 1;
        while (n >= 0) {
            ActiveNamespace an = (ActiveNamespace)this.activeNamespaces.get(n);
            if (!prefixes.contains(an.prefix)) {
                prefixes.add(an.prefix);
                nscodes[used++] = an.code;
            }
            --n;
        }
        if (used < nscodes.length) {
            int[] nscodes2 = new int[used];
            System.arraycopy(nscodes, 0, nscodes2, 0, used);
            nscodes = nscodes2;
        }
        return nscodes;
    }

    @Override
    public NamespaceResolver getNamespaceResolver() {
        String uri;
        ArrayList<Integer> externalNamespaceCodes = null;
        NamespaceResolver externalResolver = this.userQueryContext.getExternalNamespaceResolver();
        if (externalResolver != null) {
            externalNamespaceCodes = new ArrayList<Integer>();
            Iterator<String> iter = externalResolver.iteratePrefixes();
            while (iter.hasNext()) {
                String prefix = iter.next();
                String uri2 = externalResolver.getURIForPrefix(prefix, true);
                int nscode = this.getNamePool().allocateNamespaceCode(prefix, uri2);
                externalNamespaceCodes.add(new Integer(nscode));
            }
        }
        HashMap<String, String> userDeclaredNamespaces = this.userQueryContext.getUserDeclaredNamespaces();
        int[] active = this.getActiveNamespaceCodes();
        int[] nscodes = new int[this.explicitPrologNamespaces.size() + userDeclaredNamespaces.size() + active.length + (externalNamespaceCodes == null ? 0 : externalNamespaceCodes.size())];
        int used = 0;
        NamePool namePool = this.getNamePool();
        for (String prefix : userDeclaredNamespaces.keySet()) {
            uri = userDeclaredNamespaces.get(prefix);
            nscodes[used++] = namePool.getNamespaceCode(prefix, uri);
        }
        for (String prefix : this.explicitPrologNamespaces.keySet()) {
            uri = this.explicitPrologNamespaces.get(prefix);
            nscodes[used++] = namePool.getNamespaceCode(prefix, uri);
        }
        int a = 0;
        while (a < active.length) {
            nscodes[used++] = active[a];
            ++a;
        }
        if (externalNamespaceCodes != null) {
            a = 0;
            while (a < externalNamespaceCodes.size()) {
                nscodes[used++] = (Integer)externalNamespaceCodes.get(a);
                ++a;
            }
        }
        return new SavedNamespaceContext(nscodes, namePool);
    }

    @Override
    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    @Override
    public void issueWarning(String s, SourceLocator locator) {
        XPathException err = new XPathException(s);
        err.setLocator(locator);
        try {
            this.getConfiguration().getErrorListener().warning(err);
        }
        catch (TransformerException transformerException) {}
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public boolean isInBackwardsCompatibleMode() {
        return false;
    }

    @Override
    public boolean isAllowedBuiltInType(BuiltInAtomicType type) {
        return type.getFingerprint() != 565 || this.config.getXsdVersion() == Configuration.XSD11;
    }

    public void setUpdating(boolean updating) {
        this.isUpdating = updating;
    }

    public boolean isUpdating() {
        return this.isUpdating;
    }

    public String getLanguageVersion() {
        return this.languageVersion;
    }

    private void checkSchemaNamespaceImported(int fingerprint, Declaration declaration) throws XPathException {
        String uri = this.getNamePool().getURI(fingerprint);
        if (!(uri.equals("http://www.w3.org/2001/XMLSchema") || uri.equals("http://ns.saxonica.com/anonymous-type") || uri.equals("http://saxon.sf.net/java-type") || this.isImportedSchema(uri))) {
            String msg = "Schema component " + this.getNamePool().getDisplayName(fingerprint) + " used in ";
            msg = declaration instanceof GlobalVariableDefinition ? String.valueOf(msg) + "declaration of imported variable " + ((GlobalVariableDefinition)declaration).getVariableQName().getDisplayName() : String.valueOf(msg) + "signature of imported function " + ((XQueryFunction)declaration).getDisplayName();
            msg = String.valueOf(msg) + " is not declared in any schema imported by ";
            String module = this.getModuleNamespace();
            msg = module == null ? String.valueOf(msg) + "the main query module" : String.valueOf(msg) + "query module " + module;
            XPathException err = new XPathException(msg);
            err.setErrorCode("XQST0036");
            err.setIsStaticError(true);
            err.setLocator(declaration);
            throw err;
        }
    }

    private static class ActiveNamespace {
        public String prefix;
        public String uri;
        public int code;

        private ActiveNamespace() {
        }
    }
}

