/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SaxonApiUncheckedException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class XPathSelector
implements Iterable<XdmItem> {
    private XPathExpression exp;
    private XPathDynamicContext dynamicContext;
    private List<XPathVariable> declaredVariables;

    protected XPathSelector(XPathExpression exp, ArrayList<XPathVariable> declaredVariables) {
        this.exp = exp;
        this.declaredVariables = declaredVariables;
        this.dynamicContext = exp.createDynamicContext(null);
    }

    public void setContextItem(XdmItem item) throws SaxonApiException {
        try {
            this.dynamicContext.setContextItem((Item)item.getUnderlyingValue());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmItem getContextItem() {
        return XdmItem.wrapItem(this.dynamicContext.getContextItem());
    }

    public void setVariable(QName name, XdmValue value) throws SaxonApiException {
        XPathVariable var = null;
        StructuredQName qn = name.getStructuredQName();
        for (XPathVariable v : this.declaredVariables) {
            if (!v.getVariableQName().equals(qn)) continue;
            var = v;
            break;
        }
        if (var == null) {
            throw new SaxonApiException(new XPathException("Variable has not been declared: " + name));
        }
        try {
            this.dynamicContext.setVariable(var, value.getUnderlyingValue());
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }

    public XdmValue evaluate() throws SaxonApiException {
        ValueRepresentation value;
        try {
            value = SequenceExtent.makeSequenceExtent(this.exp.iterate(this.dynamicContext));
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
        return XdmValue.wrap(value);
    }

    public XdmItem evaluateSingle() throws SaxonApiException {
        Item i;
        block3: {
            try {
                i = this.exp.evaluateSingle(this.dynamicContext);
                if (i != null) break block3;
                return null;
            }
            catch (XPathException e) {
                throw new SaxonApiException(e);
            }
        }
        return (XdmItem)XdmValue.wrap(i);
    }

    @Override
    public Iterator<XdmItem> iterator() throws SaxonApiUncheckedException {
        try {
            return new XdmSequenceIterator(this.exp.iterate(this.dynamicContext));
        }
        catch (XPathException e) {
            throw new SaxonApiUncheckedException(e);
        }
    }

    public boolean effectiveBooleanValue() throws SaxonApiException {
        try {
            return this.exp.effectiveBooleanValue(this.dynamicContext);
        }
        catch (XPathException e) {
            throw new SaxonApiException(e);
        }
    }
}

