/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.AugmentedSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.IDFilter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.style.XSLInclude;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.DocumentImpl;
import net.sf.saxon.tree.ElementImpl;
import net.sf.saxon.value.Whitespace;

public abstract class XSLGeneralIncorporate
extends StyleElement {
    String href;
    DocumentImpl includedDoc;

    public abstract boolean isImport();

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("href")) {
                this.href = Whitespace.trim(atts.getValue(a));
            } else {
                this.checkUnknownAttribute(nc);
            }
            ++a;
        }
        if (this.href == null) {
            this.reportAbsence("href");
        }
    }

    @Override
    public void validate() throws XPathException {
        this.checkEmpty();
        this.checkTopLevel(this.isImport() ? "XTSE0190" : "XTSE0170");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XSLStylesheet getIncludedStylesheet(XSLStylesheet importer, int precedence) throws XPathException {
        if (this.href == null) {
            return null;
        }
        this.checkEmpty();
        this.checkTopLevel(this instanceof XSLInclude ? "XTSE0170" : "XTSE0190");
        try {
            Source source;
            XSLStylesheet thisSheet = (XSLStylesheet)this.getParent();
            PreparedStylesheet pss = this.getPreparedStylesheet();
            URIResolver resolver = pss.getCompilerInfo().getURIResolver();
            Configuration config = pss.getConfiguration();
            String relative = this.href;
            String fragment = null;
            int hash = relative.indexOf(35);
            if (hash == 0 || relative.length() == 0) {
                this.compileError("A stylesheet cannot " + this.getLocalPart() + " itself", this instanceof XSLInclude ? "XTSE0180" : "XTSE0210");
                return null;
            }
            if (hash == relative.length() - 1) {
                relative = relative.substring(0, hash);
            } else if (hash > 0) {
                if (hash + 1 < relative.length()) {
                    fragment = relative.substring(hash + 1);
                }
                relative = relative.substring(0, hash);
            }
            try {
                source = resolver.resolve(relative, this.getBaseURI());
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
            if (source == null) {
                source = config.getSystemURIResolver().resolve(relative, this.getBaseURI());
            }
            if (fragment != null) {
                IDFilter filter = new IDFilter(fragment);
                source = AugmentedSource.makeAugmentedSource(source);
                ((AugmentedSource)source).addFilter(filter);
            }
            XSLStylesheet anc = thisSheet;
            if (source.getSystemId() != null) {
                while (anc != null) {
                    if (source.getSystemId().equals(anc.getSystemId())) {
                        this.compileError("A stylesheet cannot " + this.getLocalPart() + " itself", this instanceof XSLInclude ? "XTSE0180" : "XTSE0210");
                        return null;
                    }
                    anc = anc.getImporter();
                }
            }
            StyleNodeFactory snFactory = config.getStyleNodeFactory();
            this.includedDoc = pss.loadStylesheetModule(source, snFactory);
            ElementImpl outermost = this.includedDoc.getDocumentElement();
            if (outermost instanceof LiteralResultElement) {
                this.includedDoc = ((LiteralResultElement)outermost).makeStylesheet(this.getPreparedStylesheet(), snFactory);
                outermost = this.includedDoc.getDocumentElement();
            }
            if (!(outermost instanceof XSLStylesheet)) {
                this.compileError("Included document " + this.href + " is not a stylesheet", "XTSE0165");
                return null;
            }
            XSLStylesheet incSheet = (XSLStylesheet)outermost;
            incSheet.validate();
            if (incSheet.validationError != null) {
                if (this.reportingCircumstances == 1) {
                    incSheet.compileError(incSheet.validationError);
                } else if (incSheet.reportingCircumstances == 2) {
                    incSheet.compileError(incSheet.validationError);
                }
            }
            incSheet.setPrecedence(precedence);
            incSheet.setImporter(importer);
            incSheet.spliceIncludes();
            thisSheet.setInputTypeAnnotations(incSheet.getInputTypeAnnotationsAttribute() | incSheet.getInputTypeAnnotations());
            return incSheet;
        }
        catch (XPathException err) {
            err.setErrorCode("XTSE0165");
            err.setIsStaticError(true);
            this.compileError(err);
            return null;
        }
    }

    @Override
    public Expression compile(Executable exec) throws XPathException {
        return null;
    }
}

