/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.saxon.event.SaxonOutputKeys;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class XSLOutput
extends StyleElement {
    private StructuredQName outputFormatName;
    private String method = null;
    private String version = null;
    private String indent = null;
    private String encoding = null;
    private String mediaType = null;
    private String doctypeSystem = null;
    private String doctypePublic = null;
    private String omitDeclaration = null;
    private String standalone = null;
    private String cdataElements = null;
    private String includeContentType = null;
    private String nextInChain = null;
    private String suppressIndentation = null;
    private String doubleSpace = null;
    private String representation = null;
    private String indentSpaces = null;
    private String byteOrderMark = null;
    private String escapeURIAttributes = null;
    private String normalizationForm = null;
    private String recognizeBinary = null;
    private String requireWellFormed = null;
    private String undeclareNamespaces = null;
    private String useCharacterMaps = null;
    private HashMap<String, String> userAttributes = null;

    @Override
    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String nameAtt = null;
        int a = 0;
        while (a < atts.getLength()) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("name")) {
                nameAtt = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("method")) {
                this.method = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("version")) {
                this.version = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("byte-order-mark")) {
                this.byteOrderMark = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("encoding")) {
                this.encoding = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("omit-xml-declaration")) {
                this.omitDeclaration = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("standalone")) {
                this.standalone = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("doctype-public")) {
                this.doctypePublic = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("doctype-system")) {
                this.doctypeSystem = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("cdata-section-elements")) {
                this.cdataElements = atts.getValue(a);
            } else if (f.equals("indent")) {
                this.indent = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("media-type")) {
                this.mediaType = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("include-content-type")) {
                this.includeContentType = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("normalization-form")) {
                this.normalizationForm = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("escape-uri-attributes")) {
                this.escapeURIAttributes = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("use-character-maps")) {
                this.useCharacterMaps = atts.getValue(a);
            } else if (f.equals("undeclare-prefixes")) {
                this.undeclareNamespaces = atts.getValue(a);
            } else if (f.equals("{http://saxon.sf.net/}character-representation")) {
                this.representation = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("{http://saxon.sf.net/}indent-spaces")) {
                this.indentSpaces = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("{http://saxon.sf.net/}suppress-indentation")) {
                this.suppressIndentation = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("{http://saxon.sf.net/}double-space")) {
                this.doubleSpace = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("{http://saxon.sf.net/}next-in-chain")) {
                this.nextInChain = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("{http://saxon.sf.net/}recognize-binary")) {
                this.recognizeBinary = Whitespace.trim(atts.getValue(a));
            } else if (f.equals("{http://saxon.sf.net/}require-well-formed")) {
                this.requireWellFormed = Whitespace.trim(atts.getValue(a));
            } else {
                String attributeURI = this.getNamePool().getURI(nc);
                if ("".equals(attributeURI) || "http://www.w3.org/1999/XSL/Transform".equals(attributeURI) || "http://saxon.sf.net/".equals(attributeURI)) {
                    this.checkUnknownAttribute(nc);
                } else {
                    String name = String.valueOf('{') + attributeURI + '}' + atts.getLocalName(a);
                    if (this.userAttributes == null) {
                        this.userAttributes = new HashMap(5);
                    }
                    this.userAttributes.put(name, atts.getValue(a));
                }
            }
            ++a;
        }
        if (nameAtt != null) {
            try {
                this.outputFormatName = this.makeQName(nameAtt);
            }
            catch (NamespaceException err) {
                this.compileError(err.getMessage(), "XTSE1570");
            }
            catch (XPathException err) {
                this.compileError(err.getMessage(), "XTSE1570");
            }
        }
    }

    public StructuredQName getFormatQName() {
        return this.outputFormatName;
    }

    @Override
    public void validate() throws XPathException {
        this.checkTopLevel(null);
        this.checkEmpty();
    }

    @Override
    public Expression compile(Executable exec) {
        return null;
    }

    protected void gatherOutputProperties(Properties details, HashMap precedences) throws XPathException {
        String s;
        String existing;
        if (this.method != null) {
            if (this.method.equals("xml") || this.method.equals("html") || this.method.equals("text") || this.method.equals("xhtml")) {
                this.checkAndPut("method", this.method, details, precedences);
            } else {
                try {
                    String[] parts = this.getConfiguration().getNameChecker().getQNameParts(this.method);
                    String prefix = parts[0];
                    if (prefix.length() == 0) {
                        this.compileError("method must be xml, html, xhtml, or text, or a prefixed name", "XTSE1570");
                    } else {
                        String uri = this.getURIForPrefix(prefix, false);
                        if (uri == null) {
                            this.undeclaredNamespaceError(prefix, "XTSE0280");
                        }
                        this.checkAndPut("method", String.valueOf('{') + uri + '}' + parts[1], details, precedences);
                    }
                }
                catch (QNameException e) {
                    this.compileError("Invalid method name. " + e.getMessage(), "XTSE1570");
                }
            }
        }
        if (this.byteOrderMark != null) {
            this.checkAndPut("byte-order-mark", this.byteOrderMark, details, precedences);
        }
        if (this.version != null) {
            this.checkAndPut("version", this.version, details, precedences);
        }
        if (this.indent != null) {
            this.checkAndPut("indent", this.indent, details, precedences);
        }
        if (this.indentSpaces != null) {
            this.checkAndPut("{http://saxon.sf.net/}indent-spaces", this.indentSpaces, details, precedences);
        }
        if (this.suppressIndentation != null) {
            existing = details.getProperty("{http://saxon.sf.net/}suppress-indentation");
            if (existing == null) {
                existing = "";
            }
            s = SaxonOutputKeys.parseListOfElementNames(this.suppressIndentation, this, false, this.getConfiguration().getNameChecker(), "XTSE0280");
            details.setProperty("{http://saxon.sf.net/}suppress-indentation", String.valueOf(existing) + s);
        }
        if (this.doubleSpace != null) {
            existing = details.getProperty("{http://saxon.sf.net/}double-space");
            if (existing == null) {
                existing = "";
            }
            s = SaxonOutputKeys.parseListOfElementNames(this.doubleSpace, this, false, this.getConfiguration().getNameChecker(), "XTSE0280");
            details.setProperty("{http://saxon.sf.net/}double-space", String.valueOf(existing) + s);
        }
        if (this.encoding != null) {
            this.checkAndPut("encoding", this.encoding, details, precedences);
        }
        if (this.mediaType != null) {
            this.checkAndPut("media-type", this.mediaType, details, precedences);
        }
        if (this.doctypeSystem != null) {
            this.checkAndPut("doctype-system", this.doctypeSystem, details, precedences);
        }
        if (this.doctypePublic != null) {
            this.checkAndPut("doctype-public", this.doctypePublic, details, precedences);
        }
        if (this.omitDeclaration != null) {
            this.checkAndPut("omit-xml-declaration", this.omitDeclaration, details, precedences);
        }
        if (this.standalone != null) {
            this.checkAndPut("standalone", this.standalone, details, precedences);
        }
        if (this.cdataElements != null) {
            existing = details.getProperty("cdata-section-elements");
            if (existing == null) {
                existing = "";
            }
            s = SaxonOutputKeys.parseListOfElementNames(this.cdataElements, this, false, this.getConfiguration().getNameChecker(), "XTSE0280");
            details.setProperty("cdata-section-elements", String.valueOf(existing) + s);
        }
        if (this.normalizationForm != null && !this.normalizationForm.equals("none")) {
            this.checkAndPut("normalization-form", this.normalizationForm, details, precedences);
        }
        if (this.undeclareNamespaces != null) {
            this.checkAndPut("undeclare-prefixes", this.undeclareNamespaces, details, precedences);
        }
        if (this.useCharacterMaps != null) {
            String s2 = XSLOutput.prepareCharacterMaps(this, this.useCharacterMaps, details);
            details.setProperty("use-character-maps", s2);
        }
        if (this.representation != null) {
            this.checkAndPut("{http://saxon.sf.net/}character-representation", this.representation, details, precedences);
        }
        if (this.includeContentType != null) {
            this.checkAndPut("include-content-type", this.includeContentType, details, precedences);
        }
        if (this.escapeURIAttributes != null) {
            this.checkAndPut("escape-uri-attributes", this.escapeURIAttributes, details, precedences);
        }
        if (this.nextInChain != null) {
            this.checkAndPut("{http://saxon.sf.net/}next-in-chain", this.nextInChain, details, precedences);
            this.checkAndPut("{http://saxon.sf.net/}next-in-chain-base-uri", this.getSystemId(), details, precedences);
        }
        if (this.recognizeBinary != null) {
            this.checkAndPut("{http://saxon.sf.net/}recognize-binary", this.recognizeBinary, details, precedences);
        }
        if (this.requireWellFormed != null) {
            this.checkAndPut("{http://saxon.sf.net/}require-well-formed", this.requireWellFormed, details, precedences);
        }
        if (this.userAttributes != null) {
            for (String attName : this.userAttributes.keySet()) {
                String data = this.userAttributes.get(attName);
                details.setProperty(attName, data);
            }
        }
    }

    private void checkAndPut(String property, String value, Properties props, HashMap precedences) throws XPathException {
        try {
            SaxonOutputKeys.checkOutputProperty(property, value, this.getConfiguration());
        }
        catch (XPathException err) {
            this.compileError(err.getMessage(), "XTSE0020");
            return;
        }
        String old = props.getProperty(property);
        if (old == null) {
            props.setProperty(property, value);
            precedences.put(property, new Integer(this.getPrecedence()));
        } else if (!old.equals(value)) {
            Integer oldPrec = (Integer)precedences.get(property);
            if (oldPrec == null) {
                return;
            }
            int op = oldPrec;
            if (op <= this.getPrecedence()) {
                if (op == this.getPrecedence()) {
                    this.compileError("Conflicting values for output property " + property, "XTSE1560");
                } else {
                    throw new IllegalStateException("Output properties must be processed in decreasing precedence order");
                }
            }
        }
    }

    public static String prepareCharacterMaps(StyleElement element, String useCharacterMaps, Properties details) throws XPathException {
        XSLStylesheet principal = element.getPrincipalStylesheet();
        String existing = details.getProperty("use-character-maps");
        if (existing == null) {
            existing = "";
        }
        String s = "";
        StringTokenizer st = new StringTokenizer(useCharacterMaps, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            String displayname = st.nextToken();
            try {
                StructuredQName qName = element.makeQName(displayname);
                XSLCharacterMap ref = principal.getCharacterMap(qName);
                if (ref == null) {
                    element.compileError("No character-map named '" + displayname + "' has been defined", "XTSE1590");
                }
                s = String.valueOf(s) + " " + qName.getClarkName();
            }
            catch (NamespaceException err) {
                element.undeclaredNamespaceError(err.getPrefix(), "XTSE0280");
            }
        }
        existing = String.valueOf(s) + existing;
        return existing;
    }
}

