/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.tinytree.TinyTree;

public class TinyAttributeCollection
implements AttributeCollection {
    int element;
    TinyTree tree;
    int firstAttribute;

    public TinyAttributeCollection(TinyTree tree, int element) {
        this.tree = tree;
        this.element = element;
        this.firstAttribute = tree.alpha[element];
    }

    public void setLocationProvider(LocationProvider provider) {
    }

    @Override
    public int getLength() {
        int i = this.firstAttribute;
        while (i < this.tree.numberOfAttributes && this.tree.attParent[i] == this.element) {
            ++i;
        }
        return i - this.firstAttribute;
    }

    @Override
    public int getNameCode(int index) {
        return this.tree.attCode[this.firstAttribute + index];
    }

    @Override
    public int getTypeAnnotation(int index) {
        if (this.tree.attTypeCode == null) {
            return 631;
        }
        return this.tree.attTypeCode[this.firstAttribute + index];
    }

    @Override
    public int getLocationId(int index) {
        return 0;
    }

    @Override
    public String getSystemId(int index) {
        return this.tree.getSystemId(this.element);
    }

    @Override
    public int getLineNumber(int index) {
        return -1;
    }

    @Override
    public int getProperties(int index) {
        return 0;
    }

    @Override
    public String getPrefix(int index) {
        return this.tree.getNamePool().getPrefix(this.getNameCode(index));
    }

    @Override
    public String getQName(int index) {
        return this.tree.getNamePool().getDisplayName(this.getNameCode(index));
    }

    @Override
    public String getLocalName(int index) {
        return this.tree.getNamePool().getLocalName(this.getNameCode(index));
    }

    @Override
    public String getURI(int index) {
        return this.tree.getNamePool().getURI(this.getNameCode(index));
    }

    @Override
    public int getIndex(String uri, String localname) {
        int fingerprint = this.tree.getNamePool().getFingerprint(uri, localname);
        return this.getIndexByFingerprint(fingerprint);
    }

    @Override
    public int getIndexByFingerprint(int fingerprint) {
        int i = this.firstAttribute;
        while (this.tree.attParent[i] == this.element) {
            if ((this.tree.attCode[i] & 0xFFFFF) == fingerprint) {
                return i - this.firstAttribute;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public String getValueByFingerprint(int fingerprint) {
        return this.getValue(this.getIndexByFingerprint(fingerprint));
    }

    @Override
    public String getValue(String uri, String localname) {
        return this.getValue(this.getIndex(uri, localname));
    }

    @Override
    public String getValue(int index) {
        CharSequence cs = this.tree.attValue[this.firstAttribute + index];
        return cs == null ? null : cs.toString();
    }

    @Override
    public boolean isId(int index) {
        return (this.getTypeAnnotation(index) & 0xFFFFF) == 560 || (this.getNameCode(index) & 0xFFFFF) == 388;
    }

    @Override
    public boolean isIdref(int index) {
        return (this.getTypeAnnotation(index) & 0xFFFFF) == 561 || (this.getTypeAnnotation(index) & 0xFFFFF) == 562;
    }
}

