/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Collections;
import java.util.Iterator;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeArrayIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class TextFragmentValue
implements DocumentInfo,
FingerprintedNode,
SourceLocator {
    private CharSequence text;
    private String baseURI;
    private String documentURI;
    private TextFragmentTextNode textNode = null;
    private Configuration config;
    private long documentNumber;

    public TextFragmentValue(CharSequence value, String baseURI) {
        this.text = value;
        this.baseURI = baseURI;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = -1L;
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    @Override
    public long getDocumentNumber() {
        if (this.documentNumber == -1L) {
            this.documentNumber = this.config.getDocumentNumberAllocator().allocateDocumentNumber();
        }
        return this.documentNumber;
    }

    @Override
    public final int getNodeKind() {
        return 9;
    }

    @Override
    public String getStringValue() {
        return this.text.toString();
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.text;
    }

    @Override
    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        buffer.append("tt");
        buffer.append(Long.toString(this.getDocumentNumber()));
    }

    @Override
    public void setSystemId(String systemId) {
        this.documentURI = systemId;
    }

    @Override
    public String getSystemId() {
        return this.documentURI;
    }

    @Override
    public String getBaseURI() {
        return this.baseURI;
    }

    @Override
    public int compareOrder(NodeInfo other) {
        if (this == other) {
            return 0;
        }
        return -1;
    }

    @Override
    public int getNameCode() {
        return -1;
    }

    @Override
    public int getFingerprint() {
        return -1;
    }

    @Override
    public String getPrefix() {
        return "";
    }

    @Override
    public String getURI() {
        return "";
    }

    @Override
    public String getDisplayName() {
        return "";
    }

    @Override
    public String getLocalPart() {
        return "";
    }

    @Override
    public boolean hasChildNodes() {
        return !"".equals(this.text);
    }

    @Override
    public int getLineNumber() {
        return -1;
    }

    @Override
    public int getTypeAnnotation() {
        return 630;
    }

    @Override
    public int[] getDeclaredNamespaces(int[] buffer) {
        return null;
    }

    @Override
    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator(new UntypedAtomicValue(this.text));
    }

    @Override
    public Value atomize() {
        return new UntypedAtomicValue(this.text);
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return -1;
    }

    @Override
    public String getAttributeValue(int fingerprint) {
        return null;
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber) {
        switch (axisNumber) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
            case 1: 
            case 12: {
                return SingleNodeIterator.makeIterator(this);
            }
            case 3: 
            case 4: {
                return SingleNodeIterator.makeIterator(this.getTextNode());
            }
            case 5: {
                NodeInfo[] nodes = new NodeInfo[]{this, this.getTextNode()};
                return new NodeArrayIterator(nodes);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
            case 1: 
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 3: 
            case 4: {
                return Navigator.filteredSingleton(this.getTextNode(), nodeTest);
            }
            case 5: {
                boolean b1 = nodeTest.matches(this);
                TextFragmentTextNode textNode2 = this.getTextNode();
                boolean b2 = nodeTest.matches(textNode2);
                if (b1) {
                    if (b2) {
                        NodeInfo[] pair = new NodeInfo[]{this, textNode2};
                        return new NodeArrayIterator(pair);
                    }
                    return SingleNodeIterator.makeIterator(this);
                }
                if (b2) {
                    return SingleNodeIterator.makeIterator(textNode2);
                }
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    @Override
    public NodeInfo getParent() {
        return null;
    }

    @Override
    public NodeInfo getRoot() {
        return this;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this;
    }

    @Override
    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        out.characters(this.text, 0, 0);
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        return null;
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        return null;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public boolean isIdref() {
        return false;
    }

    @Override
    public boolean isNilled() {
        return false;
    }

    private TextFragmentTextNode getTextNode() {
        if (this.textNode == null) {
            this.textNode = new TextFragmentTextNode();
        }
        return this.textNode;
    }

    private class TextFragmentTextNode
    implements NodeInfo,
    FingerprintedNode,
    SourceLocator {
        private TextFragmentTextNode() {
        }

        @Override
        public void setSystemId(String systemId) {
        }

        @Override
        public Configuration getConfiguration() {
            return TextFragmentValue.this.config;
        }

        @Override
        public NamePool getNamePool() {
            return TextFragmentValue.this.config.getNamePool();
        }

        @Override
        public final int getNodeKind() {
            return 3;
        }

        @Override
        public String getStringValue() {
            return TextFragmentValue.this.text.toString();
        }

        @Override
        public CharSequence getStringValueCS() {
            return TextFragmentValue.this.text;
        }

        @Override
        public boolean isSameNodeInfo(NodeInfo other) {
            return this == other;
        }

        @Override
        public void generateId(FastStringBuffer buffer) {
            buffer.append("tt");
            buffer.append(Long.toString(this.getDocumentNumber()));
            buffer.append("t1");
        }

        @Override
        public String getSystemId() {
            return null;
        }

        @Override
        public String getBaseURI() {
            return TextFragmentValue.this.baseURI;
        }

        @Override
        public int compareOrder(NodeInfo other) {
            if (this == other) {
                return 0;
            }
            return 1;
        }

        @Override
        public int getNameCode() {
            return -1;
        }

        @Override
        public int getFingerprint() {
            return -1;
        }

        @Override
        public String getPrefix() {
            return "";
        }

        @Override
        public String getURI() {
            return "";
        }

        @Override
        public String getDisplayName() {
            return "";
        }

        @Override
        public String getLocalPart() {
            return "";
        }

        @Override
        public boolean hasChildNodes() {
            return false;
        }

        @Override
        public String getAttributeValue(int fingerprint) {
            return null;
        }

        @Override
        public int getLineNumber() {
            return -1;
        }

        @Override
        public int getTypeAnnotation() {
            return -1;
        }

        @Override
        public long getDocumentNumber() {
            return this.getDocumentRoot().getDocumentNumber();
        }

        @Override
        public int[] getDeclaredNamespaces(int[] buffer) {
            return null;
        }

        @Override
        public SequenceIterator getTypedValue() throws XPathException {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(TextFragmentValue.this.text));
        }

        @Override
        public Value atomize() throws XPathException {
            return new UntypedAtomicValue(TextFragmentValue.this.text);
        }

        @Override
        public String getPublicId() {
            return null;
        }

        @Override
        public int getColumnNumber() {
            return -1;
        }

        @Override
        public AxisIterator iterateAxis(byte axisNumber) {
            switch (axisNumber) {
                case 0: 
                case 9: 
                case 13: {
                    return SingleNodeIterator.makeIterator(TextFragmentValue.this);
                }
                case 1: {
                    NodeInfo[] nodes = new NodeInfo[]{this, TextFragmentValue.this};
                    return new NodeArrayIterator(nodes);
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 5: 
                case 12: {
                    return SingleNodeIterator.makeIterator(this);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + axisNumber);
        }

        @Override
        public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
            switch (axisNumber) {
                case 0: 
                case 9: 
                case 13: {
                    return Navigator.filteredSingleton(TextFragmentValue.this, nodeTest);
                }
                case 1: {
                    boolean matchesDoc = nodeTest.matches(TextFragmentValue.this);
                    boolean matchesText = nodeTest.matches(this);
                    if (matchesDoc && matchesText) {
                        NodeInfo[] nodes = new NodeInfo[]{this, TextFragmentValue.this};
                        return new NodeArrayIterator(nodes);
                    }
                    if (matchesDoc && !matchesText) {
                        return SingleNodeIterator.makeIterator(TextFragmentValue.this);
                    }
                    if (matchesText && !matchesDoc) {
                        return SingleNodeIterator.makeIterator(this);
                    }
                    return EmptyIterator.getInstance();
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 5: 
                case 12: {
                    return Navigator.filteredSingleton(this, nodeTest);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + axisNumber);
        }

        @Override
        public NodeInfo getParent() {
            return TextFragmentValue.this;
        }

        @Override
        public NodeInfo getRoot() {
            return TextFragmentValue.this;
        }

        @Override
        public DocumentInfo getDocumentRoot() {
            return TextFragmentValue.this;
        }

        @Override
        public void copy(Receiver out, int namespaces, boolean copyAnnotations, int locationId) throws XPathException {
            out.characters(TextFragmentValue.this.text, 0, 0);
        }

        @Override
        public boolean isId() {
            return false;
        }

        @Override
        public boolean isIdref() {
            return false;
        }

        @Override
        public boolean isNilled() {
            return false;
        }
    }
}

