/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.ArrayList;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Value;

public class XPathFunctionCall
extends FunctionCall {
    private XPathFunction function;

    public XPathFunctionCall(XPathFunction function) {
        this.function = function;
    }

    @Override
    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    @Override
    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        ValueRepresentation[] argValues = new ValueRepresentation[this.argument.length];
        int i = 0;
        while (i < argValues.length) {
            argValues[i] = ExpressionTool.lazyEvaluate(this.argument[i], context, 10);
            ++i;
        }
        return this.call(argValues, context);
    }

    protected SequenceIterator call(ValueRepresentation[] argValues, XPathContext context) throws XPathException {
        ArrayList convertedArgs = new ArrayList(argValues.length);
        Configuration config = context.getConfiguration();
        int i = 0;
        while (i < argValues.length) {
            Item item;
            ArrayList<Object> target = new ArrayList<Object>();
            SequenceIterator iter = Value.asIterator(argValues[i]);
            while ((item = iter.next()) != null) {
                PJConverter converter = PJConverter.allocate(config, Value.asValue(item).getItemType(config.getTypeHierarchy()), 16384, Object.class);
                target.add(converter.convert(item, Object.class, context));
            }
            if (target.size() == 1) {
                convertedArgs.add(target.get(0));
            } else {
                convertedArgs.add(target);
            }
            ++i;
        }
        try {
            Object result = this.function.evaluate(convertedArgs);
            if (result == null) {
                return EmptyIterator.getInstance();
            }
            JPConverter converter = JPConverter.allocate(result.getClass(), config);
            return Value.asIterator(converter.convert(result, context));
        }
        catch (XPathFunctionException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return Type.ITEM_TYPE;
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }
}

