/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.io.PrintWriter;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQDataSource;
import javax.xml.xquery.XQException;
import net.sf.saxon.Configuration;
import net.sf.saxon.functions.ExtensionFunctionDefinition;
import net.sf.saxon.om.Validation;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xqj.SaxonXQConnection;

public class SaxonXQDataSource
implements XQDataSource {
    private Configuration config;
    private PrintWriter logger;
    private static String[] supportedPropertyNames = new String[]{"allowExternalFunctions", "dtdValidation", "expandAttributeDefaults", "expandXInclude", "retainLineNumbers", "schemaValidationMode", "stripWhitespace", "useXsiSchemaLocation", "xmlVersion", "xsdVersion"};

    public SaxonXQDataSource() {
        this.config = Configuration.newConfiguration();
        this.config.setProcessor(this);
    }

    public SaxonXQDataSource(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public XQConnection getConnection() throws XQException {
        return new SaxonXQConnection(this);
    }

    @Override
    public XQConnection getConnection(Connection con) throws XQException {
        throw new XQException("Saxon cannot connect to a SQL data source");
    }

    @Override
    public XQConnection getConnection(String username, String password) throws XQException {
        return this.getConnection();
    }

    @Override
    public int getLoginTimeout() {
        return 0;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logger;
    }

    @Override
    public String getProperty(String name) throws XQException {
        if ("allowExternalFunctions".equals(name)) {
            return this.getAllowExternalFunctions();
        }
        if ("dtdValidation".equals(name)) {
            return this.getDtdValidation();
        }
        if ("expandAttributeDefaults".equals(name)) {
            return this.getExpandAttributeDefaults();
        }
        if ("expandXInclude".equals(name)) {
            return this.getExpandXInclude();
        }
        if ("retainLineNumbers".equals(name)) {
            return this.getRetainLineNumbers();
        }
        if ("schemaValidationMode".equals(name)) {
            return this.getSchemaValidationMode();
        }
        if ("stripWhitespace".equals(name)) {
            return this.getStripWhitespace();
        }
        if ("useXsiSchemaLocation".equals(name)) {
            return this.getUseXsiSchemaLocation();
        }
        if ("xmlVersion".equals(name)) {
            return this.getXmlVersion();
        }
        if ("xsdVersion".equals(name)) {
            return this.getXsdVersion();
        }
        throw new XQException("Property " + name + " is not recognized");
    }

    @Override
    public String[] getSupportedPropertyNames() {
        return supportedPropertyNames;
    }

    @Override
    public void setLoginTimeout(int seconds) throws XQException {
    }

    @Override
    public void setLogWriter(PrintWriter out) throws XQException {
        this.logger = out;
    }

    @Override
    public void setProperties(Properties props) throws XQException {
        SaxonXQDataSource.checkNotNull(props, "props");
        Enumeration<Object> iter = props.keys();
        while (iter.hasMoreElements()) {
            String name = (String)iter.nextElement();
            String value = props.getProperty(name);
            this.setProperty(name, value);
        }
    }

    @Override
    public void setProperty(String name, String value) throws XQException {
        block12: {
            try {
                if ("allowExternalFunctions".equals(name)) {
                    this.setAllowExternalFunctions(value);
                    break block12;
                }
                if ("dtdValidation".equals(name)) {
                    this.setDtdValidation(value);
                    break block12;
                }
                if ("expandAttributeDefaults".equals(name)) {
                    this.setExpandAttributeDefaults(value);
                    break block12;
                }
                if ("expandXInclude".equals(name)) {
                    this.setExpandXInclude(value);
                    break block12;
                }
                if ("retainLineNumbers".equals(name)) {
                    this.setRetainLineNumbers(value);
                    break block12;
                }
                if ("schemaValidationMode".equals(name)) {
                    this.setSchemaValidationMode(value);
                    break block12;
                }
                if ("stripWhitespace".equals(name)) {
                    this.setStripWhitespace(value);
                    break block12;
                }
                if ("useXsiSchemaLocation".equals(name)) {
                    this.setUseXsiSchemaLocation(value);
                    break block12;
                }
                if ("xmlVersion".equals(name)) {
                    this.setXmlVersion(value);
                    break block12;
                }
                if ("xsdVersion".equals(name)) {
                    this.setXsdVersion(value);
                    break block12;
                }
                throw new XQException("Property " + name + " is not recognized");
            }
            catch (IllegalArgumentException err) {
                throw new XQException("Invalid value for " + name + ": " + err.getMessage());
            }
        }
    }

    static void checkNotNull(Object arg, String name) throws XQException {
        if (arg == null) {
            throw new XQException("Argument " + name + " is null");
        }
    }

    public void setAllowExternalFunctions(String value) {
        if ("true".equals(value)) {
            this.config.setAllowExternalFunctions(true);
        } else if ("false".equals(value)) {
            this.config.setAllowExternalFunctions(false);
        } else {
            throw new IllegalArgumentException("allowExternalFunctions");
        }
    }

    public String getAllowExternalFunctions() {
        return this.config.isAllowExternalFunctions() ? "true" : "false";
    }

    public void setDtdValidation(String value) {
        if ("true".equals(value)) {
            this.config.setValidation(true);
        } else if ("false".equals(value)) {
            this.config.setValidation(false);
        } else {
            throw new IllegalArgumentException("dtdValidation");
        }
    }

    public String getDtdValidation() {
        return this.config.isValidation() ? "true" : "false";
    }

    public void setExpandAttributeDefaults(String value) {
        if ("true".equals(value)) {
            this.config.setExpandAttributeDefaults(true);
        } else if ("false".equals(value)) {
            this.config.setExpandAttributeDefaults(false);
        } else {
            throw new IllegalArgumentException("expandAttributeDefaults");
        }
    }

    public String getExpandAttributeDefaults() {
        return this.config.isExpandAttributeDefaults() ? "true" : "false";
    }

    public void setExpandXInclude(String value) {
        if ("true".equals(value)) {
            this.config.setXIncludeAware(true);
        } else if ("false".equals(value)) {
            this.config.setXIncludeAware(false);
        } else {
            throw new IllegalArgumentException("expandXInclude");
        }
    }

    public String getExpandXInclude() {
        return this.config.isXIncludeAware() ? "true" : "false";
    }

    public void setRetainLineNumbers(String value) {
        if ("true".equals(value)) {
            this.config.setLineNumbering(true);
        } else if ("false".equals(value)) {
            this.config.setLineNumbering(false);
        } else {
            throw new IllegalArgumentException("retainLineNumbers");
        }
    }

    public String getRetainLineNumbers() {
        return this.config.isLineNumbering() ? "true" : "false";
    }

    public void setSchemaValidationMode(String value) {
        if ("strict".equals(value)) {
            this.config.setSchemaValidationMode(1);
        } else if ("lax".equals(value)) {
            this.config.setSchemaValidationMode(2);
        } else if ("skip".equals(value)) {
            this.config.setSchemaValidationMode(4);
        } else {
            throw new IllegalArgumentException("schemaValidationMode");
        }
    }

    public String getSchemaValidationMode() {
        return Validation.toString(this.config.getSchemaValidationMode());
    }

    public void setStripWhitespace(String value) {
        if ("all".equals(value)) {
            this.config.setStripsWhiteSpace(2);
        } else if ("ignorable".equals(value)) {
            this.config.setStripsWhiteSpace(1);
        } else if ("none".equals(value)) {
            this.config.setStripsWhiteSpace(0);
        } else {
            throw new IllegalArgumentException("stripWhitespace");
        }
    }

    public String getStripWhitespace() {
        switch (this.config.getStripsWhiteSpace()) {
            case 2: {
                return "all";
            }
            case 1: {
                return "ignorable";
            }
        }
        return "none";
    }

    public void setUseXsiSchemaLocation(String value) {
        if ("true".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation", BooleanValue.TRUE);
        } else if ("false".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation", BooleanValue.FALSE);
        } else {
            throw new IllegalArgumentException("useXsiSchemaLocation");
        }
    }

    public String getUseXsiSchemaLocation() {
        Boolean b = (Boolean)this.config.getConfigurationProperty("http://saxon.sf.net/feature/useXsiSchemaLocation");
        return b != false ? "true" : "false";
    }

    public void setXmlVersion(String value) {
        if ("1.0".equals(value)) {
            this.config.setXMLVersion(10);
        } else if ("1.1".equals(value)) {
            this.config.setXMLVersion(11);
        } else {
            throw new IllegalArgumentException("xmlVersion");
        }
    }

    public String getXmlVersion() {
        return this.config.getXMLVersion() == 10 ? "1.0" : "1.1";
    }

    public void setXsdVersion(String value) {
        if ("1.0".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", "1.0");
        } else if ("1.1".equals(value)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", "1.1");
        } else {
            throw new IllegalArgumentException("xsdVersion");
        }
    }

    public String getXsdVersion() {
        return (String)this.config.getConfigurationProperty("http://saxon.sf.net/feature/xsd-version");
    }

    public void registerExtensionFunction(ExtensionFunctionDefinition function) {
        try {
            this.config.registerExtensionFunction(function);
        }
        catch (Exception err) {
            throw new IllegalArgumentException(err);
        }
    }
}

