/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.server.fuse.ui.runtime.fuseesb;

import java.io.File;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.fusesource.ide.server.fuse.ui.Messages;
import org.fusesource.ide.server.karaf.ui.runtime.KarafWizardDataModel;
import org.fusesource.ide.server.karaf.ui.runtime.v2x.KarafRuntimeComposite2x;

public class FuseESBRuntimeComposite6x
extends KarafRuntimeComposite2x {
    private static final String LIB_FUSE_VERSION_JAR = String.format("%s%s%s", "lib", SEPARATOR, "esb-version.jar");

    public FuseESBRuntimeComposite6x(Composite parent, IWizardHandle wizardHandle, KarafWizardDataModel model) {
        super(parent, wizardHandle, model);
        wizardHandle.setTitle(Messages.FuseESBRuntimeComposite_wizard_tite);
        wizardHandle.setDescription(Messages.FuseESBRuntimeComposite_wizard_desc);
    }

    protected boolean doClassPathEntiresExist(String karafInstallDir) {
        File libESBVersionJar = new File(String.format("%s%s%s", karafInstallDir, SEPARATOR, LIB_FUSE_VERSION_JAR));
        return super.doClassPathEntiresExist(karafInstallDir) && libESBVersionJar.exists();
    }

    public boolean validate() {
        this.valid = super.validate();
        if (this.valid) {
            String dirLocation = this.txtKarafDir.getText().trim();
            if (dirLocation != null && !"".equals(dirLocation)) {
                File file = new File(dirLocation);
                if (!file.exists()) {
                    this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_no_dir, 3);
                } else if (!file.isDirectory()) {
                    this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_not_a_dir, 3);
                } else {
                    File binFuse = new File(String.valueOf(dirLocation) + SEPARATOR + Messages.FuseESBRuntimeComposite_bin_fuseesb);
                    File binFuseBat = new File(String.valueOf(dirLocation) + SEPARATOR + Messages.FuseESBRuntimeComposite_bin_fuseesb_bat);
                    if (binFuse.exists() || binFuseBat.exists()) {
                        this.valid = true;
                        this.wizardHandle.setMessage("", 0);
                    } else {
                        this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_invalid_dir, 3);
                    }
                }
            } else {
                this.wizardHandle.setMessage(Messages.AbstractKarafRuntimeComposite_wizard_help_msg, 0);
            }
        }
        return this.valid;
    }

    public void handleEvent(Event event) {
        boolean valid = false;
        if (event.type == 15) {
            this.handleFocusEvent(event);
        } else if (event.widget == this.txtKarafDir && (valid = this.validate())) {
            String installDir = this.txtKarafDir.getText();
            this.model.setKarafInstallDir(installDir);
        }
        this.wizardHandle.update();
    }
}

