/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.runtime.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.core.designer.util.FileUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.runtime.DqpPlugin;
import org.teiid.designer.runtime.importer.Messages;
import org.teiid.designer.runtime.spi.ITeiidServer;
import org.teiid.designer.runtime.spi.ITeiidServerManager;
import org.teiid.designer.runtime.ui.DqpUiConstants;
import org.teiid.designer.runtime.ui.DqpUiPlugin;
import org.teiid.designer.runtime.ui.actions.DeployVdbAction;
import org.teiid.designer.runtime.ui.connection.CreateVdbDataSourceAction;
import org.teiid.designer.runtime.ui.vdb.DeployVdbDialog;
import org.teiid.designer.runtime.ui.vdb.VdbAgeChecker;
import org.teiid.designer.runtime.ui.vdb.VdbRequiresSaveChecker;
import org.teiid.designer.ui.actions.ISelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.vdb.Vdb;
import org.teiid.designer.vdb.XmiVdb;

public class DeployDynamicVdbAction
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction {
    static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(DeployVdbAction.class);
    private final Collection<IFile> selectedVDBs = new ArrayList<IFile>();
    Properties designerProperties;
    static String failedModelName = null;

    public DeployDynamicVdbAction() {
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/deployVdb.png"));
    }

    public DeployDynamicVdbAction(Properties properties) {
        this.setImageDescriptor(DqpUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/deployVdb.png"));
        this.designerProperties = properties;
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    public boolean isApplicable(ISelection selection) {
        List objs = SelectionUtilities.getSelectedObjects((ISelection)selection);
        if (objs.isEmpty()) {
            return false;
        }
        for (Object obj : objs) {
            if (obj instanceof IFile) {
                String extension = ((IFile)obj).getFileExtension();
                if (extension != null && extension.equalsIgnoreCase("XML")) continue;
                return false;
            }
            return false;
        }
        ITeiidServer teiidServer = DeployDynamicVdbAction.getServerManager().getDefaultServer();
        return teiidServer != null;
    }

    public void run() {
        if (!this.checkForConnectedServer()) {
            return;
        }
        ITeiidServer teiidServer = DeployDynamicVdbAction.getServerManager().getDefaultServer();
        for (IFile nextVDBFile : this.selectedVDBs) {
            Shell shell;
            boolean doDeploy = VdbRequiresSaveChecker.insureOpenVdbSaved(nextVDBFile);
            if (doDeploy) {
                doDeploy = VdbAgeChecker.doDeploy(nextVDBFile, teiidServer.getServerVersion());
            }
            if (!doDeploy) continue;
            boolean deploySuccess = this.deployVdb(teiidServer, nextVDBFile);
            String vdbName = FileUtils.getNameWithoutExtension((IResource)nextVDBFile);
            try {
                if (!teiidServer.hasVdb(vdbName)) {
                    deploySuccess = false;
                    break;
                }
            }
            catch (Exception ex) {
                DqpPlugin.Util.log((Throwable)ex);
                shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
                String title = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "problemDeployingVdbDataSource.title", new Object[]{vdbName, teiidServer});
                String message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "problemDeployingVdbDataSource.msg", new Object[]{vdbName, teiidServer});
                ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)new Status(4, "org.teiid.designer.dqp.ui", message, (Throwable)ex));
            }
            if (!deploySuccess) continue;
            try {
                CreateVdbDataSourceAction.doCreateDataSource(vdbName, teiidServer, true);
            }
            catch (Exception ex) {
                shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
                MessageDialog.openError((Shell)shell, (String)DqpUiConstants.UTIL.getString("CreateVdbDataSourceAction.errorCreatingDataSourceForVDB", (Object)vdbName), (String)ex.getMessage());
                DqpUiConstants.UTIL.log(4, (Throwable)ex, DqpUiConstants.UTIL.getString("CreateVdbDataSourceAction.errorCreatingDataSourceForVDB", (Object)vdbName));
            }
        }
    }

    public void queryUserAndRun() {
        if (!this.checkForConnectedServer()) {
            return;
        }
        ITeiidServer teiidServer = DeployDynamicVdbAction.getServerManager().getDefaultServer();
        DeployVdbDialog dialog = new DeployVdbDialog(DqpUiPlugin.getDefault().getCurrentWorkbenchWindow().getShell(), this.designerProperties);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            IFile vdb = dialog.getSelectedVdb();
            boolean doCreateDS = dialog.doCreateVdbDataSource();
            String jndiName = dialog.getVdbDataSourceJndiName();
            if (vdb != null) {
                boolean doDeploy = VdbRequiresSaveChecker.insureOpenVdbSaved(vdb);
                if (doDeploy) {
                    this.deployVdb(teiidServer, vdb, true);
                }
                String vdbName = FileUtils.getNameWithoutExtension((IResource)vdb);
                try {
                    if (teiidServer.hasVdb(vdbName) && doCreateDS) {
                        this.createVdbDataSource(vdb, jndiName, jndiName);
                    }
                }
                catch (Exception ex) {
                    DqpPlugin.Util.log((Throwable)ex);
                    Shell shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
                    String title = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "problemDeployingVdbDataSource.title", new Object[]{vdbName, teiidServer});
                    String message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "problemDeployingVdbDataSource.msg", new Object[]{vdbName, teiidServer});
                    ErrorDialog.openError((Shell)shell, (String)title, null, (IStatus)new Status(4, "org.teiid.designer.dqp.ui", message, (Throwable)ex));
                }
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.selectedVDBs.clear();
        boolean enable = this.isApplicable(selection);
        if (this.isEnabled() != enable) {
            this.setEnabled(enable);
        }
        if (this.isEnabled()) {
            List objs = SelectionUtilities.getSelectedObjects((ISelection)selection);
            this.selectedVDBs.addAll(objs);
        }
    }

    private boolean checkForConnectedServer() {
        ITeiidServer teiidServer = DeployDynamicVdbAction.getServerManager().getDefaultServer();
        if (teiidServer == null || !teiidServer.isConnected()) {
            Shell shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
            String title = DqpUiConstants.UTIL.getString("ActionRequiresServer.title", new Object[0]);
            String msg = DqpUiConstants.UTIL.getString("ActionRequiresServer.msg", new Object[0]);
            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
            return false;
        }
        return true;
    }

    private static ITeiidServerManager getServerManager() {
        return DqpPlugin.getInstance().getServerManager();
    }

    public boolean deployVdb(ITeiidServer teiidServer, Object vdbXmlFile) {
        return this.deployVdb(teiidServer, vdbXmlFile, DeployDynamicVdbAction.shouldAutoCreateDataSource());
    }

    public boolean deployVdb(ITeiidServer teiidServer, final Object vdbXmlFile, boolean doCreateDataSource) {
        DynamicVdbDeployer deployer;
        Shell shell;
        block5: {
            shell = UiUtil.getWorkbenchShellOnlyIfUiThread();
            deployer = new DynamicVdbDeployer();
            try {
                if (!(vdbXmlFile instanceof IFile)) {
                    throw new IllegalArgumentException(DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "selectionIsNotAVdb", new Object[0]));
                }
                if (teiidServer.isConnected()) break block5;
                return false;
            }
            catch (Throwable e) {
                if (e instanceof InvocationTargetException) {
                    e = ((InvocationTargetException)e).getCause();
                }
                String vdbName = ((IFile)vdbXmlFile).getName();
                String message = DqpUiConstants.UTIL.getString(String.valueOf(I18N_PREFIX) + "problemDeployingVdbToServer", new Object[]{vdbName, teiidServer});
                DqpUiConstants.UTIL.log(e);
                ErrorDialog.openError((Shell)shell, (String)message, null, (IStatus)new Status(4, "org.teiid.designer.dqp.ui", message, e));
                return false;
            }
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    deployer.deployDynamicVdb((IFile)vdbXmlFile, monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        dialog.run(true, false, runnable);
        return true;
    }

    static boolean shouldAutoCreateDataSource() {
        return DqpPlugin.getInstance().getPreferences().getBoolean("org.teiid.designer.dqp.preferences.AutoCreateDataSource", true);
    }

    private void createVdbDataSource(Object vdbOrVdbFile, String displayName, String jndiName) throws Exception {
        XmiVdb vdb = vdbOrVdbFile instanceof IFile ? new XmiVdb((IFile)vdbOrVdbFile) : (Vdb)vdbOrVdbFile;
        ITeiidServer teiidServer = DeployDynamicVdbAction.getServerManager().getDefaultServer();
        String vdbName = vdb.getName();
        teiidServer.createVdbDataSource(vdbName, displayName, jndiName);
    }

    class DynamicVdbDeployer {
        DynamicVdbDeployer() {
        }

        public IStatus deployDynamicVdb(IFile xmlFile, IProgressMonitor monitor) {
            IStatus resultStatus = Status.OK_STATUS;
            String dynamicVdbString = this.createDynamicVdbString(xmlFile);
            try {
                ITeiidServer teiidServer = DeployDynamicVdbAction.getServerManager().getDefaultServer();
                teiidServer.deployDynamicVdb(xmlFile.getName(), (InputStream)new ByteArrayInputStream(dynamicVdbString.getBytes("UTF-8")));
            }
            catch (Exception exception) {
                resultStatus = new Status(4, "org.teiid.designer.dqp", NLS.bind((String)Messages.ImportManagerDeployVdbError, (Object)xmlFile.getName()));
                return resultStatus;
            }
            return resultStatus;
        }

        public String createDynamicVdbString(IFile xmlFile) {
            File file = new File(xmlFile.getLocation().makeAbsolute().toOSString());
            String value = "<unknown>";
            try {
                value = FileUtil.readSafe((File)file);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            return value;
        }
    }
}

